;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# menu functions								#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
menu_mainloop:	libmio_nokey
menu_main:	ldi	XL,0			;black
		libmio_setborder
		ldi	XL,1
		libmio_chpump			;enable chargepump for serial
		clr	ctrl			;normal mode
		sts	libmio_channel,const_0	;output to screen
		clr	XL
		libmio_setvmode			;standard video mode
		ldi	XL,0x05			;color scheme (cyan on black)
		libmio_setcolor
		libmio_clrscr
		ldi	YL,0			;maximal sized box
		ldi	YH,0
		ldi	ZL,29
		ldi	ZH,21
		libmio_whbox
		ldi	YL,LOW(libmio_vram+19*30)
		ldi	YH,HIGH(libmio_vram+19*30)
		ldi	XL,0xf8
		st	Y+,XL
		ldi	XL,0xf1
		ldi	XH,28
menu_main_li:	st	Y+,XL
		dec	XH
		brne	menu_main_li
		ldi	XL,0xf9
		st	Y+,XL
		ldi	XL,0x51			;color scheme (blue on white)
		libmio_setcolor
		ldi	XL,4
		ldi	XH,1
		libmio_gotoxy
		rcall	menu_itext1

		rcall	menu_stat
		lds	tempreg1,libmio_lastmenu
		cpi	tempreg1,0x0b		;
		brcs	menu_main_0
		clr	tempreg1

menu_main_0:	sts	libmio_lastmenu,tempreg1
		mov	tempreg3,tempreg1	;set as default
menu_main_1:	sbrc	tempreg3,7		;is below zero
		clr	tempreg3		;set to zero
		cpi	tempreg3,0x0b		;maximum+1
		brcs	menu_main_2
		ldi	tempreg3,0x0a		;limit to max

menu_main_2:	ldi	r18,0x00		;prg icon counter
menu_main_3:	push	tempreg3
		rcall	menu_prgicon		;draw program icon
		pop	tempreg3
		inc	r18
		cpi	r18,0x08		;beyond limit?
		brne	menu_main_3
		rcall	menu_memicon		;dataflash
		rcall	menu_cfgicon		;config
		rcall	menu_inficon		;info

menu_main_4:	ldi	ZL,LOW(menu_data*2)
		ldi	ZH,HIGH(menu_data*2)
		libmio_menu

		cpi	tempreg1,0xe2		;left
		brne	menu_main_5
		dec	tempreg3		;change to n-1
		rjmp	menu_main_1		;loop

menu_main_5:	cpi	tempreg1,0xe3		;right
		brne	menu_main_6
		inc	tempreg3		;change to n+1
		rjmp	menu_main_1

menu_main_6:	cpi	tempreg1,0xe4		;up
		brne	menu_main_7
		cpi	tempreg3,0x04
		brcs	menu_main_7
		subi	tempreg3,0x04		;change to n-4
		rjmp	menu_main_1

menu_main_7:	cpi	tempreg1,0xe5		;down
		brne	menu_main_8
		cpi	tempreg3,0x07
		brcc	menu_main_8
		subi	tempreg3,0xfc		;change to n+4
		rjmp	menu_main_1

menu_main_8:	cpi	tempreg1,0xea		;enter
		breq	menu_main_9
		cpi	tempreg1,0x05		;run
		brne	menu_main_20
menu_main_9:	cpi	tempreg3,0x08		;program
		brcs	menu_main_14		;branch if yes
		brne	menu_main_10
		libmio_nokey
		call	fman_main
		rjmp	menu_mainloop

menu_main_10:	cpi	tempreg3,0x09		;config
		brne	menu_main_11
		rcall	menu_wnk
		call	confp_main		;call config
		rjmp	menu_mainloop

menu_main_11:	libmio_nokey
		call	infopage_main		;call info
		rjmp	menu_mainloop
;a program
menu_main_14:	rcall	menu_wnk0
		clr	ereg
		call	menu_runprog		;run pogram
		rjmp	menu_mainloop

menu_main_20:	cpi	tempreg3,0x08		;program
		brcc	menu_main_4		;branch if not

menu_main_22:	cpi	tempreg1,0x02		;edit
		brne	menu_main_23
		rcall	menu_wnk0
		clr	ereg
		call	menu_editloop		;edit program
		rjmp	menu_mainloop

menu_main_23:	cpi	tempreg1,0x03		;save
		brne	menu_main_24
		rcall	menu_wnk0
		call	fsys_savebas
		rjmp	menu_mainloop

menu_main_24:	cpi	tempreg1,0x04		;load
		brne	menu_main_40
		rcall	menu_wnk0
		call	fsys_loadbas		;edit program
		call	editor_pclear
		rjmp	menu_mainloop

menu_main_40:	cpi	tempreg1,0x07		;copy
		brne	menu_main_41
		rcall	menu_wnk0
		call	menu_copy		;copy program
		rjmp	menu_mainloop

menu_main_41:	cpi	tempreg1,0x08		;recv
		brne	menu_main_42
		rcall	menu_wnk0
		call	fsys_tal
		call	send_prog		;send program
		rjmp	menu_mainloop

menu_main_42:	cpi	tempreg1,0x09		;send
		brne	menu_main_43
		rcall	menu_wnk0
		call	fsys_tal
		call	recv_prog		;receive program
		call	editor_pclear
		rjmp	menu_mainloop

menu_main_43:	cpi	tempreg1,0x0a		;clear
		brne	menu_main_44
		rcall	menu_wnk0
		call	menu_clear		;clear program
		call	editor_pclear
		rjmp	menu_mainloop

menu_main_44:	rjmp	menu_main_4		;no valid key

;------------------------------------------------------------------------------
;info text (version)
;------------------------------------------------------------------------------
menu_itext1:	ldi	ZL,LOW(ver_text*2)
		ldi	ZH,HIGH(ver_text*2)
		libmio_romtext
		ret

;------------------------------------------------------------------------------
;info text (version)
;------------------------------------------------------------------------------
menu_revtext:	ldi	XL,0
		ldi	XH,23
		libmio_gotoxy
		ldi	ZL,LOW(rev_text*2)
		ldi	ZH,HIGH(rev_text*2)
		libmio_romtext
		ret

;------------------------------------------------------------------------------
;wait for key release
;------------------------------------------------------------------------------
menu_wnk0:	sts	libmio_lastmenu,tempreg3
menu_wnk:	lds	XL,libmio_keycode
		cpi	XL,0
		brne	menu_wnk		;wait for key release
		ret

;------------------------------------------------------------------------------
;draw program icon (r18=number, tempreg3=invert 0/1)
;------------------------------------------------------------------------------
menu_prgicon:	ldi	XL,0x01			;X coord of icon 0
		ldi	XH,0x03			;Y coord of icon 0
		sbrc	r18,0
		subi	XL,0xf9			;X+7
		sbrc	r18,1
		subi	XL,0xf2			;X+14
		sbrc	r18,2
		subi	XH,0xfa			;Y+6
		mov	tempreg1,r18
		call	mem_readf1
		cpi	tempreg1,'B'		;type byte
		brne	menu_pric_ld
		clt				;standard icon
		ldi	tempreg1,0x0e		;white on black
		lpm	r16,Z			;first byte
		cpi	r16,0x5f		;non-startable
		brne	menu_pric_drw		;no
		ldi	tempreg1,0x0c		;yellow on black
		rjmp	menu_pric_drw

;binary file
menu_pric_ld:
menu_pric_bin:	mov	tempreg1,tempreg2	;copy flag byte
		lsl	tempreg1
		bst	tempreg1,4
		andi	tempreg1,0x0e		;mask bits
		bld	tempreg1,0
		set

;draw program icon
menu_pric_drw:	cp	tempreg3,r18		;selected?
		brne	menu_pric_dw1		;no
		swap	tempreg1		;invert color
menu_pric_dw1:	sts	libmio_color,tempreg1	;set color
		libmio_gotoxy
		brts	menu_pric_dw4		;branch if bin icon
		libmio_thistext
		.db	255,0x20,0x20,0
		ldi	tempreg1,'P'
		libmio_outchar
		mov	tempreg1,r18		;prg number
		subi	tempreg1,0xcf		;+0x31
		libmio_outchar
		libmio_thistext
		.db	255,0x20,0x20,0
		inc	XH
		libmio_gotoxy
		libmio_thistext
		.db	255,0x20,0x20,0xd0,0xd1,0x20,0x20,0
		inc	XH
		libmio_gotoxy
		libmio_thistext
		.db	255,0x20,0x20,0xd2,0xd3,0x20,0x20,0
		inc	XH
		rjmp	menu_prgi_e		;now output text

menu_pric_dw4:	adiw	ZL,16			;start of icon
		libmio_gotoxy
		ldi	r17,3
menu_prgi_01:	ldi	r16,4
		libmio_outspace
menu_prgi_02:	lpm	tempreg1,Z+
		libmio_outchar
		dec	r16
		brne	menu_prgi_02
		libmio_outspace
		inc	XH
		libmio_gotoxy
		dec	r17
		brne	menu_prgi_01

menu_prgi_e:	mov	tempreg1,r18
		call	mem_progadr_0		;start address
		libmio_gotoxy
		ldi	tempreg3,0x06		;chars per line
menu_prgicon_1:	lpm	tempreg1,Z+
		libmio_outchar
		dec	tempreg3
		brne	menu_prgicon_1
		inc	XH
		libmio_gotoxy
		ldi	tempreg3,0x06		;chars per line
menu_prgicon_2:	lpm	tempreg1,Z+
		libmio_outchar
		dec	tempreg3
		brne	menu_prgicon_2
		ret

;------------------------------------------------------------------------------
;draw info icon (X=coord)
;------------------------------------------------------------------------------
menu_inficon:	ldi	tempreg1,0x0a		;cyan on black
		cpi	tempreg3,0x0a
		brne	menu_inficon_1
		swap	tempreg1
menu_inficon_1:	sts	libmio_color,tempreg1
		libmio_thistext
		.db	15,15,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		libmio_thistext
		.db	16,15,0x20,0x20,0xd4,0xd5,0x20,0x20,0,0
		libmio_thistext
		.db	17,15,0x20,0x20,0xd6,0xd7,0x20,0x20,0,0
		libmio_thistext
		.db	18,15," INFO ",0,0
		ret

;------------------------------------------------------------------------------
;draw stat
;------------------------------------------------------------------------------
menu_stat:	ldi	tempreg1,0x0a		;cyan on black
menu_stat_1:	sts	libmio_color,tempreg1
		libmio_thistext
		.db	20,2,"MCU:644",0
menu_gettype:	ldi	ZL,0xcc			;UBRR1L
		clr	ZH
		ld	tempreg1,Z
		ldi	r18,0xa5
		st	Z,r18
		ld	r18,Z
		st	Z,tempreg1
		ldi	tempreg1,' '
		cpi	r18,0xa5
		brne	menu_m644
		ldi	tempreg1,'P'
menu_m644:	libmio_outchar


menu_stat_1a:	libmio_thistext
		.db	20,22,"KBD:",0,0
		ldi	ZL,LOW(libmio_ktables*2+256)
		ldi	ZH,HIGH(libmio_ktables*2+256)
		lpm	tempreg1,Z
		libmio_outchar
		subi	ZL,0x80
		lpm	tempreg1,Z
		libmio_outchar
		libmio_thistext
		.db	20,12,"VID:",0,0
		lds	tempreg4,libmio_config
		sbrc	tempreg4,2
		rjmp	menu_stat_2
		libmio_thistext
		.db	255,"NTSC",0
		rjmp	menu_stat_3
menu_stat_2:	libmio_thistext
		.db	255,"PAL ",0
menu_stat_3:	ret


;------------------------------------------------------------------------------
;draw conf icon (X=coord)
;------------------------------------------------------------------------------
menu_cfgicon:	ldi	tempreg1,0x08		;green on black
		cpi	tempreg3,0x09
		brne	menu_cfgicon_1
		swap	tempreg1
menu_cfgicon_1:	sts	libmio_color,tempreg1
		libmio_thistext
		.db	15,8,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		libmio_thistext
		.db	16,8,0x20,0x20,0xd8,0xd9,0x20,0x20,0,0
		libmio_thistext
		.db	17,8,0x20,0x20,0xda,0xdb,0x20,0x20,0,0
		libmio_thistext
		.db	18,8,"CONFIG",0,0
		ret


;------------------------------------------------------------------------------
;draw flash icon (X=coord)
;------------------------------------------------------------------------------
menu_memicon:	ldi	tempreg1,0x0c		;yellow on black
		cpi	tempreg3,0x08
		brne	menu_memicon_1
		swap	tempreg1
menu_memicon_1:	sts	libmio_color,tempreg1
		libmio_thistext
		.db	15,1,0x20,0x20,0x20,0x20,0x20,0x20,0,0
		libmio_thistext
		.db	16,1,0x20,0x20,0xdc,0xdd,0x20,0x20,0,0
		libmio_thistext
		.db	17,1,0x20,0x20,0xde,0xdf,0x20,0x20,0,0
		libmio_thistext
		.db	18,1,"DFLASH",0,0
		ret

;------------------------------------------------------------------------------
;copy program
;------------------------------------------------------------------------------
menu_copy:	ldi	XL,0x04			;color scheme (green on black)
		libmio_setcolor
		ldi	YL,1			;maximal sized box
		ldi	YH,14
		ldi	ZL,28
		ldi	ZH,18
		libmio_whbox
		ldi	XL,0x40			;color scheme (black on green)
		libmio_setcolor
		call	editor_pclear
		libmio_thistext
		.db 15,2,"Copy Program to",0
		lds	tempreg4,libmio_lastmenu	;active number
menu_copy_1:	ldi	tempreg3,0		
menu_copy_2:	ldi	XL,0x0c			;color scheme (yellow on black)
		cp	tempreg3,tempreg4
		brne	menu_copy_3
		ldi	XL,0x60			;color scheme (black on yellow)
menu_copy_3:	libmio_setcolor
		ldi	XH,17
		mov	XL,tempreg3
		lsl	XL
		add	XL,tempreg3
		subi	XL,-3
		libmio_gotoxy
		ldi	tempreg1,'P'
		libmio_outchar
		mov	tempreg1,tempreg3
		andi	tempreg1,0x07
		subi	tempreg1,-49
		libmio_outchar
		inc	tempreg3
		cpi	tempreg3,0x08
		brne 	menu_copy_2
menu_copy_4:	libmio_waitkey
		cpi	tempreg1,0xe2		;left
		brne	menu_copy_5
		cpi	tempreg4,0x00
		breq	menu_copy_4
		dec	tempreg4
		rjmp	menu_copy_1

menu_copy_5:	cpi	tempreg1,0xe3		;right
		brne	menu_copy_6
		cpi	tempreg4,0x07
		breq	menu_copy_4
		inc	tempreg4
		rjmp	menu_copy_1

menu_copy_6:	cpi	tempreg1,0xea		;enter
		brne	menu_copy_7
		call	mem_copy
		ret

menu_copy_7:	cpi	tempreg1,0xed		;esc
		brne	menu_copy_4
		ret

;------------------------------------------------------------------------------
;clear program
;------------------------------------------------------------------------------
menu_clear:	ldi	XL,0x2f			;color scheme (white on red)
		libmio_setcolor
		ldi	YL,1			;maximal sized box
		ldi	YH,14
		ldi	ZL,28
		ldi	ZH,18
		libmio_wbox
		call	editor_pclear
		libmio_thistext
		.db 16,2,"Clear this program (y/n)?",0
menu_clear_1:	libmio_waitkey
		cpi	tempreg1,'y'
		breq	menu_clear_y
		cpi	tempreg1,'n'
		breq	menu_clear_n
		cpi	tempreg1,0xed		;ESC
		breq	menu_clear_n
		rjmp	menu_clear_1

menu_clear_y:	call	mem_clear
menu_clear_n:	ret

;------------------------------------------------------------------------------
; editor loop
;------------------------------------------------------------------------------
menu_editloop:	libmio_nokey
		call	mem_readfirst
		cpi	tempreg1,'N'		;native
		breq	menu_editloop0
		cpi	tempreg1,'L'		;loader
		breq	menu_editloop0
		call	editor_main
		sts	libmio_kflags,const_0
		lds	XL,libmio_lastkey
		cpi	XL,0xf4			;F4
		breq	menu_editloop1
menu_editloop0:	rjmp	menu_main
menu_editloop1:	call	mem_readfirst
		lpm	tempreg1,Z
		cpi	tempreg1,0x5f		;plain text
		breq	menu_editloop
		rcall	menu_runprog		;run program
		call	mem_getconf
		libmio_sysconf
		clr	XL
		libmio_setvmode
menu_editloop3:	rjmp	menu_editloop

;------------------------------------------------------------------------------
;run program
;------------------------------------------------------------------------------
menu_runprog:	libmio_clrscr			;clear screen from menu
		call	sys_extsearch
		clr	ereg			;clear error flag
		sts	libmio_keycode,const_0	;clear keyboard
		call	mem_progadr		;start address
		lpm	tempreg1,Z
		cpi	tempreg1,0x5f		;plain text
		breq	menu_rp0		;cannot start this
		adiw	ZL,12
		lpm	tempreg1,Z+		;get type
		cpi	tempreg1,'B'		;BASIC
		breq	menu_runprg_0		;run BAS program
		cpi	tempreg1,'N'		;native
		brne	menu_rp0		;do nothing
		lpm	tempreg1,Z+		;get flag byte
		sbrc	tempreg1,4		;skip if run flag is set
		ret
menu_runn:	lsr	ZH
		ldi	ZL,0x10
		icall				;call prg
		call	mem_getconf
		libmio_sysconf
menu_rp0:	ret				;goto menu

menu_runprg_0:	call	tbrun			;run programm
		call	mem_getconf
		libmio_sysconf
		sts	libmio_font,const_0
		sts	libmio_seqspeed,const_0	;stop sequencer
		lds	XL,libmio_config
		andi	XL,0x7f			;scroll mode
		sts	libmio_config,XL
		sts	libmio_channel,const_0	;set output to screen
		libmio_slow			;set video on

menu_runprog3:	sbrc	vline_l,3
		ldi	XL,0xee			;white
		sbrs	vline_l,3
		ldi	XL,0x44			;red
		sts	libmio_border,XL
menu_runprog4:	lds	XL,libmio_kflags
		sbrc	XL,1
		rjmp	menu_runprog6
		lds	XL,libmio_keycode
		cpi	XL,0xed			;esc
		brne	menu_runprog3		;wait for esc key
menu_runprog5:	libmio_nokey
		ret

menu_runprog6:	sts	libmio_border,const_0
		libmio_screenshot
		rjmp	menu_runprog3


			;111111222222333333444444555555
menu_data:	.db	"       Edit  Save  Load  Run  ",3,0	;2 levels, all keys
menu_cdata:	.db	"       Copy  Send  Recv  Clear"