;################################################################################
;#										#
;# chipbasic2 - single chip basic computer with ATMega 644			#
;# intro screen									#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;intro screen
;------------------------------------------------------------------------------
intro_main:	ldi	XL,0x01
		libmio_setborder
		clr	ctrl			;normal size
		ldi	XL,0x10			;black on blue
		libmio_setcolor			;set color
		libmio_clrscr			;clear screen
		ldi	YL,4
		ldi	YH,10
		ldi	ZL,55
		ldi	ZH,23
		libmio_fbox

		ldi	XL,0x07			;white on black
		libmio_setcolor			;set color
		libmio_thistext
		.db	7,4," ",0
		rcall	menu_itext1		;show version number
		ldi	XL,0x16
		libmio_setcolor			;set color
		rcall	menu_revtext		;show Revision number

		ldi	YL,5			;X1
		ldi	YH,8			;Y1
		ldi	ZL,6			;X2
		ldi	ZH,9			;Y2
intro_main_1:	libmio_fbox

		ldi	YH,24
		ldi	ZH,25
		libmio_fbox
		ldi	YH,8
		ldi	ZH,9
		subi	YL,0xfc			;X1+4
		subi	ZL,0xfc			;X2+4
		cpi	YL,56
		brcs	intro_main_1

		ldi	tempreg3,180		;wait 3 seconds

intro_main_w:	libmio_sync
		lds	tempreg1,libmio_kbdstate
		sbrc	tempreg1,1
		rjmp	intro_ktest
		lds	tempreg1,libmio_lastkey
		cpi	tempreg1,0
		breq	intro_main_w1
intro_main_m:	jmp	menu_main		;a key is pressed
intro_main_w1:	dec	tempreg3
		brne	intro_main_w
		ldi	ZL,0x0c
		ldi	ZH,0x90
		ldi	tempreg2,8		;number of programs
intro_sload:	lpm	tempreg1,Z		;get byte
		cpi	tempreg1,'L'		;Loader
		brne	intro_nosload
;start SLOADER
		ldi	ZL,0x10			;start offset
		lsr	ZH
		icall				;jump to sloader
		rjmp	intro_selpr		;sel program

intro_nosload:	subi	ZH,0xf4			;next prg
		dec	tempreg2
		brne	intro_sload

intro_selpr:	lds	tempreg1,libmio_sysconf1
		andi	tempreg1,0x70
		breq	intro_main_m
		rjmp	loop2

intro_ktest:	libmio_clrscr
		libmio_thistext
		.db	0,0,"Keyboard-Test",0
		libmio_newline
		lds	tempreg4,debug_scode
intro_ktest_1:	lds	XL,debug_scode
		cp	XL,const_0
		breq	intro_ktest_1
		sts	debug_scode,const_0
		ldi	ctrl,0
		mov	tempreg4,XL
		libmio_outhex
		libmio_outspace
		rjmp	intro_ktest_1
