;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# dataflash filesystem functions						#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;search for extensions
;------------------------------------------------------------------------------
		;clear all entries
sys_extsearch:	push	ZL
		push	ZH
		push	YL
		push	YH
		push	r16
		push	r17
		push	r0
		ldi	YL,LOW(prg_funct)
		ldi	YH,HIGH(prg_funct)
		ldi	r16,8
		ldi	r17,0xff
sys_esearch_1:	st	Y+,r17			;not found
		dec	r16
		brne	sys_esearch_1

		ldi	ZH,0x90			;first prg
sys_esearch_2:	ldi	ZL,0x0c			;prog type
		lpm	r16,Z+			;get byte 0c
		cpi	r16,'N'
		brne	sys_esearch_6
		adiw	ZL,1
		lpm	r16,Z+			;get byte 0e
		ldi	YL,LOW(prg_funct)
		ldi	YH,HIGH(prg_funct)
		ldi	r17,8
sys_esearch_3:	lsr	r16
		brcs	sys_esearch_4		;1=no fkt
		mov	r0,ZH
		lsr	r0
		st	Y,r0
sys_esearch_4:	adiw	YL,1
		dec	r17
		brne	sys_esearch_3
sys_esearch_6:	subi	ZH,0xf4			;+0x0C
		cpi	ZH,0xe5
		brcs	sys_esearch_2
		pop	r0
		pop	r17
		pop	r16
		pop	YH
		pop	YL
		pop	ZH
		pop	ZL
		ret


sys_extdisable:	push	YL
		push	YH
		push	r16
		ldi	YL,LOW(prg_funct)
		ldi	YH,HIGH(prg_funct)
		ldi	r16,0xff
		st	Y,r16			;disable vdrv
		std	Y+1,r16			;disable frame
		std	Y+2,r16			;disable sound
		pop	r16
		pop	YH
		pop	YL
		ret
