;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# line expander								#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;-----------------------------------------------------------------------
; expand linebuf -> inbuf
;-----------------------------------------------------------------------
xlin_main:	ldi	YL,LOW(bas_inbuf+3)	;text buffer address
		ldi	YH,HIGH(bas_inbuf+3)
		ldi	XL,LOW(bas_linebuf)	;code buffer address
		ldi	XH,HIGH(bas_linebuf)
;fill buffer with space
		ldi	tempreg1,0x20		;space
		ldi	ZL,34			;32 chars
xlin_main_0:	st	Y+,tempreg1
		dec	ZL
		brne	xlin_main_0
		sbiw	YL,34			;restore old pointer

xlin_main_1:	cpi	XL,LOW(bas_linebuf+32)	;we are at the end
		brcc	xlin_main_1a
		ld	tempreg1,X+		;get byte
		cpi	tempreg1,0x02		;minimum
		brcs	xlin_main_1a
		cpi	tempreg1,0xff		;end
		brne	xlin_main_2		;no
xlin_main_1a:	ret

xlin_main_2:	cpi	tempreg1,0x20		;fct token?
		brcs	xlin_main_3
		cpi	tempreg1,0x80		;token?
		brcc	xlin_main_3
		rcall	xlin_wrc		;write char
		rjmp	xlin_main_1		;loop

xlin_main_3:	cpi	tempreg1,0x1c		;1 byte dec
		brne	xlin_main_4
		ld	ZL,X+
		clr	ZH
		rcall	xlin_outdec
		rjmp	xlin_main_1

xlin_main_4:	cpi	tempreg1,0x1d		;2 bytes dec
		brne	xlin_main_5
		ld	ZH,X+
		ld	ZL,X+
		rcall	xlin_outdec
		rjmp	xlin_main_1

xlin_main_5:	cpi	tempreg1,0x1e		;1 byte hex
		brne	xlin_main_6
		ldi	tempreg1,'$'
		rcall	xlin_wrc		;write char
		ld	ZL,X+
		set
		rcall	xlin_outh_3
		rjmp	xlin_main_1

xlin_main_6:	cpi	tempreg1,0x1f		;2 bytes hex
		brne	xlin_main_7
		ldi	tempreg1,'$'
		rcall	xlin_wrc
		ld	ZH,X+
		ld	ZL,X+
		rcall	xlin_outhex
		rjmp	xlin_main_1

xlin_main_7:	rcall	xlin_outkey		;keyword
		rjmp	xlin_main_1

;-------------------------------------------------------------------------------
; output decimal value 
;-------------------------------------------------------------------------------
xlin_outdec:	clt				;clear nz flag
		ldi	tempreg1,47		;"0"-1 	
xlin_outd_01:	inc	tempreg1			;
		subi	ZL,16			;-10000
		sbci	ZH,39
		brcc	xlin_outd_01		;no overflow
		subi	ZL,240			;+10000
		sbci	ZH,216			;
		cpi	tempreg1,'0'		;5 digits?
		breq	xlin_outd_02		;no
		rcall	xlin_wrc
		set		

xlin_outd_02:	ldi	tempreg1,47		;"0"-1 	
xlin_outd_03:	inc	tempreg1			;
		subi	ZL,232			;-1000
		sbci	ZH,3			;
		brcc	xlin_outd_03		;no overflow
		subi	ZL,24			;+1000
		sbci	ZH,252			;
		brts	xlin_outd_04
		cpi	tempreg1,'0'		;5 digits?
		breq	xlin_outd_05		;no
xlin_outd_04:	rcall	xlin_wrc
		set

xlin_outd_05:	ldi	tempreg1,47		;"0"-1 	
xlin_outd_06:	inc	tempreg1			;
		subi	ZL,100			;-100
		sbci	ZH,0			;
		brcc	xlin_outd_06		;no overflow
		subi	ZL,156			;+100
		sbci	ZH,255			;
		brts	xlin_outd_07
		cpi	tempreg1,'0'		;5 digits?
		breq	xlin_outd_08		;no
xlin_outd_07:	rcall	xlin_wrc
		set

xlin_outd_08:	ldi	tempreg1,47		;"0"-1 	
xlin_outd_09:	inc	tempreg1			;
		subi	ZL,10			;-10
		brcc	xlin_outd_09		;no overflow
		subi	ZL,246			;+10
		brts	xlin_outd_10
		cpi	tempreg1,'0'		;5 digits?
		breq	xlin_outd_11		;no
xlin_outd_10:	rcall	xlin_wrc

xlin_outd_11:	ldi	tempreg1,48		;"0"
		add	tempreg1,ZL		;LSB digit
		rcall	xlin_wrc
		ret

;-------------------------------------------------------------------------------
; output hex value 
;-------------------------------------------------------------------------------
xlin_outhex:	clt				;clear nz flag
		mov	tempreg1,ZH
		swap	tempreg1
		andi	tempreg1,0x0f
		breq	xlin_outh_1
		rcall	xlin_ohexc		;out char
		set				;set nz flag

xlin_outh_1:	mov	tempreg1,ZH
		andi	tempreg1,0x0f
		brts	xlin_outh_2
		breq	xlin_outh_3
xlin_outh_2:	rcall	xlin_ohexc		;out char
		set
		
xlin_outh_3:	mov	tempreg1,ZL
		swap	tempreg1
		andi	tempreg1,0x0f
		brts	xlin_outh_4
		breq	xlin_outh_5
xlin_outh_4:	rcall	xlin_ohexc		;out char
		set

xlin_outh_5:	mov	tempreg1,ZL
		andi	tempreg1,0x0f
		rcall	xlin_ohexc		;out char
		ret

;-------------------------------------------------------------------------------
; out hexadecimal char (tempreg1)
;-------------------------------------------------------------------------------
xlin_ohexc:	subi	tempreg1,0xd0		;+30
		cpi	tempreg1,0x3a		;>9
		brcs	xlin_ohexc_1		;jump, if not
		subi	tempreg1,0xf9		;+6
xlin_ohexc_1:	rcall	xlin_wrc
		ret

;-------------------------------------------------------------------------------
; expand keyword tempreg1
;-------------------------------------------------------------------------------
xlin_outkey:	ldi	ZL,LOW(tokentab*2)	;start of token table
		ldi	ZH,HIGH(tokentab*2)
xlin_ok_1:	lpm	tempreg2,Z+		;token number
		cpi	tempreg2,0x00		;last?
		brne	xlin_ok_2
		ret

xlin_ok_2:	cp	tempreg1,tempreg2	;found
		breq	xlin_ok_3		;yes
		adiw	ZL,7			;next token
		rjmp	xlin_ok_1		;loop

xlin_ok_3:	push	tempreg2
		ldi	tempreg2,7		;number of chars
xlin_ok_4:	lpm	tempreg1,Z+
		cpi	tempreg1,'.'		;dont care bytes
		breq	xlin_ok_5
		rcall	xlin_wrc
xlin_ok_5:	dec	tempreg2
		brne	xlin_ok_4
		pop	tempreg2
		cpi	tempreg2,0x1c		;functions have no post-space
		brcs	xlin_ok_6
		ldi	tempreg1,0x20		;space
		rcall	xlin_wrc
xlin_ok_6:	ret

;-------------------------------------------------------------------------------
; write one char (tempreg1)
;-------------------------------------------------------------------------------
xlin_wrc:	cpi	YL,LOW(bas_inbuf+35)
		brcc	xlin_wrc_1
		st	Y+,tempreg1
xlin_wrc_1:	ret

