;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# dataflash file manager 							#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
confp_main:	ldi	XL,1
		libmio_chpump			;enable chargepump for serial
		sts	libmio_channel,const_0	;output to screen
		sts	libmio_vidmode,const_0	;standard video mode
		ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
		ldi	YL,0			;maximal sized box
		ldi	YH,0
		ldi	ZL,29
		ldi	ZH,22
		libmio_whbox
		ldi	XL,0x70			;color scheme (white on black)
		libmio_setcolor
		libmio_thistext
		.db 1,2,"ChipBasic2 configpage",0
		ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
		libmio_thistext
		.db 20,1,"Checksum: ",0,0
		rcall	confp_chksum
		clr	r16			;select first position

;------------------------------------------------------------------------------
;the main loop
;------------------------------------------------------------------------------
		call	mem_getconf
		lds	r18,libmio_sysconf	;recent conf
		lds	r19,libmio_sysconf1	;recent conf

confp_loop:	rcall	confp_sconf		;view status
confp_loop_1:	ldi	ZL,LOW(confp_mbar*2)
		ldi	ZH,HIGH(confp_mbar*2)
		libmio_menu

		cpi	tempreg1,0x01		;ESC
		brne	confp_loop_2
confp_loop_1a:	ret

confp_loop_2:	cpi	tempreg1,0x03		;SAVE
		brne	confp_loop_3
		sts	libmio_sysconf,r18	;recent conf
		sts	libmio_sysconf1,r19	;recent conf
		call	mem_setconf
		libmio_sync
		libmio_sync
		jmp	0

confp_loop_3:	cpi	tempreg1,0xe4		;up
		brne	confp_loop_4
		cpi	r16,1
		brcs	confp_loop_1
		dec	r16
		rjmp	confp_loop

confp_loop_4:	cpi	tempreg1,0xe5		;down
		brne	confp_loop_5
		cpi	r16,7
		brcc	confp_loop_1
		inc	r16
		rjmp	confp_loop

confp_loop_5:	cpi	tempreg1,0x02		;F1=change
		brne	confp_loop_1

;------------------------------------------------------------------------------
;change serial speed
;------------------------------------------------------------------------------
confp_main_55:	cpi	r16,0
		brne	confp_main_60
		eor	r18,const_1		;change
		rjmp	confp_loop

;------------------------------------------------------------------------------
;change I2C speed
;------------------------------------------------------------------------------
confp_main_60:	cpi	r16,1
		brne	confp_main_65
		ldi	tempreg4,0x10
		eor	r18,tempreg4
		rjmp	confp_loop

;------------------------------------------------------------------------------
;change SPI speed
;------------------------------------------------------------------------------
confp_main_65:	cpi	r16,2
		brne	confp_as_01
		ldi	tempreg4,0x08
		eor	r18,tempreg4		;toggle bit 3
confp_main_67:	rjmp	confp_loop

;------------------------------------------------------------------------------
;change Autostart
;------------------------------------------------------------------------------
confp_as_01:	cpi	r16,7
		brne	confp_main_70
		mov	tempreg4,r19
		andi	r19,0x8f
		subi	tempreg4,0xf0		;+0x10
		andi	tempreg4,0x70
		or	r19,tempreg4
confp_as_02:	rjmp	confp_loop

;------------------------------------------------------------------------------
;change Data EEPROM address
;------------------------------------------------------------------------------
confp_main_70:	cpi	r16,3
		brne	confp_main_75
		mov	tempreg4,r19
		inc	tempreg4
		andi	tempreg4,0x07
		andi	r19,0xf8
		or	r19,tempreg4
		rjmp	confp_loop

;------------------------------------------------------------------------------
;change Line end
;------------------------------------------------------------------------------
confp_main_75:	cpi	r16,4
		brne	confp_main_77
		subi	r18,0xc0		;+0x40
		brcs	confp_main_76
		ori	r18,0x40
confp_main_76:	rjmp	confp_loop

;------------------------------------------------------------------------------
;change Serin mode
;------------------------------------------------------------------------------
confp_main_77:	cpi	r16,5
		brne	confp_main_82
		ldi	tempreg4,0x02
		eor	r18,tempreg4		;toggle bit 1
confp_main_80:	rjmp	confp_loop

;------------------------------------------------------------------------------
;change Serin pin
;------------------------------------------------------------------------------
confp_main_82:	cpi	r16,6
		brne	confp_main_84
		ldi	tempreg4,0x20
		eor	r18,tempreg4		;toggle bit 5
confp_main_84:	rjmp	confp_loop


confp_sconf:	;show config
;------------------------------------------------------------------------------
;show data
;------------------------------------------------------------------------------
confp_kbdtype: 	ldi	XL,0x06			;color scheme (yellow on black)
		libmio_setcolor
		libmio_thistext
		.db 3,1,"Serial speed:",0
		libmio_thistext
		.db 5,1,"I2C speed:",0,0
		libmio_thistext
		.db 7,1,"SPI speed:",0,0
		libmio_thistext
		.db 9,1,"EEPROM address:",0
		libmio_thistext
		.db 11,1,"Line end:",0
		libmio_thistext
		.db 13,1,"Serial In/Out:",0,0
		libmio_thistext
		.db 15,1,"Serial Input:",0
		libmio_thistext
		.db 17,1,"Autostart:",0,0
		clr	r17

;------------------------------------------------------------------------------
;show serial speed
;------------------------------------------------------------------------------
		rcall	confp_cset
		sbrc	r18,0
		rjmp	confp_sertype1
		libmio_thistext
		.db 3,18,"1200 Bps",0,0
		rjmp	confp_sertype2
confp_sertype1:	libmio_thistext
		.db 3,18,"2400 Bps",0,0
confp_sertype2:

;------------------------------------------------------------------------------
;show I2C speed
;------------------------------------------------------------------------------
		rcall	confp_cset
		sbrc	r18,4
		rjmp	confp_twitype1
		libmio_thistext
		.db 5,18,"100 kHz",0
		rjmp	confp_twitype2
confp_twitype1:	libmio_thistext
		.db 5,18,"400 kHz",0
confp_twitype2:

;------------------------------------------------------------------------------
;show SPI speed
;------------------------------------------------------------------------------
		rcall	confp_cset
		sbrc	r18,3
		rjmp	confp_spitype1
		libmio_thistext
		.db 7,18,"5 MHz  ",0
		rjmp	confp_spitype2
confp_spitype1:	libmio_thistext
		.db 7,18,"156 kHz",0
confp_spitype2:

;------------------------------------------------------------------------------
;show EEPROM address
;------------------------------------------------------------------------------
		rcall	confp_cset
confp_eeadr:	libmio_thistext
		.db 9,18,0,0
		mov	tempreg1,r19
		andi	tempreg1,0x07
		subi	tempreg1,0xd0
		libmio_outchar

;------------------------------------------------------------------------------
;show line end
;------------------------------------------------------------------------------
		rcall	confp_cset
		mov	tempreg4,r18
		andi	tempreg4,0xc0
confp_lintype1:	cpi	tempreg4,0x80
		brne	confp_lintype2
		libmio_thistext
		.db 11,18,"only LF",0
		rjmp	confp_lintype9
confp_lintype2:	cpi	tempreg4,0x40
		brne	confp_lintype3
		libmio_thistext
		.db 11,18,"only CR",0
		rjmp	confp_lintype9
confp_lintype3:	libmio_thistext
		.db 11,18,"CR+LF  ",0
confp_lintype9:

;------------------------------------------------------------------------------
;show serial interface
;------------------------------------------------------------------------------
		rcall	confp_cset
		sbrc	r18,1
		rjmp	confp_sintype1
		libmio_thistext
		.db 13,18,"simple  ",0,0
		rjmp	confp_sintype2
confp_sintype1:	libmio_thistext
		.db 13,18,"standard",0,0
confp_sintype2:

;------------------------------------------------------------------------------
;show serial input pin
;------------------------------------------------------------------------------
		rcall	confp_cset
		sbrs	r18,5
		rjmp	confp_sinput1
		libmio_thistext
		.db 15,18,"PD3",0
		rjmp	confp_sinput2
confp_sinput1:	libmio_thistext
		.db 15,18,"PD1",0
confp_sinput2:

;------------------------------------------------------------------------------
;show autostart
;------------------------------------------------------------------------------
		rcall	confp_cset
confp_autos:	libmio_thistext
		.db 17,18,"PRG ",0,0
		mov	tempreg1,r19
		swap	tempreg1
		andi	tempreg1,0x07
		breq	confp_autos1
		subi	tempreg1,0xd0
		libmio_outchar
confp_autose:	ldi	XL,0x07			;color scheme (white on black)
		libmio_setcolor
		ret

confp_autos1:	libmio_thistext
		.db 17,18,"off  ",0
		rjmp	confp_autose


;------------------------------------------------------------------------------
;calc and output checksum
;------------------------------------------------------------------------------
confp_chksum:	clr	XL			;sum
		clr	YL
		clr	YH
		clr	ZL			;ptr
		clr	ZH

confp_chksum1:	lpm	r1,Z+
		add	YL,r1	
		adc	YH,const_0
		adc	XL,const_0
		cpi	ZH,HIGH(end_system*2)
		brne	confp_chksum1
		clr	ZL			;ptr
		ldi	ZH,$f0			;

confp_chksum2:	lpm	r1,Z+
		add	YL,r1
		adc	YH,const_0
		adc	XL,const_0
		cpi	ZH,0x00
		brne	confp_chksum2
		clr	XH
		ldi	ctrl,0x0f
		libmio_outhex
		movw	XL,YL
		libmio_outhex
		ret

confp_cset:	ldi	XL,0x05			;cyan on black
		cp	r16,r17
		brne	confp_cset1
		ldi	XL,0x50
confp_cset1:	libmio_setcolor
		inc	r17
		ret

;------------------------------------------------------------------------------
;the configpage menubar
;------------------------------------------------------------------------------
		;   "111111222222333333444444555555"
confp_mbar:	.db " Exit Change Save             ",2,0	;1 level, all keys
