;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# array functions								#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-----------------------------------------------------------------------
; read array value
;-----------------------------------------------------------------------
arr_read1:	movw	tempreg1,YL		;copy addr to tr1/tr2
		rjmp	arr_read_2

arr_read:	lds	tempreg1,bas_ram+10	;index low
		lds	tempreg2,bas_ram+11	;index high
arr_read_2:	push	YL
		push	YH
		cpi	tempreg2,3		;skip if intern
		breq	arr_read_5		;external
		rcall	arr_acalc		;calc address
		cpi	tempreg2,3		;skip if intern
		breq	arr_read_4		;external
		ld	XL,Y+
		clr	XH
		brtc	arr_read_3
		ld	XH,Y+
; increment array pointer
arr_read_3:	rjmp	arr_incptr_p1

arr_read_4:	lds	ZH,prg_xmem
		sbrc	ZH,7
		rjmp	arr_acalc_ex
		ldi	ZL,xmem_aread
		icall
		push	XL
		inc	tempreg1
		icall
		mov	XH,XL
		pop	XL
		rjmp	arr_incptr_p1

arr_read_5:	lds	ZH,prg_xmem
		sbrc	ZH,7
		rjmp	arr_acalc_ex
		ldi	ZL,xmem_aread
		icall
		clr	XH
		rjmp	arr_incptr_p1

;-----------------------------------------------------------------------
; write array value
;-----------------------------------------------------------------------
arr_write1:	movw	tempreg1,YL		;copy addr to tr1/tr2
		rjmp	arr_write_2

arr_write:	lds	tempreg1,bas_partab	;index low
		lds	tempreg2,bas_partab+1	;index high
arr_write_2:	push	YL
		push	YH
		cpi	tempreg2,3		;skip if intern
		breq	arr_write_5		;external
		rcall	arr_acalc		;calc address
		cpi	tempreg2,3		;skip if intern
		breq	arr_write_4		;external
		st	Y+,XL
		brtc	arr_write_3
		st	Y+,XH
arr_write_3:
; increment array pointer2
arr_incp2:	rjmp	arr_incptr_p2


arr_write_4:	lds	ZH,prg_xmem
		sbrc	ZH,7
		rjmp	arr_acalc_ex
		ldi	ZL,xmem_awrite
		icall
		mov	XL,XH
		rjmp	arr_write_6

arr_write_5:	lds	ZH,prg_xmem
		sbrc	ZH,7
		rjmp	arr_acalc_ex
		ldi	ZL,xmem_awrite
arr_write_6:	icall				;call array write
		rjmp	arr_incptr_p2

;-----------------------------------------------------------------------
; calc address (tempreg1/2=element) to Y
;-----------------------------------------------------------------------
arr_acalc:	cpi	tempreg2,0x04		;limit
		brcc	arr_acalc_2		;word?
		clt				;byte access
arr_acalc_1:	ldi	YH,high(bas_array)	;array
		ldi	YL,low(bas_array)
		add	YL,tempreg1		;array element address
		adc	YH,tempreg2
		ret

arr_acalc_2:	set				;word access
		subi	tempreg2,4		;sub word offset
		lsl	tempreg1		;*2
		rol	tempreg2
		cpi	tempreg2,0x04
		brcs	arr_acalc_1		;address is in range

arr_acalc_e:	pop	XL			;kill stack (subroutine call)
		pop	XL
arr_acalc_ex:	pop	YH			;restore Y
		pop	YL
		ldi	XL,0xff			;set value to 0xff
		ldi	ereg,18			;out of array
		ret

;-----------------------------------------------------------------------
; increment array pointers
;-----------------------------------------------------------------------
arr_incptr_p2:	ldi	YL,LOW(bas_partab)
		ldi	YH,HIGH(bas_partab)
		rjmp	arr_incptr_1
arr_incptr_p1:	ldi	YL,LOW(bas_ram+10)
		ldi	YH,HIGH(bas_ram+10)
arr_incptr_1:	ld	r0,Y
		ldd	r1,Y+1
		add	r0,const_1		;+1
		adc	r1,const_0
		st	Y,r0
		std	Y+1,r1
		pop	YH
		pop	YL
		ret

