;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# main library									#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;border-end-interrupt (no registers destroyed)
;-------------------------------------------------------------------------------
libmio_bisr:	out	PORTC,const_0		;2
		reti

;-------------------------------------------------------------------------------
;video-interrupt (no registers destroyed, stack=13)
;save registers (25c)
;-------------------------------------------------------------------------------
libmio_aisr:	push	tempreg1		;2
		push	tempreg2		;2
		push	tempreg3		;2
		push	ZH			;2 save Z-register
		push	ZL			;2 save Z-register
		push	YH			;2 save Y-register
		push	YL			;2 save Y-register
		push	XH			;2 save Y-register
		push	XL			;2 save Y-register
		push	r0			;2 save r0
		push	r1			;2 save r1
		in	ZH,SREG			;1 save status
		push	ZH			;2

;-------------------------------------------------------------------------------
;serial port io (19c)
;-------------------------------------------------------------------------------
		lds	XH,libmio_serio		;2 serial io
		sbrs	XH,7			;1 skip if 1-bit
		cbi	PORTD,4			;2 clear pin
		sbrc	XH,7			;1 skip if 0-bit
		sbi	PORTD,4			;2 set pin
		lds	YL,libmio_sysconf	;2 get conf (bit 5=force M644)
		in	YH,PIND			;1 input data
		bst	YH,3			;1 default for M644
		sbrs	YL,5			;1 skip if force M644
		bst	YH,1			;1 default for M644P
		bld	XH,0			;1 store to register
		sbrs	YL,1			;1 skip if no max
		eor	XH,const_1		;1 invert signal
		sts	libmio_serio,XH		;2

;-------------------------------------------------------------------------------
; set pointer for code saving (2c)
;-------------------------------------------------------------------------------
		ldi	YL,LOW(libmio_ram)	;1 set ptr
		ldi	YH,HIGH(libmio_ram)	;1

;-------------------------------------------------------------------------------
; calculate sound (34c)
;-------------------------------------------------------------------------------
		ldd	tempreg2,Y+lmo_rand2	;2 noise signal
		ldd	XL,Y+lmo_wpos_l		;2 wave pointer low
		ldd	ZL,Y+lmo_wpos_h		;2 wave pointer high
		ldd	r0,Y+lmo_woff_l		;2 wave offset low
		ldd	r1,Y+lmo_woff_h		;2 wave offset high
		add	XL,r0			;1 calculate new pointer
		adc	ZL,r1			;1
		std	Y+lmo_wpos_l,XL		;2 writeback new pointer
		std	Y+lmo_wpos_h,ZL		;2
		ldd	ZH,Y+lmo_wavtab		;1 start wavetable high
		lpm	tempreg1,Z		;3 get wave value
		ldd	XL,Y+lmo_note_val	;2 note val
		andi	XL,0x3f			;1 mask bits
		cpi	XL,0x3f			;1 noise?
		brne	libmio_wa_01		;1/2
		mov	tempreg1,tempreg2	;1
libmio_wa_01:	ldd	tempreg2,Y+lmo_envv	;2 envelope value
		ldd	XH,Y+lmo_volume		;2 volume setting
		mul	XH,tempreg2		;2
		mov	tempreg2,r1		;1
		mulsu	tempreg1,tempreg2	;2 shaped value
		ldi	XH,0x80			;1 neutral signal
		add	XH,r1			;1 add result
		sts	OCR2A,XH		;1 set level

;-------------------------------------------------------------------------------
; pseudo-random generator (31C)
;-------------------------------------------------------------------------------
		lds	ZL,libmio_rand1		;2
		lds	ZH,libmio_rand2		;2
		lds	tempreg1,libmio_rand3	;2
		lds	tempreg2,libmio_rand4	;2
		mov	XL,tempreg2
		lsl	XL			;1
		rol	ZL
		rol	ZH
		rol	tempreg1
		rol	tempreg2
		brcc	libmio_ird1
		ldi	XL,0x5D
		eor	ZL,XL
		ldi	XL,0xD5
		eor	ZH,XL
		ldi	XL,0x2A
		eor	tempreg1,XL
		ldi	XL,0xD5
		eor	tempreg2,XL

libmio_ird1:	sts	libmio_rand1,ZL		;2
		sts	libmio_rand2,ZH		;2
		sts	libmio_rand3,tempreg1	;2
		sts	libmio_rand4,tempreg2	;2


;-------------------------------------------------------------------------------
;count line up and set border (9c)
;-------------------------------------------------------------------------------
		add	vline_l,const_1		;1
		adc	vline_h,const_0		;1
		ldd	ZL,Y+lmo_sborder	;2
		ldd	ZH,Y+lmo_border		;2
		and	ZL,ZH			;1
		out	PORTC,ZL		;1
		sei				;1 enable border interrupt

;-------------------------------------------------------------------------------
;check if line is image
;-------------------------------------------------------------------------------
		ldd	ZL,Y+lmo_config		;2 configuration
		ldd	ZH,Y+lmo_vislines	;1 maximum lines
		cp	ZH,const_0		;1
		breq	libmio_ismode7		;1/2 goto forced image line
libmio_ismode0:	sbrc	vline_h,0		;1 skip if less than 256
		rjmp	libmio_is_02a		;2 no visible line
libmio_ismode1:	cp	vline_l,ZH		;1 max lines
		brcc	libmio_is_02a		;2 goto no image-line
libmio_ismode2:	rjmp	libmio_iss		;2 goto image line

libmio_ismode7:	lds	ZH,prg_vdrv
		ldi	ZL,vdrv_vid
		icall
		brtc	libmio_is_05		;no sync

;-------------------------------------------------------------------------------
;no image line
;-------------------------------------------------------------------------------
libmio_is_02:	ldi	YL,LOW(libmio_ram)	;1 set ptr
		ldi	YH,HIGH(libmio_ram)	;1
		ldd	ZL,Y+lmo_config		;2 configuration
		ldi	ZH,242			;1 maximum lines
libmio_is_02a:	cp	vline_l,ZH		;1
		brne	libmio_is_04		;no sync
		lds	tempreg1,bas_mta	;mt line
		cpi	tempreg1,0xff		;disabled?
		breq	libmio_is_04		;branch if disabled
		lds	tempreg1,bas_mta+2	;counter
		dec	tempreg1		;-1
		brne	libmio_is_03		;
		lds	tempreg1,bas_mta+1	;reload counter
		sts	bas_mta+3,const_1	;1 set flag
libmio_is_03:	sts	bas_mta+2,tempreg1

libmio_is_04:	ldi	ZH,libmio_vstart_p	;1 vstart pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_vstart_n	;1 vstart ntsc
		cp	vline_l,ZH
		brne	libmio_is_09		;no vsync start
		cbi	PORTD,6
		sbrs	ZL,3			;csync bit
		rjmp	libmio_is_15
		ldi	XH,0x82			;invert CSYNC
		sts	TCCR1A,XH
libmio_is_05:	rjmp	libmio_is_15

libmio_is_09:	ldi	ZH,libmio_vstop_p	;1 vstop pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_vstop_n	;1 vstop ntsc
		cp	vline_l,ZH
		brne	libmio_is_10		;no vsync stop
		sbi	PORTD,6
		sbrs	ZL,3			;csync bit
		rjmp	libmio_is_15
		ldi	XH,0xc2			;normal CSYNC
		sts	TCCR1A,XH
		rjmp	libmio_is_15

libmio_is_10:	ldi	ZH,libmio_bstart_p	;1 border start pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_bstart_n	;1 border start ntsc
		cp	vline_l,ZH
		brne	libmio_is_11		;no border start
		ldi	ZL,0xff
		sts	libmio_sborder,ZL
		rjmp	libmio_is_15

libmio_is_11:	ldi	ZH,libmio_bstop_p	;1 border stop pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,libmio_bstop_n	;1 border stop ntsc
		cp	vline_l,ZH
		brne	libmio_is_13		;no border stop
		sts	libmio_sborder,const_0
		lds	ZH,prg_frame
		ldi	ZL,frame_entry
		sbrs	ZH,7
		icall
		rjmp	libmio_is_15

libmio_is_13:	ldi	ZH,57			;1 maxlines pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	ZH,7			;1 maxlines ntsc
		cp	vline_l,ZH
		breq	libmio_is_14		;2 end of frame
		rjmp	libmio_is_15

libmio_is_14:	ldi	XL,LOW(libmio_vram)	;1 set vram start
		std	Y+lmo_rampos_l,XL	;2
		ldi	XL,HIGH(libmio_vram)	;1
		std	Y+lmo_rampos_h,XL	;2
		std	Y+lmo_cline,const_0	;2 store cline
		clr	vline_l			;line_l=0
		clr	vline_h			;line_h=0
		ldi	XL,0x0a			;editor head color
		std	Y+lmo_elcolor,XL
;increment counters
		ldi	XL,5			;1 fps/10 for pal
		sbrs	ZL,2			;1 pal/ntsc bit
		inc	XL			;1 fps/10 for ntsc
		ldi	tempreg1,50		;1 fps for pal
		sbrs	ZL,2			;1 pal/ntsc bit
		ldi	tempreg1,60		;1 fps for ntsc
		ldd	XH,Y+lmo_time0		;2 timer
		inc	XH
		cp	XH,XL			;1 frames (5/6)
		brne	libmio_is_06a
		clr	XH
		ldd	ZL,Y+lmo_time_l
		ldd	ZH,Y+lmo_time_h
		adiw	ZL,1
		std	Y+lmo_time_l,ZL
		std	Y+lmo_time_h,ZH
libmio_is_06a:	std	Y+lmo_time0,XH
		ldd	ZL,Y+lmo_frames		;2 get frame counter
		inc	ZL			;1 +1
		cp	ZL,tempreg1		;1 frames (50/60)
		brne	libmio_is_07		;2 frame oveflow
		clr	ZL			;1 set frames=0
libmio_is_07:	std	Y+lmo_frames,ZL		;2 set frames=0

;-------------------------------------------------------------------------------
; calculate envelope position
;-------------------------------------------------------------------------------
		lds	ZH,prg_sound
		ldi	ZL,envelope_entry
		sbrc	ZH,7
		rjmp	libmio_is_11c
		icall
		rjmp	libmio_is_11a

libmio_is_11c:	ldi	ZH,HIGH(libmio_etable*2);1 start envtable high
		ldi	ZL,LOW(libmio_etable*2)	;1 start envtable low
		lds	XL,libmio_note_val
		sbrc	XL,7
		adiw	ZL,32
		ldd	XL,Y+lmo_env		;2 envelope pointer
		add	ZL,XL			;1 envelope-position
		adc	ZH,const_0		;1
		lpm	XH,Z			;get envelope value
		cp	XH,const_0		;must be zero to stop
		breq	libmio_is_11a		;the end is reached
		inc	XL			;+1
		std	Y+lmo_env,XL		;write back
libmio_is_11a:	std	Y+lmo_envv,XH		;write envelope value

;-------------------------------------------------------------------------------
; check sequencer
;-------------------------------------------------------------------------------
libmio_is_seq:	lds	tempreg3,libmio_seqstat
		cpi	tempreg3,0x00		;enabled?
		breq	libmio_is_seq8		;yes
libmio_is_seq1:	lds	XH,libmio_seqcount	;counter
		dec	XH
		sts	libmio_seqcount,XH	;store back
		brne	libmio_is_seq8
		lds	XH,libmio_seqspeed	;speed
		sts	libmio_seqcount,XH
		lds	XH,libmio_seqtick	;ticks of recent
		dec	XH
		sts	libmio_seqtick,XH
		brne	libmio_is_seq8

		lds	ZL,libmio_seql
		lds	ZH,libmio_seqh
		lds	YL,libmio_seqbl
		lds	YH,libmio_seqbh
		sbiw	YL,1
		ld	XL,Z+			;note
		ld	XH,Z+			;no of ticks/volume
		mov	tempreg1,XH		;copy value
		swap	XH			;swap for volume checking
		andi	XH,0x0f
		breq	libmio_is_seqv		;branch if no volume set
		clt				;only local volume
		call	libmio_setvol		;set volume
libmio_is_seqv:	andi	tempreg1,0x0f		;mask tick bits
		sts	libmio_seqtick,tempreg1	;store
		call	libmio_note
libmio_is_seq2:	cp	ZL,YL			;compare hi
		cpc	ZH,YH			;compare low
		brcs	libmio_is_seq7		;is less
		sbrs	tempreg3,7 		;skip counting if bit 7 is high
		dec	tempreg3
		sts	libmio_seqstat,tempreg3	;write status

libmio_is_seq6:	lds	ZL,libmio_seqal		;get start pointer
		lds	ZH,libmio_seqah
libmio_is_seq7:	sts	libmio_seql,ZL		;store pointer
		sts	libmio_seqh,ZH
libmio_is_seq8:	rjmp	libmio_is_15

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
libmio_iss:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,232			;1
		brcs	libmio_iss		;1 loop
libmio_iss_01:	cpi	XL,233
		brcs	libmio_iss_02
libmio_iss_02:	cpi	XL,234
		brcs	libmio_iss_03
libmio_iss_03:	cpi	XL,235
		brcs	libmio_iss_03a
libmio_iss_03a:	cpi	XL,236
		brcs	libmio_iss_04

libmio_iss_04:	sbrc	ZL,5			;1 fast flag
		rjmp	libmio_is_15		;2 no visible lines
		lds	ZL,libmio_vidmode
		sbrc	ZL,3
		jmp	libmio_tvm		;tvm editor mode
		lsl	ZL
		ldi	ZH,LOW(libmio_isj)
		add	ZL,ZH
		ldi	ZH,HIGH(libmio_isj)
		adc	ZH,const_0
		ijmp

libmio_isj:
		jmp	libmio_tvc		;standard mode
		jmp	libmio_tvg2		;2 color graphics
		jmp	libmio_tvg4		;4 color graphics
		jmp	libmio_tvg8		;8 color graphics
		jmp	libmio_tvu		;user charset mode 1
		jmp	libmio_tvg1		;2 color graphics
		jmp	libmio_tvs		;user charset mode 2

libmio_extmode:	lds	ZH,prg_vdrv
		ldi	ZL,vdrv_vid
		icall
libmio_is_15:
;------------------------------------------------------------------------------
;the keyboard routine
;09 no char from keyboard
;26 key, but released
;43 key, state 1
;------------------------------------------------------------------------------
libmio_kirs:	lds	ZL,prg_keyb		;2 have keyb?
		sbrs	ZL,7
		rjmp	libmio_kext		;2 external routine
		lds	XL,libmio_kbdstate	;2
		sbrc	XL,5			;1 skip if not state2
		rjmp	libmio_kir_s2		;2 jump to next state
;+4
		lds	ZL,UCSR0A		;2 status
		sbrs	ZL,RXC0			;1 RXC?
		rjmp	libmio_kir_end		;2 no byte available
		lds	ZL,UDR0			;2 get data
		sts	debug_scode,ZL		;2 save scancode for debug only
;+10
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3 get config byte
;+14
		sbrs	XH,0			;1 skip if char
		rjmp	libmio_kir_nch		;2 no char
;+16
		sbrs	XL,7			;1 check release flag
		rjmp	libmio_kir_01		;2
		sts	libmio_keycode,const_0	;2 clear keycode
		rjmp	libmio_kir_enb		;2
;+19
libmio_kir_01:	cpi	ZL,0x83			;1 change this one code
		brne	libmio_kir_02		;1 jump if not
		ldi	ZL,0x10			;1 replacement
;+22
libmio_kir_02:	ldi	ZH,HIGH(libmio_ktables*2) ;1 start ext keytable

;+23
;check for extended
		andi	ZL,0x7f			;1 clear bit 7 of low

		sbrs	XL,4			;1 skip if alt
		sbrc	XL,6			;1 skip if extended
		inc	ZH			;1 table 3 (extended)

		sbrs	XL,4			;1 alt
		sbrc	XL,0			;1 left shift
		ori	ZL,0x80			;1 part 2 of table
		sbrc	XL,1			;1 right shift
		ori	ZL,0x80			;1 part 2 of table
;+30
		lpm	ZL,Z			;3 get value
		sts	libmio_scancode,ZL	;2
		ori	XL,0x20			;1 set state 2
		rjmp	libmio_kir_enc		;2

;second cycle (+5)
libmio_kir_s2:	lds	ZL,libmio_scancode	;2 get code back
;+7
		sts	libmio_keycode,ZL	;store result
		sts	libmio_lastkey,ZL
		cpi	ZL,0xee			;1 alt+del
		brne	libmio_kir_03		;1/2
		sbrc	XL,2			;2 left control
		jmp	start			;4 restart

;+11
libmio_kir_03:	lds	tempreg1,libmio_kflags	;2 keyboard control
		cpi	ZL,'c'			;1 Break?
		brne	libmio_kir_04		;1/2
		sbrc	XL,2			;1 left control?
		ori	tempreg1,1		;1 set break bit

libmio_kir_04:	cpi	ZL,'p'			;Screenshot?
		brne	libmio_kir_05		;1/2
		sbrc	XL,3			;1 right control?
		ori	tempreg1,2		;set screenshot bit

libmio_kir_05:	cpi	ZL,0xfc			;monitor?
		brne	libmio_kir_06
		ori	tempreg1,4		;set monitor bit
libmio_kir_06:	sts	libmio_kflags,tempreg1	;save keyboard control
		rjmp	libmio_kir_enb		;end


;no char (+17)
libmio_kir_nch:	cpi	ZL,0xf0
		brne	libmio_kir_nc1
		ori	XL,0x80			;1 set release flag
		rjmp	libmio_kir_enc
;+20
libmio_kir_nc1:	cpi	ZL,0xe0
		brne	libmio_kir_nc2
		ori	XL,0x40			;1 set extended flag
		rjmp	libmio_kir_enc
;+23
libmio_kir_nc2:	cpi	ZL,0x12			;left shift
		brne	libmio_kir_nc3		;no
		sbrc	XL,6			;skip if not extended
		rjmp	libmio_kir_enb		;extended->ignore
		ori	XL,0x01			;set shift bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xfe			;clear shift bit
		rjmp	libmio_kir_enb		;thats all
;+26
libmio_kir_nc3:	cpi	ZL,0x59			;right shift
		brne	libmio_kir_nc4		;jump if not
		ori	XL,0x02			;set shift bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xfd			;clear shift bit
		rjmp	libmio_kir_enb		;thats all
;+29
libmio_kir_nc4:	cpi	ZL,0x14			;control
		brne	libmio_kir_nc6		;jump if not
		sbrc	XL,6			;extended? (right ctrl key)
		rjmp	libmio_kir_nc5
		ori	XL,0x04			;set control bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xfb			;clear ctrl bit
		rjmp	libmio_kir_enb		;thats all
libmio_kir_nc5:	ori	XL,0x08			;set control bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xf7			;clear ctrl bit
		rjmp	libmio_kir_enb		;thats all
;+32
libmio_kir_nc6:	cpi	ZL,0x11			;alternate
		brne	libmio_kir_nc7		;jump if not
		ori	XL,0x10			;set alt bit
		sbrc	XL,7			;skip if not release
		andi	XL,0xef			;clear alt bit
		rjmp	libmio_kir_enb		;thats all

libmio_kir_nc7:	sts	libmio_keycode,const_0	;clear keycode
libmio_kir_enb: andi	XL,0x1f			;1 clear ext and release bit
libmio_kir_enc:	sts	libmio_kbdstate,XL	;2 store keyboard status
libmio_kir_end:

;-------------------------------------------------------------------------------
;serial port select baud
;-------------------------------------------------------------------------------
libmio_doser:	lds	tempreg1,libmio_sysconf	;baud sel
		sbrc	tempreg1,0		;skip if 1200
		call	libmio_bl_2rx
		sbrs	tempreg1,0		;skip if 2400
		call	libmio_bl_1rx

;-------------------------------------------------------------------------------
;restore registers and exit
;-------------------------------------------------------------------------------
libmio_is_20:	jmp	libmio_bli_90

libmio_kext:	ldi	ZL,xkbd_get
		icall
		rjmp	libmio_doser
