;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# viedo mode 6 engine								#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
libmio_tvs_e:	rjmp	libmio_is_15
;-------------------------------------------------------------------------------
; -output character line 5 clocks per pixel
; -64 user defined characters are in table 6x10px each
;-------------------------------------------------------------------------------
libmio_tvs:	mov	XL,vline_l
		cpi	XL,5
		brcs	libmio_tvs_e
		lds	XL,libmio_rampos_l	;2 BS low
		lds	XH,libmio_rampos_h	;1 BS high
		ldi	ZL,LOW(libmio_vram+690)		;1 offset character table
		ldi	ZH,HIGH(libmio_vram+690)	;1
		lds	YL,libmio_cline		;2 get pixline offset
		ldi	YH,3			;3 bytes per pixline
		mul	YL,YH			;1
		add	ZL,r0
		adc	ZH,r1			;Z ist the base address
		push	tempreg4		;we need this?
		ldi	tempreg3,30		;Bytes per char
		ldi	tempreg4,30		;chars to do
		ldi	YL,LOW(libmio_border)
		ldi	YH,HIGH(libmio_border)
		ld	tempreg2,Y
		andi	tempreg2,0xf0
		mov	tempreg1,tempreg2
		swap	tempreg1
		or	tempreg2,tempreg1
		st	Y,tempreg2

libmio_tvs_1:	out	PORTC,tempreg2		;1 out pix 3
		swap	tempreg2		;1 prepare pix 4
		ld	tempreg1,X+		;2 get char
		andi	tempreg1,0x3f		;1 only 0-63

		out	PORTC,tempreg2		;1 out pix 4
		ld	tempreg2,Y+		;2 get pix 5+6
		mul	tempreg1,tempreg3	;2 calc offset

		out	PORTC,tempreg2		;1 out pix 5
		swap	tempreg2		;1 prepare pix 6
		movw	YL,ZL			;2 base address
		nop				;1 filling
		
		out	PORTC,tempreg2		;1 out pix 6
		add	YL,r0			;1 add offset 
		adc	YH,r1			;1
		ld	tempreg2,Y+		;2 get pix 1+2
		
		out	PORTC,tempreg2		;1 out pix1
		swap	tempreg2		;1 prepare pix 2
		dec	tempreg4		;1 chars to do -1
		nop				;1 filling
		nop				;1 filling
		
		out	PORTC,tempreg2		;1 out pix2
		ld	tempreg2,Y+		;2 get pix 3+4
		brne	libmio_tvs_1		;2 loop
		
		nop				;1 correct timing
		
		out	PORTC,tempreg2		;1 out pix3
		swap	tempreg2		;1 prepare pix 4
		lds	tempreg3,libmio_border	;2 get border
		nop				;1 filling
		
		out	PORTC,tempreg2		;1 out pix4
		ld	tempreg2,Y+		;2 get pix5+6
		pop	tempreg4		;2
		
		out	PORTC,tempreg2		;1 out pix5
		swap	tempreg2		;1 prepare pix 6
		lds	ZH,libmio_cline		;2
		inc	ZH			;1 cline +1
		
		out	PORTC,tempreg2		;1 out pix6
;		ld	ZL,-X			;2 correct X-register
		nop				;1 filling
		nop				;1 filling
	
		out	PORTC,tempreg3		;1 set color to border

		cpi	ZH,10			;1 check
		brne	libmio_tvs_2		;2 jump if not next line
		clr	ZH			;1 character line = 0
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
libmio_tvs_2:	sts	libmio_cline,ZH		;2 new character line
		jmp	libmio_is_15
