#!/usr/bin/perl
#################################################################################
#										#
# table generator for libmio							#
# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
#										#
#										#
# This program is free software; you can redistribute it and/or			#
# modify it under the terms of the GNU General Public License			#
# as published by the Free Software Foundation; either version 3		#
# of the License, or (at your option) any later version.			#
#										#
# This program is distributed in the hope that it will be useful,		#
# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
# General Public License for more details.					#
#										#
# You should have received a copy of the GNU General Public			#
# License along with this library; if not, write to the				#
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
# Boston, MA 02111-1307, USA.							#
#										#
#################################################################################
sub clear_cells
{
    for($i=0;$i<3072;$i++)
    {
	$mcell[$i]=0;
    }
}

sub get_pixel
{
    $nb=0;
    if ($z =~ /^\./) {$nb=0}
    elsif ($z =~ /^x/) {$nb=1}
    $z=$';
    return $nb;
}

&clear_cells;

###############################################################################
# read character cells
###############################################################################
open (RTAB, "ctab_f0.dat");
$cline=0;
$count=0;
while(<RTAB>)
{
    $z=$_;
    chomp($z);
    if ($z =~ /cell/) 
    {
	$cline=0;
    }
    
    elsif (length($z)>5)
    {
	$pix1=&get_pixel();
	$pix2=&get_pixel();
	$pix3=&get_pixel();
	$pix4=&get_pixel();
	$pix5=&get_pixel();
	$pix6=&get_pixel();
	$mbyte=0;

	if ($pix1 > 0 ) 
	{
	    $mbyte+=128;
	}

	if ($pix2 != $pix1)  
	{
	    $mbyte+=64;
	}

	if ($pix3 != $pix2)  
	{
	    $mbyte+=32;
	}

	if ($pix4 != $pix3)  
	{
	    $mbyte+=16;
	}

	if ($pix5 != $pix4)  
	{
	    $mbyte+=8;
	}

	if ($pix6 != $pix5)  
	{
	    $mbyte+=4;
	}

	
	$mcell[$count+256*($cline)]=$mbyte;
	$cline++;
        if ($cline==10)
	{
	    $cline=0;
	    $count++;
	}
    }

}

close(RTAB);

###############################################################################
# write chartable
###############################################################################
open (WTAB, ">../ctable_f0.inc");
    for($i=0;$i<160;$i++)
    {
        print WTAB "        .db "; 
        for($j=0;$j<16;$j++)
        {
	    $cellpos=$i*16+$j;
	    $y=$mcell[$cellpos];
	    if ($y<1) {printf WTAB "0x00"} 
	    else {printf WTAB "%#2.2x",$y};
	    if ($j<15) {print WTAB ","}
	    else {print WTAB "\n"};
	}
    }
close(WTAB);

&clear_cells;

###############################################################################
# read character cells
###############################################################################
open (RTAB, "ctab_f1.dat");
$cline=0;
$count=0;
$oe=0;
$mbyte=0;

while(<RTAB>)
{
    $z=$_;
    chomp($z);
    if ($z =~ /cell/) 
    {
	$cline=0;
    }
    
    elsif (length($z)>2)

    {
	$pix1=&get_pixel();
	$pix2=&get_pixel();
	$pix3=&get_pixel();
	$pix4=&get_pixel();
	if ($pix1 > 0 ) 
	{
	    $mbyte+=8;
	}

	if ($pix2 > 0 )  
	{
	    $mbyte+=4;
	}

	if ($pix3 > 0 )  
	{
	    $mbyte+=2;
	}

	if ($pix4 > 0 )  
	{
	    $mbyte+=1;
	}
	if ($oe==0)
	{
		$mbyte=16*$mbyte;
		$oe=1;	
	}
	else
	{
		$hcell[$count++]=$mbyte;
		$mbyte=0;
		$oe=0;
	}
    }
}

close(RTAB);

###############################################################################
# write chartable
###############################################################################
open (WTAB, "> ../ctable_f1.inc");
    for($i=0;$i<24;$i++)
    {
        print WTAB "        .db "; 
        for($j=0;$j<16;$j++)
        {
	    $cellpos=$i*16+$j;
	    $y=$hcell[$cellpos];
	    if ($y<1) {printf WTAB "0x00"} 
	    else {printf WTAB "%#2.2x",$y};
	    if ($j<15) {print WTAB ","}
	    else {print WTAB "\n"};
	}
    }
close(WTAB);

