;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# video-bootloader								#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

		jmp	0			;boot vector

;-------------------------------------------------------------------------------
;restore registers and exit
;-------------------------------------------------------------------------------
libmio_bli_90:	pop	ZH			;2 restore sreg
		out	SREG,ZH			;1 put back
		pop	r1			;2 restore r1
		pop	r0			;2 restore r0
		pop	XL			;2 restore Y-register
		pop	XH			;2 restore Y-register
		pop	YL			;2 restore Y-register
		pop	YH			;2 restore Y-register
		pop	ZL			;2 restore Z-register
		pop	ZH			;2 restore Z-register
		pop	tempreg3		;
		pop	tempreg2		;2
		pop	tempreg1		;2 restore register
		reti				;4 thats all

;-------------------------------------------------------------------------------
;serial port (receive 2400)
;-------------------------------------------------------------------------------
libmio_bl_2rx:	lds	XL,libmio_serio		;2 get signal byte
		lds	ZL,libmio_rcnt		;2 clock counter
		cpi	ZL,0x00			;1 end
		breq	libmio_bl_2rxe		;1/2
		cpi	ZL,0xff			;1 wait for sig
		brne	libmio_bl_2rx1		;1/2
		sbrc	XL,0			;1 skip if line is 0
		rjmp	libmio_bl_2rxe		;1/2
		ldi	ZL,62			;1 start value 2400
		rjmp	libmio_bl_2rxe		;2

;+9
libmio_bl_2rx1:	dec	ZL			;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3
		sbrs	XH,5			;1 skip if sample bit
		rjmp	libmio_bl_2rxe		;2

		lds	XH,libmio_rdat		;2 serial data
		lsr	XH			;1
		bst	XL,0			;1 RXD data
		bld	XH,7			;1 shift in
		sts	libmio_rdat,XH		;2

libmio_bl_2rxe:	sts	libmio_rcnt,ZL		;2

;-------------------------------------------------------------------------------
;serial port (transmit 2400)
;-------------------------------------------------------------------------------
libmio_bl_2tx:	lds	ZL,libmio_tcnt		;2 clock counter
		cpi	ZL,0x00			;1
		breq	libmio_bl_2txn		;1/2 nothing to do
		cpi	ZL,0xff			;1 wait for start
		brne	libmio_bl_2tx1		;1/2
		ldi	ZL,80			;1
		andi	XL,0x7f			;1 clear bit
		rjmp	libmio_bl_2txe		;2
;+7 clk
libmio_bl_2tx1:	dec	ZL			;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3
		sbrs	XH,4			;1 skip if setout bit
		rjmp	libmio_bl_2txe		;2

		lds	XH,libmio_tdat		;2
		bst	XH,0			;1
		sec				;1
		ror	XH			;1
		bld	XL,7			;1
		sts	libmio_tdat,XH		;2

libmio_bl_2txe:	sts	libmio_tcnt,ZL		;2
		sts	libmio_serio,XL		;2
libmio_bl_2txn:	ret

;-------------------------------------------------------------------------------
;serial port (receive 1200)
;-------------------------------------------------------------------------------
libmio_bl_1rx:	lds	XL,libmio_serio		;2 get signal byte
		lds	ZL,libmio_rcnt		;2 clock counter
		cpi	ZL,0x00			;1 end
		breq	libmio_bl_1rxe		;1/2
		cpi	ZL,0xff			;1 wait for sig
		brne	libmio_bl_1rx1		;1/2
		sbrc	XL,0			;1 skip if line is 0
		rjmp	libmio_bl_1rxe		;1/2
		ldi	ZL,124			;1 start value 1200
		rjmp	libmio_bl_1rxe		;2

;+9
libmio_bl_1rx1:	dec	ZL			;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3
		sbrs	XH,7			;1 skip if sample bit
		rjmp	libmio_bl_1rxe		;2

		lds	XH,libmio_rdat		;2 serial data
		lsr	XH			;1
		bst	XL,0			;1 RXD data
		bld	XH,7			;1 shift in
		sts	libmio_rdat,XH		;2

libmio_bl_1rxe:	sts	libmio_rcnt,ZL		;2

;-------------------------------------------------------------------------------
;serial port (transmit 1200)
;-------------------------------------------------------------------------------
libmio_bl_1tx:	lds	ZL,libmio_tcnt		;2 clock counter
		cpi	ZL,0x00			;1
		breq	libmio_bl_2txn		;1/2 nothing to do
		cpi	ZL,0xff			;1 wait for start
		brne	libmio_bl_1tx1		;1/2
		ldi	ZL,144			;1 start value 1200
		andi	XL,0x7f			;1 clear bit
		rjmp	libmio_bl_2txe		;2
;+7 clk
libmio_bl_1tx1:	dec	ZL			;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)	;1 set start of table
		lpm	XH,Z			;3
		sbrs	XH,6			;1 skip if setout bit
		rjmp	libmio_bl_2txe		;2

		lds	XH,libmio_tdat		;2
		bst	XH,0			;1
		sec				;1
		ror	XH			;1
		bld	XL,7			;1
		sts	libmio_tdat,XH		;2
		rjmp	libmio_bl_2txe

