;################################################################################
;#										#
;# libeep - EEPROM R/W library for ATmega controllers				#
;# copyright (c) 2007-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;------------------------------------------------------------------------------
; check Y for memory bound
;------------------------------------------------------------------------------
libeep_check:	clr	ereg			;no error
		cpi	YH,libeep_end
		brcs	libeep_check1		;OK
		ldi	ereg,34			;out of bound error
		pop	tempreg1		;kill call adr
		pop	tempreg1		;kill call adr
		ldi	tempreg1,0xff		;unprogrammed
libeep_check1:	ret

;------------------------------------------------------------------------------
; read one byte (tempreg1) from EEPROM memory (Y+)
;------------------------------------------------------------------------------
libeep_read:	rcall	libeep_check
libeep_read1:	sbic	EECR,EEPE
		rjmp	libeep_read1
		out	EEARH,YH
		out	EEARL,YL
		sbi	EECR,EERE
		in	tempreg1,EEDR
		adiw	YL,1
		ret				;thats all

;------------------------------------------------------------------------------
; write one byte (tempreg1) to EEPROM memory (Y+) with verify
;------------------------------------------------------------------------------
libeep_write:	rcall	libeep_check
libeep_write1:	clr	ereg
		sbic	EECR,EEPE		;wait for EEPROM ready
		rjmp	libeep_write1
		out	EEARH,YH
		out	EEARL,YL
		sbi	EECR,EERE
		in	tempreg5,EEDR
		cp	tempreg5,tempreg1
		brne	libeep_write3
		adiw	YL,1
		ret				;no modify necessary

libeep_write3:	out	EEDR,tempreg1		;write byte
		cli
		sbi	EECR,EEMPE
		sbi	EECR,EEPE
		sei
libeep_write4:	sbic	EECR,EEPE		;verify
		rjmp	libeep_write4
		sbi	EECR,EERE
		adiw	YL,1
		ret

