;################################################################################
;#										#
;# AVR-ChipBasic2 - single chip basic computer with ATmega644			#
;# binfile API									#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License as 		#
;# published by the Free Software Foundation; either version 3 of		#
;# the License, or (at your option) any later version.				#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
;--------------------------------------------------------------------------------
;get access to compress and decompress routines
;--------------------------------------------------------------------------------
clin_ext:
api_token:	jmp	clin_main

xlin_ext:
api_untoken:	jmp	xlin_main

;--------------------------------------------------------------------------------
;API version
;--------------------------------------------------------------------------------
api_version:	ldi	tempreg1,0x06
		ret

;--------------------------------------------------------------------------------
;push/pop functions
;--------------------------------------------------------------------------------
api_popxyz:	rjmp	popxyz
api_pushxyz:	rjmp	pushxyz
api_popregs:	rjmp	popxyzr
api_pushregs:	rjmp	pushxyzr

;--------------------------------------------------------------------------------
;pointer functions
;--------------------------------------------------------------------------------
;get vram address to Y
api_getvram:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ret

;get sysram address to Y
api_getsysram:	ldi	YL,LOW(libmio_ram)
		ldi	YH,HIGH(libmio_ram)
		ret

;get palette address to Y
api_getpal:	ldi	YL,LOW(libmio_palette)
		ldi	YH,HIGH(libmio_palette)
		ret

;get array address to Y
api_getarray:	ldi	YL,LOW(bas_array)
		ldi	YH,HIGH(bas_array)
		ret

;get charset 0 address to Z
api_getchart0:	ldi	ZL,LOW(libmio_ctable*2)
		ldi	ZH,HIGH(libmio_ctable*2)
		ret

;get charset 1 address to Z
api_getchart1:	ldi	ZL,LOW(libmio_ctable*2)
		ldi	ZH,HIGH(libmio_ctable*2)
		ret

;get address of basic buffers
api_getbuffer:	ldi	YL,LOW(bas_inbuf)
		ldi	YH,HIGH(bas_inbuf)
		ret

;get values address to Y
api_getvalues:	ldi	YL,LOW(bas_values)
		ldi	YH,HIGH(bas_values)
		ret

;get parameter address to Y
api_getpartab:	ldi	YL,LOW(bas_partab)
		ldi	YH,HIGH(bas_partab)
		ret

;get variable address to Y
api_getvar:	ldi	YL,LOW(varspace)
		ldi	YH,HIGH(varspace)
		ret

;get 
api_getprg:	ldi	YL,LOW(prg_funct)
		ldi	YH,HIGH(prg_funct)
		ret


;get program base address to Z
api_getbase_0:	pop	ZH			;get return address high byte
		push	ZH
		mov	ZL,ZH
		subi	ZL,0x48			;sub base
		ldi	ZH,0x42			;base
api_getbase_1:	subi	ZH,0xfa			;+6
		subi	ZL,0x06
		brcc	api_getbase_1
		clr	ZL
		brtc	api_getbase_2
		add	ZL,XL
		adc	ZH,XH
		lsl	ZL
		rol	ZH
api_getbase_2:	ret

;get program address (offset X) to Z
api_dataptr:	set
		rjmp	api_getbase_0
		
api_getbase:	clt
		rjmp	api_getbase_0

;get program number (0..7) to ZL
api_getprog:	pop	ZH			;get return address high byte
		push	ZH
		ldi	ZL,0
		subi	ZH,0x48			;sub base
api_getprog_1:	subi	ZH,0x06
		brcs	api_getprog_2
		inc	ZL
		rjmp	api_getprog_1
api_getprog_2:	ret

;--------------------------------------------------------------------------------
;settings XL=value
;--------------------------------------------------------------------------------
api_setcolor:	jmp	libmio_setcol
api_setfcolor:	jmp	libmio_setfgc
api_setborder:	jmp	libmio_setbrd
api_setvmode:	jmp	libmio_svmode
api_setpalette:	jmp	libmio_setpal
api_sync:	jmp	libmio_sync
api_slow:	jmp	libmio_vidon
api_fast:	jmp	libmio_vidoff
api_setchannel:	jmp	libmio_setchan
api_setfont:	jmp	libmio_setfont

;--------------------------------------------------------------------------------
;text functions r20=value
;--------------------------------------------------------------------------------
api_clrscr:	jmp	libmio_clr
api_outchar:	jmp	libmio_char
api_outdez:	jmp	libmio_outd
api_outhex:	jmp	libmio_outh
api_gotoxy:	jmp	libmio_gxy
api_romtext:	jmp	libmio_orom
api_thistext:	jmp	libmio_othis
api_cbox:	clt
		jmp	libmio_cbox
api_ibox:	set
		jmp	libmio_cbox
api_scroll:	jmp	libmio_scrl
api_newline:	jmp	libmio_newline
api_sprite:	jmp	libmio_spritex
api_cursor:	call	libmio_gxy
		jmp	libmio_cursor

;--------------------------------------------------------------------------------
;keyboard functions r20=value
;--------------------------------------------------------------------------------
api_waitkey:	jmp	libmio_waitkey
api_nokey:	jmp	libmio_nokey
api_kstate:	lds	tempreg1,libmio_kbdstate
		andi	tempreg1,0x1f
		ret
api_kflags:	lds	tempreg1,libmio_kflags
		ret

api_getkey:	lds	tempreg1,libmio_keycode
		ret
api_lastkey:	lds	tempreg1,libmio_lastkey
		ret
api_scancode:	lds	tempreg1,libmio_scancode
		ret

;-------------------------------------------------------------------------------
; comm functions
;-------------------------------------------------------------------------------
api_putser:	jmp	libmio_pser
api_getser:	jmp	libmio_gser
api_getserb:	jmp	libmio_gserb
api_putser2:	jmp	libmio_pser2
api_getser2:	jmp	libmio_gser2
api_getserb2:	jmp	libmio_gserb2
api_putpar:	jmp	libmio_ppar
api_putxm:	jmp	libmio_txbl
api_getxm:	jmp	libmio_rxbl
api_putsernl:	jmp	libmio_sernl
api_putsernl2:	jmp	libmio_sernl2
api_baud2:	jmp	libmio_baud2
api_hexline:	jmp	libmio_scrs_li

;-------------------------------------------------------------------------------
; graphic functions
;-------------------------------------------------------------------------------
api_plot:	jmp	libmio_plot
api_draw:	jmp	libmio_draw
api_box:	jmp	libmio_box
api_fbox:	jmp	libmio_fbox
api_circle:	call	bas_g4c_1
		jmp	libmio_circle
api_fcircle:	call	bas_g4c_1
		jmp	libmio_fcircle
api_bcopy1:	jmp	libmio_bc1
api_bcopy2:	jmp	libmio_bc2
api_bcopy3:	jmp	libmio_bc3

;-------------------------------------------------------------------------------
; UI
;-------------------------------------------------------------------------------
api_menu:	jmp	libmio_menu
api_drawmenu:	jmp	libmio_domenu
api_alert:	jmp	libmio_abox1
api_ask:	jmp	libmio_ynbox1
api_alertthis:	jmp	libmio_abox
api_askthis:	jmp	libmio_ynbox
api_alert_nb:	jmp	libmio_aboxn1
api_ask_nb:	jmp	libmio_ynboxn1
api_alertthis_nb:	jmp	libmio_aboxn
api_askthis_nb:	jmp	libmio_ynboxn


api_wbox:	jmp	libmio_wbox
api_whbox:	jmp	libmio_whbox
api_saywrite:	jmp	fsys_wal
api_saytransfer:	jmp	fsys_tal

;-------------------------------------------------------------------------------
; sound
;-------------------------------------------------------------------------------
api_note:	jmp	libmio_note
api_setvolume:	jmp	libmio_setvol
api_startseq:	jmp	libmio_startsq
api_setseq:	jmp	libmio_setseq
api_getseq:	jmp	libmio_getseq

;-------------------------------------------------------------------------------
; I2C
;-------------------------------------------------------------------------------
api_i2c_read:	jmp	libi2c_read
api_i2c_write:	jmp	libi2c_write
api_i2c_start:	jmp	libi2c_start
api_i2c_stop:	jmp	libi2c_stop
api_i2c_rbyte:	jmp	libi2c_rbyte
api_i2c_rbyten:	jmp	libi2c_rbyten
api_i2c_wbyte:	jmp	libi2c_wbyte
api_i2c_rlm75:	jmp	libi2c_rlm75

;-------------------------------------------------------------------------------
; EEPROM
;-------------------------------------------------------------------------------
api_eep_read:	jmp	libeep_read
api_eep_write:	jmp	libeep_write

;-------------------------------------------------------------------------------
; Math
;-------------------------------------------------------------------------------
api_abs:	jmp	expar_absa
api_add:	jmp	expar_add
api_sub:	jmp	expar_sub
api_mul:	jmp	expar_mul
api_div:	jmp	expar_div
api_sin:	jmp	expar_sin
api_cos:	jmp	expar_cos
api_eq:		jmp	expar_eq
api_lt:		jmp	expar_gt
api_gt:		jmp	expar_lt
api_sqr:	jmp	expar_sqr_u
api_rnd:	jmp	expar_rnd
api_adc:	jmp	expar_adc
api_dbit:	jmp	expar_dbit

;-------------------------------------------------------------------------------
; Dataflash
;-------------------------------------------------------------------------------
api_fs_create:	call	libdfl_rput
		jmp	fsys_create

api_fs_delete:	call	libdfl_rput
		jmp	fsys_delete

api_fs_read:	call	libdfl_rput
		jmp	fsys_read
		
api_fs_write:	call	libdfl_rput
		jmp	fsys_write

api_fs_cfree:	jmp	libdfl_cfree
api_fs_size:	jmp	libdfl_size
api_fs_checkf:	jmp	libdfl_cif

api_fs_gettype:	call	libdfl_gheada
		jmp	libdfl_gtype

api_fs_rread:	clr	ereg
		jmp	fsys_readraw

api_fs_rwrite:	clr	ereg
		jmp	fsys_writeraw

api_fs_fsize:	jmp	expar_fsize

api_fs_ffind:	jmp	expar_ffind

api_fs_fsel:	jmp	fsys_fileselect
api_fs_fsel_nb:	jmp	fsys_fileselect2

api_fs_check:	jmp	fsys_check

;-------------------------------------------------------------------------------
; misc
;-------------------------------------------------------------------------------
api_copychar4:	jmp	libmio_cpbits4

api_copychar6:	jmp	libmio_cpbits6

api_basrun:	jmp	basrun

api_exparser:	jmp	expar

api_tparser:	jmp	tparser

api_lfind:	jmp	lfind

api_lcall:	jmp	lcall

api_preceive:	jmp	recv_prog_a

api_psend:	jmp	send_prog_a

api_wpage:	jmp	mem_writepage

api_arrview:	jmp	mon_varr

api_extsearch:	jmp	sys_extsearch

api_extdisable:	jmp	sys_extdisable

;-------------------------------------------------------------------------------
; extension
;-------------------------------------------------------------------------------
api_basgetpar:	jmp	bas_getpar

api_basgetvar:	jmp	bas_getvar

;-------------------------------------------------------------------------------
; VM0 jumps
;-------------------------------------------------------------------------------
api_vm0line:	pop	r0
		pop	r0
		jmp	libmio_tvc_0

api_vm0cls:	rcall	pushxyz
		jmp	libmio_fill

api_vm0char:	push	XL
		push	XH
		jmp	libmio_char_ap

api_vm0gotoxy:	jmp	libmio_gxy_ap

api_vm0plot:	jmp	libmio_iplot

api_vm0newline:	push	XL
		push	XH
		jmp	libmio_nlap

;-------------------------------------------------------------------------------
; screen save/restore
;-------------------------------------------------------------------------------
api_sbackup:	jmp	mon_backup

api_srestore:	jmp	mon_restore

api_screenshot:	jmp	libmio_scrs

;-------------------------------------------------------------------------------
; array functions
;-------------------------------------------------------------------------------
api_aread:	jmp	arr_read1

api_awrite:	jmp	arr_write1

api_pageset:	sts	xram_page,XL
		ret

api_pageget:	lds	XL,xram_page
		ret

;-------------------------------------------------------------------------------
; new since v1.37
;-------------------------------------------------------------------------------

api_scale:	jmp	math_scale

api_spisel:	jmp	libdfl_sel

api_spiunsel:	jmp	libdfl_unsel

api_spicomm:	jmp	libdfl_out

;-------------------------------------------------------------------------------
;
;-------------------------------------------------------------------------------
api_xmem_rb:	ldi	ZL,xmem_bread
		rjmp	a_xmemcheck

api_xmem_rw:	ldi	ZL,xmem_wread
		rjmp	a_xmemcheck

api_xmem_wb:	ldi	ZL,xmem_bwrite
		rjmp	a_xmemcheck

api_xmem_ww:	ldi	ZL,xmem_wwrite
		rjmp	a_xmemcheck

api_xmem_chk:	ldi	ZL,xmem_check
		rjmp	a_xmemcheck

api_xmem_clr:	ldi	ZL,xmem_clear

a_xmemcheck:	lds	ZH,prg_xmem
		sbrs	ZH,7
		ijmp
		pop	r0			;kill stack
		pop	r0
		ret