--------------------------------------------------------------------------------
-- Company: 
-- Engineer:		Joerg Wolfram
--
-- Create Date:		29.06.2010
-- Design Name:
-- Module Name:
-- Project Name:	xram_64
-- Target Device:	XC9536-15-PC44
-- Tool versions:
-- Description:		parport-ram 64k for chipbasic2
--
-- Revision:		0.1
-- License:		GPL
--------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity mylogik is

port (
-------------------------------------------------------------------------------
--- Die IO-Signale
-------------------------------------------------------------------------------
	data:		in std_logic_vector(7 downto 0);
	strobe:		in std_logic;
	busy:		in std_logic;

	oe,we:		out std_logic;
	cs1,cs2:	out std_logic;

	addr:		out std_logic_vector(14 downto 0));

end entity mylogik;

architecture version1 of mylogik is

signal adr:		std_logic_vector(15 downto 0);
signal htemp:		std_logic_vector(7 downto 0);

signal	rwsel	:	std_logic;

begin
-------------------------------------------------------------------------------
--- store wr/rd
-------------------------------------------------------------------------------
process(strobe) is
begin
	if falling_edge(strobe) then
		rwsel <= data(0);
	end if;
end process;


-------------------------------------------------------------------------------
--- store hi addr
-------------------------------------------------------------------------------
process(strobe) is
begin
	if falling_edge(busy) then
		htemp <= data(7 downto 0);
	end if;
end process;

-------------------------------------------------------------------------------
--- Address counter
-------------------------------------------------------------------------------
process(busy) is
begin
	if rising_edge(busy) then
		if (strobe='0') then
			adr(15 downto 8) <= htemp(7 downto 0);
			adr(7 downto 0) <= data(7 downto 0);
		else
			adr <= adr + 1;
		end if;
	end if;
end process;

-------------------------------------------------------------------------------
--- memory address
-------------------------------------------------------------------------------
addr <= adr(14 downto 0);

-------------------------------------------------------------------------------
--- OE for RAM
-------------------------------------------------------------------------------
oe <= busy or not(rwsel) or not(strobe);

-------------------------------------------------------------------------------
--- WE for RAM
-------------------------------------------------------------------------------
we <= busy or rwsel or not(strobe);

-------------------------------------------------------------------------------
--- CS signals
-------------------------------------------------------------------------------
---cs1 <= busy or adr(15) or not(strobe);
   cs1 <= adr(15);

---cs2 <= busy or not(adr(15)) or not(strobe);
   cs2 <= not(adr(15));

-------------------------------------------------------------------------------
--- minimale Konfiguration
-------------------------------------------------------------------------------
end architecture version1;

configuration main of mylogik is
    for version1
    end for;
end configuration main;
