;################################################################################
;#										#
;# vector mode 7 engine								#
;# copyright (c) 2005-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################
.CSEG
.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.org	0x7200
;                   "......      N"  
start:		.db "Vector mode N",0xf3,0xfe,0x91

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,"VM",0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;IO ext
		rjmp	outex			;IO ext
		ret				;FKT 00 ID
		rjmp	vecmode_init		;FKT 01 init
		rjmp	vecmode_cls		;FKT 02 clear screen
		rjmp	vecmode_char		;FKT 03 output char
		rjmp	vecmode_gxy		;FKT 04 set cursor
		ret				;FKT 05 plot
		ret				;FKT 06 NL
		rjmp	vecmode_vid		;FKT 07 video display

		ret				;FKT 08 startup

		rjmp	vecmode_cvec		;FKT 09 clear vector
		rjmp	vecmode_cfill		;FKT 10 lineptr constant fill
		rjmp	vecmode_ifill		;FKT 11 lineptr incremental fill
		rjmp	vecmode_dfill		;FKT 12 lineptr decremental fill
		rjmp	vecmode_afill		;FKT 13 lineptr array fill
		rjmp	vecmode_pcopy		;FKT 14 lineptr copy
		rjmp	vecmode_kfill		;FKT 15 line fill from array (constant)
		rjmp	vecmode_lfill		;FKT 16 line fill from array
		ret				;FKT 17
		ret				;FKT 18
		ret				;FKT 19
		ret				;FKT 20


inex:		ldi	ereg,40			;no IO driver
		ret

outex:		ldi	ereg,40			;no IO driver
		ret

;-------------------------------------------------------------------------------
; -output character lines and vector area, 9 clocks per pixel
;-------------------------------------------------------------------------------
;upper text line
vecmode_t1:	ldi	XL,LOW(libmio_vram)	;1
		ldi	XH,HIGH(libmio_vram)	;1
		ldi	YL,LOW(libmio_vram+60)	;1
		ldi	YH,HIGH(libmio_vram+60)	;1
		subi	tempreg1,0xf6		;1 +10
		sts	libmio_cline,tempreg1	;2
		api_vm0line			;view textline

;lower text line
vecmode_t2:	ldi	XL,LOW(libmio_vram+30)	;1
		ldi	XH,HIGH(libmio_vram+30)	;1
		ldi	YL,LOW(libmio_vram+90)	;1
		ldi	YH,HIGH(libmio_vram+90)	;1
		subi	tempreg1,210		;1
		sts	libmio_cline,tempreg1	;2
		api_vm0line			;view textline

vecmode_novid:	ret

vecmode_vid:	mov	tempreg1,vline_l	;1
		subi	tempreg1,5
		brcs	vecmode_novid
		subi	tempreg1,10		;1
		brcc	vecmode_01		;1/2
		rjmp	vecmode_t1		;2 upper text line
vecmode_01:	cpi	tempreg1,210		;1
		brcs	vecmode_02		;1/2
		rjmp	vecmode_t2		;2 lower text line
vecmode_02:	;jmp	libmio_is_15		;DEBUG
		ldi	tempreg2,24		;1
		lsr	tempreg1		;1
		ldi	XL,LOW(libmio_vram+120)	;1
		ldi	XH,HIGH(libmio_vram+120);1
		add	XL,tempreg1		;1
		adc	XH,const_0		;1
		ld	tempreg1,X		;2
		mul	tempreg1,tempreg2	;1
		ldi	XL,LOW(libmio_vram+225)	;1
		ldi	XH,HIGH(libmio_vram+225);1
		add	XL,r0			;1
		adc	XH,r1			;1
		ldi	YL,159			;1 set initial counter

;set 1
		ld	tempreg1,X+		;2 position
		ld	tempreg2,X+		;value
vecmode_10:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_11		;2
		nop				;1
		nop				;1
		nop				;1
		cp	YL,const_0		;1
		brne	vecmode_10		;2
		rjmp	vecmode_e

;set 2
vecmode_11:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
vecmode_12:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_13		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	vecmode_12		;2
		rjmp	vecmode_e

;set 3
vecmode_13:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
vecmode_14:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_15		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	vecmode_14		;2
		rjmp	vecmode_e

;set 4
vecmode_15:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
vecmode_16:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_17		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	vecmode_16		;2
		rjmp	vecmode_e

;set 5
vecmode_17:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
vecmode_18:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_19		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	vecmode_18		;2
		rjmp	vecmode_e

;set 6
vecmode_19:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
vecmode_20:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_21		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	vecmode_20		;2
		rjmp	vecmode_e

;set 7
vecmode_21:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
vecmode_22:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_23		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	vecmode_22		;2
		rjmp	vecmode_e

;set 8
vecmode_23:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
vecmode_24:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_25		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	vecmode_24		;2
		rjmp	vecmode_e

;set 9
vecmode_25:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
vecmode_26:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_27		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	vecmode_26		;2
		rjmp	vecmode_e

;set 10
vecmode_27:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
vecmode_28:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_29		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	vecmode_28		;2
		rjmp	vecmode_e


;set 11
vecmode_29:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg3		;1 set cvalue
		ld	tempreg2,X+		;2 value
vecmode_30:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_31		;2
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	vecmode_30		;2
		rjmp	vecmode_e

;set 12
vecmode_31:	ld	tempreg1,X+		;2 position
		out	PORTC,tempreg2		;1 set cvalue
		ld	tempreg3,X+		;2 value
vecmode_32:	inc	YL			;1
		cp	YL,tempreg1		;1
		breq	vecmode_33		;2
		nop				;1
		swap	tempreg2		;1
		out	PORTC,tempreg2		;1
		cp	YL,const_0		;1
		brne	vecmode_32		;2
		rjmp	vecmode_e


;set 12x
vecmode_33:	nop
		nop
		out	PORTC,tempreg3		;1 set cvalue
		nop
		nop
vecmode_34:	inc	YL			;1
		cp	YL,tempreg1		;1
		nop
		nop				;1
		swap	tempreg3		;1
		out	PORTC,tempreg3		;1
		cp	YL,const_0		;1
		brne	vecmode_34		;2
		rjmp	vecmode_e

vecmode_e:
;the end
vecmode_1x:	lds	tempreg2,libmio_border	;2
		nop
		nop
		out	PORTC,tempreg2		;1
		ret


;-------------------------------------------------------------------------------
; clear vector area
;-------------------------------------------------------------------------------
vecmode_cvec:	api_pushxyz
		ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		ldi	XL,105
vecmode_cvec_0:	st	Y+,const_0
		dec	XL
		brne	vecmode_cvec_0
		ldi	XL,LOW(105*12)		;lines * (bytesperline+1)
		ldi	XH,HIGH(105*12)
vecmode_cvec_1:	st	Y+,const_1
		st	Y+,const_0
		sbiw	XL,1
		brne	vecmode_cvec_1
		api_popxyz

;------------------------------------------------------------------------------
;output screenshot
;------------------------------------------------------------------------------
vecmode_scrs:	ldi	ZH,92			;number of charlines
vecmode_scrs1:	ldi	ZL,libmio_cols		;number of chars per line
		api_hexline
		dec	ZH
		brne	vecmode_scrs1
		ret

;-------------------------------------------------------------------------------
; clear screen
;-------------------------------------------------------------------------------
vecmode_cls:	rcall	vecmode_ctxt		;clear text
		ret

;-------------------------------------------------------------------------------
; clear text area
;-------------------------------------------------------------------------------
vecmode_ctxt:	api_pushxyz
		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	XL,60			;chars
		ldi	XH,32			;space
		lds	r0,libmio_color
vecmode_ctxt1:	std	Y+60,r0			;write attr
		st	Y+,XH			;write char
		dec	XL
		brne	vecmode_ctxt1
		api_popxyz

;------------------------------------------------------------------------------
; set video mode
;------------------------------------------------------------------------------
vecmode_init:	brtc	vecmode_i_e		;no exit
		ldi	XL,libmio_v0cols
		sts	libmio_clipx2,XL
		ldi	XL,2
		sts	libmio_clipy2,XL
		rcall	vecmode_ctxt
		rcall	vecmode_cvec
		ldi	XL,235
vecmode_i_e:	ret

;-------------------------------------------------------------------------------
; output character and calculate new position (tempreg1=char)
;-------------------------------------------------------------------------------
vecmode_char:	push	XL
		push	XH
		push	YL
		push	YH
		movw	XL,libmio_cur_x		;X
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		add	YL,XL			;position+x
		adc	YH,const_0
		ldi	XL,0
		sbrc	XH,0
		ldi	XL,30
		add	YL,XL			;position+(cols*y)
		adc	YH,const_0
		st	Y,tempreg1		;write char
		ldi	XH,60
		add	YL,XH			;position+(cols*y)
		adc	YH,const_0
		lds	XH,libmio_color
		st	Y,XH

		movw	XL,libmio_cur_x		;X
		inc	XL
		cpi	XL,30
		brcs	vecmode_chr_1
		clr	XL
		inc	XH
vecmode_chr_1:	andi	XH,1
		movw	libmio_cur_x,XL
		pop	YH
		pop	YL
		pop	XH
		pop	XL
		ret

;-------------------------------------------------------------------------------
; set cursor to position XL:XH
;-------------------------------------------------------------------------------
vecmode_gxy:	movw	libmio_cur_x,XL		;save X,Y-position
		ret

retzero:	ldi	XL,0
		ldi	XH,0
retvalue:	api_getvalues
		st	Y+,XL
		st	Y+,XH
		ret

;-------------------------------------------------------------------------------
; fill linepointers constant
;-------------------------------------------------------------------------------
vecmode_cfill:	api_getvalues
		ldd	r16,Y+2			;start pointer
		ldd	r17,Y+4			;pointers
		ldd	r18,Y+6			;value

vecmode_cf_1:	cpi	r16,105
		brcs	vecmode_cf_2
		subi	r16,105
		rjmp	vecmode_cf_1

vecmode_cf_2:	cpi	r18,105
		brcs	vecmode_cf_3
		subi	r18,105
		rjmp	vecmode_cf_2

vecmode_cf_3:	ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		add	YL,r16
		adc	YH,const_0
		st	Y,r18
		inc	r16
		dec	r17
		brne	vecmode_cf_1
		rjmp	retzero

;-------------------------------------------------------------------------------
; fill linepointers incremental
;-------------------------------------------------------------------------------
vecmode_ifill:	api_getvalues
		ldd	r16,Y+2			;start pointer
		ldd	r17,Y+4			;pointers
		ldd	r18,Y+6			;value

vecmode_if_1:	cpi	r16,105
		brcs	vecmode_if_2
		subi	r16,105
		rjmp	vecmode_if_1

vecmode_if_2:	cpi	r18,105
		brcs	vecmode_if_3
		subi	r18,105
		rjmp	vecmode_if_2

vecmode_if_3:	ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		add	YL,r16
		adc	YH,const_0
		st	Y,r18
		inc	r18
		inc	r16
		dec	r17
		brne	vecmode_if_1
		rjmp	retzero

;-------------------------------------------------------------------------------
; fill linepointers decremental
;-------------------------------------------------------------------------------
vecmode_dfill:	api_getvalues
		ldd	r16,Y+2			;start pointer
		ldd	r17,Y+4			;pointers
		ldd	r18,Y+6			;value

vecmode_df_1:	cpi	r16,105
		brcs	vecmode_df_2
		subi	r16,105
		rjmp	vecmode_df_1

vecmode_df_2:	cpi	r18,105
		brcs	vecmode_df_3
		subi	r18,105
		rjmp	vecmode_df_2

vecmode_df_3:	ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		add	YL,r16
		adc	YH,const_0
		st	Y,r18
		inc	r16
		dec	r18
		brcc	vecmode_df_4
		ldi	r18,104
vecmode_df_4:	dec	r17
		brne	vecmode_df_1
		rjmp	retzero

;-------------------------------------------------------------------------------
; fill linepointers from array
;-------------------------------------------------------------------------------
vecmode_afill:	api_getvalues
		ldd	r16,Y+2			;start pointer
		ldd	r17,Y+4			;pointers
		ldd	XL,Y+6			;array ptr
		ldd	XH,Y+7

		api_getarray
		movw	r0,YL

vecmode_af_1:	cpi	r16,105
		brcs	vecmode_af_2
		subi	r16,105
		rjmp	vecmode_af_1

vecmode_af_2:	cpi	XH,3
		brcs	vecmode_af_3
		clr	XH

		movw	YL,r0
		add	YL,XL
		adc	YH,XH
		ld	r18,Y

vecmode_af_3:	cpi	r18,105
		brcs	vecmode_af_4
		subi	r18,105
		rjmp	vecmode_af_3

vecmode_af_4:	ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		add	YL,r16
		adc	YH,const_0
		st	Y,r18
		inc	r16
		adiw	XL,1
		dec	r17
		brne	vecmode_af_1
		rjmp	retzero

;-------------------------------------------------------------------------------
; copy linepointers
;-------------------------------------------------------------------------------
vecmode_pcopy:	api_getvalues
		ldd	r16,Y+2			;source pointer
		ldd	r17,Y+4			;target ptr
		ldd	r18,Y+6			;number
		ldd	XH,Y+7

		sbrc	XH,7
		rjmp	vecmode_pcpn		;negative

vecmode_pcp_1:	cpi	r16,105
		brcs	vecmode_pcp_2
		subi	r16,105
		rjmp	vecmode_pcp_1

vecmode_pcp_2:	cpi	r17,105
		brcs	vecmode_pcp_3
		subi	r17,105
		rjmp	vecmode_pcp_2


vecmode_pcp_3:	ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		add	YL,r16
		adc	YH,const_0
		ld	r0,Y
		ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		add	YL,r17
		adc	YH,const_0
		st	Y,r0
		inc	r16
		inc	r17
		dec	r18
		brne	vecmode_pcp_1
		rjmp	retzero

vecmode_pcpn:	neg	r18
		add	r16,r18
		dec	r16
		add	r17,r18
		dec	r17

vecmode_pcp_5:	cpi	r16,105
		brcs	vecmode_pcp_6
		subi	r16,105
		rjmp	vecmode_pcp_5

vecmode_pcp_6:	cpi	r17,105
		brcs	vecmode_pcp_7
		subi	r17,105
		rjmp	vecmode_pcp_6

vecmode_pcp_7:	sbrc	r16,7
		ldi	r16,104
		sbrc	r17,7
		ldi	r17,104
		ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		add	YL,r16
		adc	YH,const_0
		ld	r0,Y
		ldi	YL,LOW(libmio_vram+120)
		ldi	YH,HIGH(libmio_vram+120)
		add	YL,r17
		adc	YH,const_0
		st	Y,r0
		dec	r16
		dec	r17
		dec	r18
		brne	vecmode_pcp_5
		rjmp	retzero

;-------------------------------------------------------------------------------
; fill lines from array
;-------------------------------------------------------------------------------
vecmode_lfill:	api_getvalues
		ldd	r16,Y+2			;start line
		ldd	r17,Y+4			;number of lines
		ldd	XL,Y+6			;array ptr
		ldd	XH,Y+7

vecmode_lf_1:	cpi	r16,105
		brcs	vecmode_lf_2
		subi	r16,105
		rjmp	vecmode_lf_1

vecmode_lf_2:	ldi	ZL,LOW(libmio_vram+225)
		ldi	ZH,HIGH(libmio_vram+225)
		ldi	r18,24			;bytes per line
		mul	r18,r16
		add	ZL,r0
		adc	ZH,r1

vecmode_lf_3:	cpi	XH,3
		brcs	vecmode_lf_4
		clr	XH
vecmode_lf_4:	api_getarray
		add	YL,XL
		adc	YH,XH

		ld	r0,Y
		st	Z+,r0
		adiw	XL,1			;inc array ptr
		dec	r18
		brne	vecmode_lf_3

		inc	r16			;next line
		dec	r17
		brne	vecmode_lf_1

		rjmp	retzero

;-------------------------------------------------------------------------------
; fill lines from array
;-------------------------------------------------------------------------------
vecmode_kfill:	api_getvalues
		ldd	r16,Y+2			;start line
		ldd	r17,Y+4			;number of lines
		ldd	XL,Y+6			;array ptr
		ldd	XH,Y+7

vecmode_kf_1:	cpi	r16,105
		brcs	vecmode_kf_2
		subi	r16,105
		rjmp	vecmode_kf_1

vecmode_kf_2:	ldi	ZL,LOW(libmio_vram+225)
		ldi	ZH,HIGH(libmio_vram+225)
		ldi	r18,24			;bytes per line
		mul	r18,r16
		add	ZL,r0
		adc	ZH,r1

vecmode_kf_3:	cpi	XH,3
		brcs	vecmode_kf_4
		clr	XH
vecmode_kf_4:	api_getarray
		add	YL,XL
		adc	YH,XH

		ld	r0,Y
		st	Z+,r0
		adiw	XL,1			;inc array ptr
		dec	r18
		brne	vecmode_kf_3

		inc	r16			;next line
		dec	r17
		sbiw	XL,24
		brne	vecmode_kf_1

		rjmp	retzero
