;------------------------------------------------------------------------------
; dual mode (BAS/LCD) out
;------------------------------------------------------------------------------
lcd_vid:	mov	tempreg1,vline_l
		cpi	tempreg1,lcd_ystart
		brcs	lcd_nvid
		cpi	tempreg1,lcd_yend
		brcc	lcd_nvid
		rcall	lcd_vline		;tv color line
		ret				;end of vout routine -> VS/Frame handling

lcd_nvid:	sts	lcd_pixline,const_0	;pixline
		sts	lcd_linedoubler,const_0	;charline
		lds	XL,lcd_enable		;enable update?
		cpi	XL,0
		breq	lcd_nvid_1		;no update
		lds	XL,lcd_datavalid	;data to write?
		cpi	XL,1			;check
		breq	lcd_c2			;write data
		rjmp	lcd_c1			;prepare data
lcd_nvid_1:	ret				;do nothing

;prepare data
lcd_c1:		sbrc	vline_l,2		;cg/dd switch
		rjmp	lcd_c3			;CG RAM service

;update DD RAM data
		lds	XL,lcd_colcount		;col counter
		lds	XH,lcd_rowcount		;row counter
		inc	XL
		cpi	XL,lcd_cols
		brcs	lcd_c1_10		;no X overflow
		clr	XL
		inc	XH
		cpi	XH,lcd_rows
		brcs	lcd_c1_10		;no Y overflow
		clr	XH
lcd_c1_10:	sts	lcd_colcount,XL		;new col counter
		sts	lcd_rowcount,XH		;new row counter
		rcall	lcd_acalc		;calc vram address
		ld	tempreg1,Y		;to write
		ld	tempreg2,Z		;visible char
		cp	tempreg1,tempreg2	;differ?
		brne	lcd_c1_20		;yes, update
		ret

lcd_c1_20:	st	Z,tempreg1		;set visible as written
		sts	lcd_datavalid,const_1	;set write flag
		sts	lcd_databyte,tempreg1	;data to write
		rcall	lcd_pcalc		;calculate position in LCD
		ori	tempreg1,0x80		;bit for DDRAM address
		rjmp	lcd_cout		;control output

;second cycle writes data
lcd_c2:		sts	lcd_datavalid,const_0	;clear write flag
		lds	tempreg1,lcd_databyte	;data to write
		rjmp	lcd_dout		;data output

;update CG RAM data
lcd_c3:	lds	XL,lcd_cgptr		;cg ram counter
		inc	XL
		cpi	XL,64
		brcs	lcd_c3_10		;no X overflow
		clr	XL
lcd_c3_10:	sts	lcd_cgptr,XL		;new col counter
		rcall	lcd_ccalc		;calc vram address
		ld	tempreg1,Y		;to write
		ld	tempreg2,Z		;visible char
		cp	tempreg1,tempreg2	;differ?
		brne	lcd_c3_20		;yes, update
		ret

lcd_c3_20:	st	Z,tempreg1		;set visible as written
		sts	lcd_datavalid,const_1	;set write flag
		sts	lcd_databyte,tempreg1	;data to write
		mov	tempreg1,XL
		andi	tempreg1,0x3f		;limit to 64
		ori	tempreg1,0x40		;bit for CG RAM address
		rjmp	lcd_cout		;control output



;calculate data for first char
lcd_vline:	lds	YH,lcd_pixline		;PCC
		lds	XL,libmio_rampos_l
		lds	XH,libmio_rampos_h
		lds	tempreg1,libmio_color	;2 get color byte
		out	PORTC,tempreg1		;1
		push	tempreg4
		subi	YH,1
		brcs	lcd_dline_e
		cpi	YH,7
		brcc	lcd_dline
		ldi	YL,8			;1 8 bytes/char
		ld	ZL,X+			;2
		mul	ZL,YL			;2
		ldi	ZL,LOW(lcd_charset)	;1
		ldi	ZH,HIGH(lcd_charset)	;1
		add	ZL,r0			;1 add character offset
		adc	ZH,r1			;1
		add	ZL,YH			;1 add cline offset
		adc	ZH,const_0		;1
		ld	tempreg3,Z		;2
		ldi	tempreg4,lcd_cols	;1 number of chars
		lds	tempreg2,libmio_color	;2 color for pixpause

lcd_vloop:	mov	tempreg1,tempreg2	;1 get color
		sbrc	tempreg3,4		;1 skip if pix is off
		swap	tempreg1		;1
		out	PORTC,tempreg1		;1 out pix 4

		ld	ZL,X+			;2 get next byte
		mov	tempreg1,tempreg2	;1
		sbrc	tempreg3,3		;1 skip if pix is not changed
		swap	tempreg1		;1
		ldi	ZH,HIGH(lcd_charset)	;1
		out	PORTC,tempreg1		;1 out pix 3

		mov	tempreg1,tempreg2	;1
		sbrc	tempreg3,2		;1 skip if pix is not changed
		swap	tempreg1		;1
		mul	ZL,YL			;2
		ldi	ZL,LOW(lcd_charset)	;1
		out	PORTC,tempreg1		;1 out pix 2

		mov	tempreg1,tempreg2	;1
		sbrc	tempreg3,1		;1 skip if pix is not changed
		swap	tempreg1		;1
		add	ZL,r0			;1 add character offset
		adc	ZH,r1			;1
		nop				;1
		out	PORTC,tempreg1		;1 out pix 1


		mov	tempreg1,tempreg2	;1
		sbrc	tempreg3,0		;1 skip if pix is not changed
		swap	tempreg1		;1
		add	ZL,YH			;1 add cline offset
		adc	ZH,const_0		;1
		nop				;1
		out	PORTC,tempreg1		;1 out pix 0

		ld	tempreg3,Z		;2
		ld	tempreg3,Z		;2
		ld	tempreg3,Z		;1
		out	PORTC,tempreg2		;1 out pixpause
		dec	tempreg4		;1 loop counter
		brne	lcd_vloop		;2/1

		ldi	tempreg2,1
lcd_dline_0:	dec	tempreg2
		brne	lcd_dline_0
		nop
		nop
		rjmp	lcd_nline

lcd_dline_e:	nop
		nop
lcd_dline:	ldi	tempreg2,172
lcd_dline_1:	dec	tempreg2
		nop
		nop
		brne	lcd_dline_1
		nop
		nop
		nop


lcd_nline:	pop	tempreg4
		lds	tempreg2,libmio_border	;2
		lds	YL,lcd_linedoubler
		lds	ZH,lcd_pixline		;2 character line
		inc	YL
		cpi	YL,2
		out	PORTC,tempreg2		;1 out border
		brne	lcd_nline_1
		clr	YL
		inc	ZH
		cpi	ZH,9			;1 check
		brne	lcd_nline_1		;2 jump if not next line
		clr	ZH			;1 character line = 0
		lds	XL,libmio_rampos_l
		lds	XH,libmio_rampos_h
		adiw	XL,lcd_cols
		sts	libmio_rampos_l,XL	;2 new memory position
		sts	libmio_rampos_h,XH	;2 new memory position
lcd_nline_1:	sts	lcd_linedoubler,YL
		sts	lcd_pixline,ZH		;2 new character line
		rjmp	get_keys


