;################################################################################
;#										#
;# text LCD routines								#
;# copyright (c) 2005-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; init mode
;-------------------------------------------------------------------------------
lcd_init:	sts	lcd_enable,const_0	;disable update
		sts	lcd_colcount,const_0	;col counter
		sts	lcd_rowcount,const_0	;row counter
		sts	lcd_datavalid,const_0	;no write
		sts	lcd_databyte,const_0	;data to write
		sts	lcd_cgptr,const_0	;CG counter
		brtc	lcd_exit		;exit
		ldi	XL,0xf0
		out	DDRA,XL
		sbi	DDRB,1
		sbi	DDRB,2
		rcall	lcd_setup
		rcall	lcd_ccopy
		rcall	lcd_cls
		ldi	XL,LOW(lcd_ctable-start)
		ldi	XH,HIGH(lcd_ctable-start)
		api_dataptr
		sts	lcd_cmap_l,ZL
		sts	lcd_cmap_h,ZH
		sts	lcd_enable,const_1	;enable update
		ldi	XL,224			;visible lines
		ret

lcd_exit:	push	XL
		out	DDRA,const_0		;input
		cbi	DDRB,2			;busy
		pop	XL
		ret

lcd_setup:	ldi	tempreg2,10
lcd_setup_1:	api_sync
		dec	tempreg2
		brne	lcd_setup_1
		cbi	PORTB,2			;control
		ldi	tempreg1, 0x03		; muss 3mal hintereinander gesendet
		rcall	lcd_outbits
		rcall	lcd_epulse
		api_sync
		api_sync
		rcall	lcd_epulse
		api_sync
		api_sync
		rcall	lcd_epulse
		api_sync
		api_sync
		ldi 	tempreg1,0x02		;muss 2mal hintereinander gesendet
		rcall	lcd_outbits
		rcall	lcd_epulse
		api_sync
		api_sync
		ldi	tempreg1,0x28		;function set
		rcall	lcd_cout
		api_sync
		api_sync
		ldi	tempreg1,0x0c		;display on
		rcall	lcd_cout
		api_sync
		api_sync
		ldi	tempreg1,0x04		;no shift
		rcall	lcd_cout
		api_sync
		ret


;-------------------------------------------------------------------------------
; copy chartable
;-------------------------------------------------------------------------------
lcd_ccopy:	ldi	XL,LOW(lcd_ctable-start)
		ldi	XH,HIGH(lcd_ctable-start)
		api_dataptr
		ldi	YL,LOW(lcd_charset)
		ldi	YH,HIGH(lcd_charset)
;32 empty chars 0-31
		ldi	XL,0x40
lcd_ccopy_1:	st	Y+,const_0
		dec	XL
		brne	lcd_ccopy_1
		ldi	XL,0xc0
lcd_ccopy_1a:	st	Y+,const_1
		dec	XL
		brne	lcd_ccopy_1a
;96 chars 32-127
		ldi	XH,3
		clr	XL
lcd_ccopy_2:	lpm	tempreg1,Z+
		st	Y+,tempreg1
		sbiw	XL,1
		brne	lcd_ccopy_2
;32 empty chars 128-159
		ldi	XL,0
lcd_ccopy_3:	st	Y+,const_0
		dec	XL
		brne	lcd_ccopy_3
;96 chars 160-255
		ldi	XH,3
		clr	XL
lcd_ccopy_4:	lpm	tempreg1,Z+
		st	Y+,tempreg1
		sbiw	XL,1
		brne	lcd_ccopy_4
		ret

;-------------------------------------------------------------------------------
; set cursor to position XL:XH
;-------------------------------------------------------------------------------
lcd_gxy:	cpi	XL,lcd_cols
		brcs	lcd_gxy_1
		ldi	XL,lcd_cols-1
lcd_gxy_1:	cpi	XH,lcd_rows
		brcs	lcd_gxy_2
		ldi	XL,lcd_rows-1
lcd_gxy_2:	movw	libmio_cur_x,XL		;save X,Y-position
		ret

;-------------------------------------------------------------------------------
; output char
;-------------------------------------------------------------------------------
lcd_char:	api_pushxyz
		movw	XL,libmio_cur_x		;get coordinates
		rcall	lcd_acalc
		inc	XL
		cpi	XL,lcd_cols
		brcs	lcd_char_1		;no X overflow
		clr	XL
		inc	XH
		cpi	XH,lcd_rows
		brcs	lcd_char_1		;no Y overflow
		clr	XH
lcd_char_1:	movw	libmio_cur_x,XL
		st	Y,tempreg1		;store char
lcd_char2:	api_popxyz

lcd_newl:	api_pushxyz
		movw	XL,libmio_cur_x		;get coordinates
		clr	XL
		inc	XH
		cpi	XH,lcd_rows
		brcs	lcd_newl_1		;no Y overflow
		clr	XH
lcd_newl_1:	movw	libmio_cur_x,XL
		api_popxyz


;------------------------------------------------------------------------------
; clear screen
;------------------------------------------------------------------------------
lcd_cls:	api_pushxyz
		ldi	YL,LOW(libmio_vram)		;active VRAM
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,LOW(libmio_vram+96)		;shadow VRAM
		ldi	ZH,HIGH(libmio_vram+96)
		ldi	XH,96
		ldi	XL,0x20
lcd_cls_2:	st	Y+,XL
		st	Z+,const_0
		dec	XH
		brne	lcd_cls_2
		mov	libmio_cur_x,const_0
		mov	libmio_cur_y,const_0
		api_popxyz


;------------------------------------------------------------------------------
; calc address of (XL:XH) char
;------------------------------------------------------------------------------
lcd_acalc:	ldi	YL,LOW(lcd_charmap)	;VRAM address, first LCD char
		ldi	YH,HIGH(lcd_charmap)
		ldi	ZL,lcd_cols
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0		;maximum 96 bytes
		movw	ZL,YL
		adiw	ZL,48			;visible status is addr+96
		adiw	ZL,48
		ret

;------------------------------------------------------------------------------
; calc address of (XL) charset byte
;------------------------------------------------------------------------------
lcd_ccalc:	ldi	YL,LOW(lcd_charset)	;CGRAM address, first byte
		ldi	YH,HIGH(lcd_charset)
		add	YL,XL
		adc	YH,const_0		;maximum 64 Bytes
		movw	ZL,YL
		adiw	ZL,32			;visible status is addr+64
		adiw	ZL,32
		ret

;------------------------------------------------------------------------------
; calc LCD DD-RAM address of (XL:XH) char -> tempreg1
;------------------------------------------------------------------------------
.if linesort == 1
lcd_pcalc:	ldi	ZL,56
		mov	tempreg1,XL
		sbrc	tempreg1,3
		add	tempreg1,ZL
		ret
.endif

.if linesort == 2
lcd_pcalc:	ldi	ZL,64
		mul	ZL,XH
		mov	tempreg1,r0
		add	tempreg1,XL
		ret
.endif

.if linesort == 3
lcd_pcalc:	clr	tempreg1
		sbrc	XH,0
		subi	tempreg1,0xc0		;+0x40
		sbrc	XH,1
		subi	tempreg1,0xec		;+0x14
		add	tempreg1,XL
		ret
.endif

.if linesort == 4
lcd_pcalc:	ldi	ZL,32
		mul	ZL,XH
		mov	tempreg1,r0
		add	tempreg1,XL
		ret
.endif


;-------------------------------------------------------------------------------
; output character (tempreg1=char)
;-------------------------------------------------------------------------------
lcd_dout:	sbi	PORTB,2			;data
		rjmp	lcd_cout_1

;sendet ein Controlbyte an das LCD
lcd_cout:	cbi	PORTB,2			;control
lcd_cout_1:	swap	tempreg1
		rcall	lcd_outbits
		sbi	PORTB,1                 ; Enable high
		nop
		nop
		nop
		nop
		cbi	PORTB,1
		swap	tempreg1
		rcall	lcd_outbits
		sbi	PORTB,1                 ; Enable high
		nop
		nop
		nop
		nop
		cbi	PORTB,1
		ret

lcd_outbits:	sbrc	tempreg1,0
		sbi	PORTA,4
		sbrs	tempreg1,0
		cbi	PORTA,4
		sbrc	tempreg1,1
		sbi	PORTA,5
		sbrs	tempreg1,1
		cbi	PORTA,5
		sbrc	tempreg1,2
		sbi	PORTA,6
		sbrs	tempreg1,2
		cbi	PORTA,6
		sbrc	tempreg1,3
		sbi	PORTA,7
		sbrs	tempreg1,3
		cbi	PORTA,7
		ret

;enable-pulse
lcd_epulse: 	sbi	PORTB,1                 ; Enable high
		nop
		nop
		nop
		nop
		cbi	PORTB,1
		nop
		nop
		nop
		ret



