;################################################################################
;#										#
;# libmio - multi i/o for ATMega644						#
;# video-bootloader								#
;# copyright (c) 2005-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
;pulse putput channel A+B
;16 clocks
;-------------------------------------------------------------------------------
.macro rcio_pulse
		sbiw	XL,1			;2
		sbrs	XH,7			;1
		sbi	PORTA,4			;2
		sbrc	XH,7			;1
		cbi	PORTA,4			;2
		sbiw	YL,1			;2
		sbrs	YH,7			;1
		sbi	PORTA,5			;2
		sbrc	YH,7			;1
		cbi	PORTA,5			;2
.endmacro

;-------------------------------------------------------------------------------
; output pwm channel 6+7
;-------------------------------------------------------------------------------
.macro rcio_pwmout
		in	ZL,PORTA			;current value
		andi	ZL,0x3f
		lds	tempreg1,libmio_vram+2028	;output value
		andi	tempreg1,0xc0			;only two pwm channels (6+7)
		or	tempreg1,ZL
		out	PORTA,tempreg1			;out
.endmacro

;-------------------------------------------------------------------------------
; calculate PWM channel 6
;-------------------------------------------------------------------------------
.macro rcio_pwm6
;channel 6 is normal PWM 1
		lds	tempreg1,libmio_vram+2028
		lds	ZL,libmio_vram+2020		;2 counter for channel 1
		inc	ZL				;1 +1
		cpi	ZL,0xff				;1 end
		brne	rcio_pwm6_1			;1/2 no zero
		lds	ZH,libmio_vram+2004		;2 get control value
		sts	libmio_vram+2021,ZH		;2 write to compare register
		ldi	ZL,0x00				;1 set counter
		ori	tempreg1,0x40			;1 set channel 1
rcio_pwm6_1:	sts	libmio_vram+2020,ZL		;2 store counter

		lds	tempreg3,libmio_vram+2021	;2 get compare register
		cp	tempreg3,ZL			;1 compare
		brne	rcio_pwm6_2			;1/2 not equal
		andi	tempreg1,0xbf			;1 clear channel 1
rcio_pwm6_2:	sts	libmio_vram+2028,tempreg1
.endmacro

;-------------------------------------------------------------------------------
; calculate PWM channel 7
;-------------------------------------------------------------------------------
.macro rcio_pwm7
;channel 7 is normal PWM 2
		lds	tempreg1,libmio_vram+2028
		lds	ZL,libmio_vram+2022		;counter for channel 1
		inc	ZL				;+1
		cpi	ZL,0xff				;end
		brne	rcio_pwm7_1			;no zero
		lds	ZH,libmio_vram+2006		;get control value
		sts	libmio_vram+2023,ZH		;write to compare register
		ldi	ZL,0x00				;set counter
		ori	tempreg1,0x80			;set channel 1
rcio_pwm7_1:	sts	libmio_vram+2022,ZL		;store counter

		lds	tempreg3,libmio_vram+2023	;get compare register
		cp	tempreg3,ZL			;compare
		brne	rcio_pwm7_2			;not equal
		andi	tempreg1,0x7f			;clear channel 1

rcio_pwm7_2:	sts	libmio_vram+2028,tempreg1
.endmacro

;-------------------------------------------------------------------------------
; pseudo-random generator (39C)
;-------------------------------------------------------------------------------
.macro rcio_random
rcio_rand:	push	YH
		push	YL

		ldi	YL,LOW(libmio_ram)	;1 set ptr
		ldi	YH,HIGH(libmio_ram)	;1

		lds	ZL,libmio_rand1		;2
		lds	ZH,libmio_rand2		;2
		lds	tempreg1,libmio_rand3	;2
		lds	tempreg2,libmio_rand4	;2
		mov	tempreg3,tempreg2
		lsl	tempreg3			;1
		rol	ZL
		rol	ZH
		rol	tempreg1
		rol	tempreg2
		brcc	rcio_rand_1
		ldi	tempreg3,0x5D
		eor	ZL,tempreg3
		ldi	tempreg3,0xD5
		eor	ZH,tempreg3
		ldi	tempreg3,0x2A
		eor	tempreg1,tempreg3
		ldi	tempreg3,0xD5
		eor	tempreg2,tempreg3

rcio_rand_1:	sts	libmio_rand1,ZL		;2
		sts	libmio_rand2,ZH		;2
		sts	libmio_rand3,tempreg1	;2
		sts	libmio_rand4,tempreg2	;2

		pop	YL			;2
		pop	YH			;2
.endmacro


;-------------------------------------------------------------------------------
; calculate sound (42c)
;-------------------------------------------------------------------------------
.macro rcio_soundgen
rcio_sound:	push	YH
		push	YL

		ldi	YL,LOW(libmio_ram)	;1 set ptr
		ldi	YH,HIGH(libmio_ram)	;1
		ldd	tempreg2,Y+lmo_rand2	;2 noise signal
		ldd	tempreg3,Y+lmo_wpos_l	;2 wave pointer low
		ldd	ZL,Y+lmo_wpos_h		;2 wave pointer high
		ldd	r0,Y+lmo_woff_l		;2 wave offset low
		ldd	r1,Y+lmo_woff_h		;2 wave offset high
		add	tempreg3,r0		;1 calculate new pointer
		adc	ZL,r1			;1
		std	Y+lmo_wpos_l,tempreg3	;2 writeback new pointer
		std	Y+lmo_wpos_h,ZL		;2
		ldd	ZH,Y+lmo_wavtab		;1 start wavetable high
		lpm	tempreg1,Z		;3 get wave value
		ldd	tempreg3,Y+lmo_note_val	;2 note val
		andi	tempreg3,0x3f		;1 mask bits
		cpi	tempreg3,0x3f		;1 noise?
		brne	rcio_sound_1		;1/2
		mov	tempreg1,tempreg2	;1
rcio_sound_1:	ldd	tempreg2,Y+lmo_envv	;2 envelope value
		ldd	tempreg3,Y+lmo_volume	;2 volume setting
		mul	tempreg3,tempreg2	;2
		mov	tempreg2,r1		;1
		mulsu	tempreg1,tempreg2	;2 shaped value
		ldi	tempreg3,0x80		;1 neutral signal
		add	tempreg3,r1		;1 add result
		sts	OCR2A,tempreg3		;1 set level

		pop	YL			;2
		pop	YH			;2
.endmacro

;-------------------------------------------------------------------------------
;serial port (receive 2400)
;
;-------------------------------------------------------------------------------
.macro	rcio_receive_2400
rcio_s24rx:	lds	tempreg1,libmio_sysconf
		sbrs	tempreg1,0
		rjmp	rcio_s24rx_n
		lds	tempreg2,libmio_serio		;2 get signal byte
		lds	ZL,libmio_rcnt			;2 clock counter
		cpi	ZL,0x00				;1 end
		breq	rcio_s24rx_e			;1/2
		cpi	ZL,0xff				;1 wait for sig
		brne	rcio_s24rx_1			;1/2
		sbrc	tempreg2,0			;1 skip if line is 0
		rjmp	rcio_s24rx_e			;1/2
		ldi	ZL,62				;1 start value 2400
		rjmp	rcio_s24rx_e			;2
;+9
rcio_s24rx_1:	dec	ZL				;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)		;1 set start of table
		lpm	tempreg3,Z			;3
		sbrs	tempreg3,5			;1 skip if sample bit
		rjmp	rcio_s24rx_e			;2

		lds	tempreg3,libmio_rdat		;2 serial data
		lsr	tempreg3			;1
		bst	tempreg2,0			;1 RXD data
		bld	tempreg3,7			;1 shift in
		sts	libmio_rdat,tempreg3		;2

rcio_s24rx_e:	sts	libmio_rcnt,ZL			;2
rcio_s24rx_n:
.endmacro

;-------------------------------------------------------------------------------
;serial port (transmit 2400)
;-------------------------------------------------------------------------------
.macro	rcio_transmit_2400
		lds	tempreg1,libmio_sysconf
		sbrs	tempreg1,0
		rjmp	rcio_s24tx_n

rcio_s24tx:	lds	ZL,libmio_tcnt			;2 clock counter
		cpi	ZL,0x00				;1
		breq	rcio_s24tx_n			;1/2 nothing to do
		cpi	ZL,0xff				;1 wait for start
		brne	rcio_s24tx_1			;1/2
		ldi	ZL,80				;1
		andi	tempreg2,0x7f			;1 clear bit
		rjmp	rcio_s24tx_e			;2
;+7 clk
rcio_s24tx_1:	dec	ZL				;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)		;1 set start of table
		lpm	tempreg3,Z			;3
		sbrs	tempreg3,4			;1 skip if setout bit
		rjmp	rcio_s24tx_e			;2

		lds	tempreg3,libmio_tdat		;2
		bst	tempreg3,0			;1
		sec					;1
		ror	tempreg3			;1
		bld	tempreg2,7			;1
		sts	libmio_tdat,tempreg3		;2

rcio_s24tx_e:	sts	libmio_tcnt,ZL			;2
		sts	libmio_serio,tempreg2		;2
rcio_s24tx_n:
.endmacro


;-------------------------------------------------------------------------------
;serial port (receive 1200)
;-------------------------------------------------------------------------------
.macro	rcio_receive_1200
		lds	tempreg1,libmio_sysconf
		sbrc	tempreg1,0
		rjmp	rcio_s12rx_n

rcio_s12rx_:	lds	tempreg2,libmio_serio		;2 get signal byte
		lds	ZL,libmio_rcnt			;2 clock counter
		cpi	ZL,0x00				;1 end
		breq	rcio_s12rx_e			;1/2
		cpi	ZL,0xff				;1 wait for sig
		brne	rcio_s12rx_1			;1/2
		sbrc	tempreg2,0			;1 skip if line is 0
		rjmp	rcio_s12rx_e			;1/2
		ldi	ZL,124				;1 start value 1200
		rjmp	rcio_s12rx_e			;2

;+9
rcio_s12rx_1:	dec	ZL				;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)		;1 set start of table
		lpm	tempreg3,Z			;3
		sbrs	tempreg3,7			;1 skip if sample bit
		rjmp	rcio_s12rx_e			;2

		lds	tempreg3,libmio_rdat		;2 serial data
		lsr	tempreg3			;1
		bst	tempreg2,0			;1 RXD data
		bld	tempreg3,7			;1 shift in
		sts	libmio_rdat,tempreg3		;2

rcio_s12rx_e:	sts	libmio_rcnt,ZL			;2
rcio_s12rx_n:
.endmacro

;-------------------------------------------------------------------------------
;serial port (transmit 1200)
;-------------------------------------------------------------------------------
.macro	rcio_transmit_1200
		lds	tempreg1,libmio_sysconf
		sbrc	tempreg1,0
		rjmp	rcio_s12tx_n

rcio_s12tx_:	lds	ZL,libmio_tcnt			;2 clock counter
		cpi	ZL,0x00				;1
		breq	rcio_s12tx_n			;1/2 nothing to do
		cpi	ZL,0xff				;1 wait for start
		brne	rcio_s12tx_1			;1/2
		ldi	ZL,144				;1 start value 1200
		andi	tempreg2,0x7f			;1 clear bit
		rjmp	rcio_s12tx_e			;2
;+7 clk
rcio_s12tx_1:	dec	ZL				;1 counter -1
		ldi	ZH,HIGH(libmio_kstab*2)		;1 set start of table
		lpm	tempreg3,Z			;3
		sbrs	tempreg3,6			;1 skip if setout bit
		rjmp	rcio_s12tx_e			;2

		lds	tempreg3,libmio_tdat		;2
		bst	tempreg3,0			;1
		sec					;1
		ror	tempreg3			;1
		bld	tempreg2,7			;1
		sts	libmio_tdat,tempreg3		;2

rcio_s12tx_e:	sts	libmio_tcnt,ZL			;2
		sts	libmio_serio,tempreg2		;2
rcio_s12tx_n:
.endmacro



;now start
rcio_main:	sts	TIMSK1,const_0			;disable timer 1 interrupts
		lds	XL,libmio_vram+2000
		lds	XH,libmio_vram+2001
		lds	YL,libmio_vram+2002
		lds	YH,libmio_vram+2003
		out	PORTC,const_0			;black

rcio_wfirst:	lds	tempreg1,TCNT1L			;read low register, dummy
		lds	tempreg1,TCNT1H			;read high register
		cpi	tempreg1,0
		breq	rcio_wfirst

		ldi	tempreg3,35			;number of lines

rcio_lloop:	push	tempreg3			;the line loop
		rcall	rcio_wstart			;do one line
		pop	tempreg3
		dec	tempreg3			;line loop counter
		brne	rcio_lloop			;do line loop

rcio_lend:	lds	tempreg1,TCNT1L			;read low register, dummy
		lds	tempreg1,TCNT1H			;read high register
		cpi	tempreg1,1
		brne	rcio_lend
		cbi	PORTA,4				;clear channel 1
		cbi	PORTA,5				;clear channel 2

		ldi	XL,0x06				;1 enable timer 1 interrupts
		sts	TIMSK1,XL
		set					;enable sync
		ret


;wait for TCNT1H is = 0
rcio_wstart:	lds	tempreg2,TCNT1L			;read low register, dummy
		lds	tempreg1,TCNT1H			;read high register
		cpi	tempreg1,0
		brne	rcio_wstart
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		inc	vline_l

;wait for TCNT1 is = 80

rcio_wcount_01:	lds	tempreg1,TCNT1L			;2 read low register
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,80			;1
		brne	rcio_wcount_01			;2

		rcio_pulse				;16 output pulse

;wait for TCNT1 is = 160

rcio_wcount_02:	lds	tempreg1,TCNT1L			;2 read low register
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,160			;1
		brne	rcio_wcount_02			;2

		rcio_pulse				;16 output pulse

;-------------------------------------------------------------------------------
;serial port io (21 clocks)
;-------------------------------------------------------------------------------
		lds	tempreg1,libmio_serio		;2 serial io
		sbrs	tempreg1,7			;1 skip if 1-bit
		cbi	PORTD,4				;2 clear pin
		sbrc	tempreg1,7			;1 skip if 0-bit
		sbi	PORTD,4				;2 set pin
		lds	ZL,libmio_sysconf		;2 get conf (bit 5=force M644)
		lds	tempreg2,libmio_sysconf1	;2 get conf2 (bit 7=invert)
		in	ZH,PIND				;1 input data
		bst	ZH,3				;1 default for M644
		sbrs	ZL,5				;1 skip if force M644
		bst	ZH,1				;1 default for M644P
		bld	tempreg1,0			;1 store to register
		sbrs	tempreg2,7			;1 skip if no max
		eor	tempreg1,const_1		;1 invert signal
		sts	libmio_serio,tempreg1		;2 store for input


;wait for TCNT1 is = 240

rcio_wcount_03:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,240			;1
		brne	rcio_wcount_03			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_pwmout


;wait for TCNT1 is = 320

rcio_wcount_04:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(320)		;1
		brne	rcio_wcount_04			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse


;wait for TCNT1 is = 400

rcio_wcount_05:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(400)		;1
		brne	rcio_wcount_05			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_soundgen

;wait for TCNT1 is = 480

rcio_wcount_06:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(480)		;1
		brne	rcio_wcount_06			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_random

;wait for TCNT1 is = 560

rcio_wcount_07:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(560)		;1
		brne	rcio_wcount_07			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_transmit_2400


;wait for TCNT1 is = 640

rcio_wcount_08:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(640)		;1
		brne	rcio_wcount_08			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_receive_2400

;wait for TCNT1 is = 720

rcio_wcount_09:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(720)		;1
		brne	rcio_wcount_09			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_transmit_1200


;wait for TCNT1 is = 800

rcio_wcount_10:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(800)		;1
		brne	rcio_wcount_10			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_receive_1200


;wait for TCNT1 is = 880

rcio_wcount_11:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(880)		;1
		brne	rcio_wcount_11			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_pwm6


;wait for TCNT1 is = 960

rcio_wcount_12:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(960)		;1
		brne	rcio_wcount_12			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		rcio_pwm7


;wait for TCNT1 is = 1040

rcio_wcount_13:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(1040)		;1
		brne	rcio_wcount_13			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse


;wait for TCNT1 is = 1120

rcio_wcount_14:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(1120)		;1
		brne	rcio_wcount_14			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse


;wait for TCNT1 is = 1200

rcio_wcount_15:	lds	tempreg1,TCNT1L			;2 read low register
		mov	tempreg2,tempreg1
		andi	tempreg1,0xf8			;1
		cpi	tempreg1,LOW(1200)		;1
		brne	rcio_wcount_15			;2
		sbrs	tempreg2,2
		lpm	r0,Z

		rcio_pulse				;16 output pulse

		ret





