;################################################################################
;#										#
;# mode 7 engine Y*X text (generic text out)					#
;# copyright (c) 2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; clear screen
;-------------------------------------------------------------------------------
vidmode_clear:	lds	ZL,libmio_color
		ldi	tempreg1,0x20
		sbrc	ZL,1
		ldi	tempreg1,0xa0
		ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	XH,vidmode_rows
		ldi	tempreg1,0x20
vidmode_clear1:ldi	XL,vidmode_cols
vidmode_clear2:	st	Y+,tempreg1		;chars
		dec	XL
		brne	vidmode_clear2
		dec	XH
		brne	vidmode_clear1
		mov	libmio_cur_x,const_0
		mov	libmio_cur_y,const_0
		ret


;-------------------------------------------------------------------------------
; output a single char
;-------------------------------------------------------------------------------
vidmode_newl:	api_pushxyz
		movw	XL,libmio_cur_x
		rjmp	libmio_chr_nl
vidmode_char:	api_pushxyz
		movw	XL,libmio_cur_x
		cpi	XL,vidmode_cols
		brcc	vidmode_chr_os		;out of screen
		cpi	XH,vidmode_rows
		brcc	vidmode_chr_os		;out of screen
		lds	ZH,libmio_color
wdata_1:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,vidmode_cols
		mul	ZL,XH
		add	YL,r0
		adc	YH,r1
		add	YL,XL
		adc	YH,const_0		;Y is now char pos
		mov	ZL,tempreg1
		sbrs	ZH,1
		subi	ZL,0x80
wdata_2:	st	Y,ZL			;store char

;move cursor
libmio_chr_m:	movw	XL,libmio_cur_x
		inc	XL
		cpi	XL,vidmode_cols
		brcs	vidmode_chr_m1
libmio_chr_nl:	clr	XL
		inc	XH
		cpi	XH,vidmode_rows
		brcs	vidmode_chr_m1
		lds	ZL,libmio_config	;scrollmode
		sbrs	ZL,7
		rjmp	vidmode_scroll
		clr	XH			;WRAP
vidmode_chr_m1:	movw	libmio_cur_x,XL
vidmode_chr_os:	api_popxyz

;-------------------------------------------------------------------------------
; scroll up
;-------------------------------------------------------------------------------
vidmode_scroll:	ldi	YL,LOW(libmio_vram)
		ldi	YH,HIGH(libmio_vram)
		ldi	ZL,LOW(libmio_vram+vidmode_cols)
		ldi	ZH,HIGH(libmio_vram+vidmode_cols)
		ldi	XH,vidmode_rows-1
scroll0:	ldi	XL,vidmode_cols
scroll1:	ld	r0,Z+
		st	Y+,r0
		dec	XL
		brne	scroll1
		dec	XH
		brne	scroll0
		ldi	XH,0x20			;space
		ldi	XL,vidmode_cols
scroll3:	st	Y+,XH
		dec	XL
		brne	scroll3

		ldi	XL,0
		ldi	XH,vidmode_rows-1
		rjmp	vidmode_chr_m1
