;################################################################################
;#										#
;# mode 7 engine 40x24 text							#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.equ		vidmode_cols = 60
.equ		vidmode_rows = 24

.macro vchar
		ld	ZL,X+				;2
		lpm	tempreg1,Z			;3 get pixline
		out	PORTC,tempreg1			;1 output pix 7

		lsl	tempreg1			;1 prepare pix 6
		out	PORTC,tempreg1			;1 output pix 6

		lsl	tempreg1			;1 prepare pix 5
		out	PORTC,tempreg1			;1 output pix 5

		lsl	tempreg1			;1 prepare pix 4
		out	PORTC,tempreg1			;1 output pix 4

		lsl	tempreg1			;1 prepare pix 3
		out	PORTC,tempreg1			;1 output pix 3

		lsl	tempreg1			;1 prepare pix 2
		out	PORTC,tempreg1			;1 output pix 2
.endm


.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.equ		libmio_ctable	= 0x7b00

.equ		vidmode_cline	= libmio_vram+1450
.equ		vidmode_pline	= libmio_vram+1452
.equ		vidmode_rampos_l	= libmio_vram+1453
.equ		vidmode_rampos_h	= libmio_vram+1454

.CSEG

.org	0x7200
;                   "......      N"
start:		.db "M24*60      N",0xf3,0xfe,0x82

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,"VM",0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;input ext
		rjmp	outex			;output ext
		ret				;FKT 00
		rjmp	vidmode_init		;FKT 01 init
		rjmp	vidmode_clear		;FKT 02 clear screen
		rjmp	vidmode_char		;FKT 03 output char
		rjmp	vidmode_gxy		;FKT 04 set cursor
		rjmp	vidmode_plot		;FKT 05 plot
		rjmp	vidmode_newl		;FKT 06 NL
		rjmp	vidmode_vid		;FKT 07 video display

;-------------------------------------------------------------------------------
; set cursor
;-------------------------------------------------------------------------------
vidmode_gxy:	movw	libmio_cur_x,XL
		ret

;-------------------------------------------------------------------------------
; input expansion
;-------------------------------------------------------------------------------
inex:		ldi	ereg,40			;no IO driver
		ret

;-------------------------------------------------------------------------------
; output expansion
;-------------------------------------------------------------------------------
outex:		ldi	ereg,40			;no IO driver
		ret

;-------------------------------------------------------------------------------
; init mode
;-------------------------------------------------------------------------------
vidmode_init:	brtc	vidmode_exit		;exit
		ldi	XL,0
		out	PORTC,XL
		ldi	XL,0x80			;enable only green
		out	DDRC,XL
		rcall	vidmode_clear
		ldi	XL,vidmode_cols*2
		sts	libmio_clipx2,XL
		ldi	XL,vidmode_rows*2
		sts	libmio_clipy2,XL
		ldi	XL,0			;extended mode
		ret

vidmode_exit:	push	XL
		ldi	XL,0			;enable all video outputs
		out	PORTC,XL
		ldi	XL,0xf0
		out	DDRC,XL
		pop	XL
		ret


;-------------------------------------------------------------------------------
; video output (24 lines a 60 chars)
;-------------------------------------------------------------------------------
vidmode_novid:	set
		ret

vidmode_vid:	sbrc	vline_h,0
		rjmp	vidmode_novid
		mov	XL,vline_l
		cpi	XL,241
		brcc	vidmode_novid

;-------------------------------------------------------------------------------
;sync to counter
;-------------------------------------------------------------------------------
vid_iss:	lds	XL,TCNT1L		;1 get timer
		cpi	XL,libmio_hstart+83 	;1
		brcs	vid_iss			;1 loop
vid_iss_01:	cpi	XL,libmio_hstart+84
		brcs	vid_iss_02
vid_iss_02:	cpi	XL,libmio_hstart+85
		brcs	vid_iss_03
vid_iss_03:	cpi	XL,libmio_hstart+86
		brcs	vid_iss_03a
vid_iss_03a:	cpi	XL,libmio_hstart+87
		brcs	vid_iss_04
vid_iss_04:

		lds	XL,libmio_rampos_l
		lds	XH,libmio_rampos_h
		lds	ZH,prg_font		;start of table
		lsl	ZH
		subi	ZH,0xfe			;+2
		lds	ZL,libmio_cline
		add	ZH,ZL
;char 0..9
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
;char 10..19
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
;char 20..29
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
;char 30..39
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
;char 40..49
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar

;char 50..59
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar
		vchar

		lds	tempreg1,libmio_border
		lds	ZL,libmio_cline
		inc	ZL
		out	PORTC,tempreg1
		cpi	ZL,10
		brne	vidmode_vid1
		clr	ZL
		sts	libmio_rampos_l,XL
		sts	libmio_rampos_h,XH
vidmode_vid1:	sts	libmio_cline,ZL
		clt
		ret


.include	"textout2.asm"

