;################################################################################
;#										#
;# mode 7 engine 40x24 text							#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.equ		vidmode_cols = 50
.equ		vidmode_rows = 24

.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.equ		libmio_ctable	= 0x7b00

.equ		vidmode_cline	= libmio_vram+1301
.equ		vidmode_pline	= libmio_vram+1302
.equ		vidmode_rampos_l	= libmio_vram+1303
.equ		vidmode_rampos_h	= libmio_vram+1304

.CSEG

.org	0x7200
;                   "......      N"
start:		.db "M24*50      N",0xf3,0xfe,0x81

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,"VT",0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;input ext
		rjmp	outex			;output ext
		rjmp	vidmode_start		;FKT 00
		rjmp	vidmode_init		;FKT 01 init
		rjmp	vidmode_clear		;FKT 02 clear screen
		rjmp	vidmode_char		;FKT 03 output char
		rjmp	vidmode_gxy		;FKT 04 set cursor
		rjmp	vidmode_plot		;FKT 05 plot
		rjmp	vidmode_newl		;FKT 06 NL
		rjmp	vidmode_vid		;FKT 07 video display

;-------------------------------------------------------------------------------
; input expansion
;-------------------------------------------------------------------------------
inex:		ldi	ereg,40			;no IO driver
		ret

;-------------------------------------------------------------------------------
; output expansion
;-------------------------------------------------------------------------------
outex:		ldi	ereg,40			;no IO driver
		ret


.include 	"vout_m24x50.asm"
.include	"funct_m24x50.asm"
