;################################################################################
;#										#
;# mode 7 engine								#
;# copyright (c) 2005-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.equ		libmio_palette	= 0x0100		;palette
.equ		libmio_ctable	= 0x7b00		;font 0
.equ		libmio_ctable1	= 0x4340		;font 1
.equ		vidp		= 7			;video pin
.equ		lcd_cs1		= 4			;latched CS1
.equ		lcd_cs2		= 5			;latched CS2
.equ		lcd_di		= 6			;latched D/I
.equ		lcd_ks		= 7			;latched key select

.equ		lcd_page	= libmio_vram+1200	;lcdpage
.equ		lcd_row		= libmio_vram+1201	;lcdrow
.equ		lcd_keymode	= libmio_vram+1202	;key mode (0=PS2, 1=fixkeys)

.CSEG
.org	0x7200
;                   "......      N"  
start:		.db " GLCD 128x64N",0xb3,0xfe,0xa8

;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,"VM",0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x720e
		rjmp	inex			;video, no IO
		rjmp	outex			;IO ext
		ret				;FKT 00
		rjmp	bimode_init		;FKT 01 init
		rjmp	bimode_cls		;FKT 02 clear screen
		rjmp	bimode_char		;FKT 03 output char
		rjmp	bimode_gxy		;FKT 04 set cursor
		rjmp	bimode_plot		;FKT 05 plot
		rjmp	bimode_scrs		;FKT 06 screenshot
		rjmp	bimode_vid		;FKT 07 video display
		ret				;FKT 08 init

inex:		ldi	ereg,40			;no IO driver
		ret

outex:		ldi	ereg,40			;no IO driver
		ret

;-------------------------------------------------------------------------------
; init mode
;-------------------------------------------------------------------------------
bimode_init:	brtc	bimode_exit		;exit
		ldi	XL,0xff
		out	DDRA,XL
		sbi	DDRB,1
		sbi	DDRB,2
		ldi	XL,0xf0
		out	DDRC,XL
		ldi	XL,128
		sts	libmio_clipx2,XL
		ldi	XL,64
		sts	libmio_clipy2,XL
		ldi	XL,0x20			;blue
		sts	libmio_palette,XL	;palette 0
		ldi	XL,0xe0			;white
		sts	libmio_palette+2,XL	;palette 1
		sts	lcd_page,const_0	;lcdpage 0
		sts	lcd_row,const_0		;lcdrow 0
		rcall	bimode_cls
		ldi	XL,180			;visible lines (only 128 are used)
		cli
		ldi	tempreg3,0x80		;1 cs1/cs2/instruction mode
		out	PORTA,tempreg3		;1 output
		sbi	PORTB,2			;2 latch signals
		cbi	PORTB,2			;2
		ldi	XH,0x3f			;1 Display ON
		out	PORTA,XH		;1 LCD data
		ldi	XH,0x20
bimode_w1:	dec	XH
		brne	bimode_w1
		sbi	PORTB,1			;2 raise clock
		ldi	XH,0x20
bimode_w2:	dec	XH
		brne	bimode_w2
		cbi	PORTB,1			;2 lower clock
		ldi	XH,0x00
bimode_w3:	dec	XH
		brne	bimode_w3
		ldi	XH,0xf8			;1 Y address=0
		out	PORTA,XH		;1 LCD data
		ldi	XH,0x20
bimode_w4:	dec	XH
		brne	bimode_w4
		sbi	PORTB,1			;2 raise clock
		ldi	XH,0x20
bimode_w5:	dec	XH
		brne	bimode_w5
		cbi	PORTB,1			;2 lower clock
		ldi	XH,0x00
bimode_w6:	dec	XH
		brne	bimode_w6
		sts	lcd_keymode,const_0
		sei
		ret

bimode_exit:	push	XL
		out	DDRA,const_0		;input
		cbi	DDRB,2			;busy
		ldi	XL,0xf0
		out	DDRC,XL
		pop	XL
		ret


;-------------------------------------------------------------------------------
; set cursor to position XL:XH
;-------------------------------------------------------------------------------
bimode_gxy:	movw	libmio_cur_x,XL		;save X,Y-position
		ret

;-------------------------------------------------------------------------------
; set cursor to position XL:XH
;-------------------------------------------------------------------------------
bimode_cls:	api_pushxyz
		ldi	XL,LOW(libmio_vram)
		ldi	XH,HIGH(libmio_vram)
		ldi	YL,0
bimode_cls_1:	st	X+,const_0
		st	X+,const_0
		st	X+,const_0
		st	X+,const_0
		dec	YL
		brne	bimode_cls_1
		api_popxyz


;-------------------------------------------------------------------------------
; set cursor to position XL:XH
;-------------------------------------------------------------------------------
bimode_scrs:	ret

;-------------------------------------------------------------------------------
; output char
;-------------------------------------------------------------------------------
bimode_char:	api_pushxyz
		push	tempreg3
		push	tempreg4
		mov	ZL,tempreg1		;char
		lds	tempreg3,libmio_font	;get font
		sbrc	tempreg3,0		;skip if font 0
		rjmp	bimode_gchar5		;jump to fnt1 routine

		ldi	ZH,HIGH(libmio_ctable*2)	;start char ROM
		movw	XL,libmio_cur_x		;get X-position
		ldi	YH,10			;number of lines

bimode_gchar1:	lpm	YL,Z			;get pixline
		rcall	bimode_plpl
		inc	XH
		mov	XL,libmio_cur_x		;get X-position
		sbrc	ctrl,6			;bigchars
		rcall	bimode_plpl
		sbrc	ctrl,6			;bigchars
		inc	XH
		inc	ZH			;next pixline
		mov	XL,libmio_cur_x		;get X-position
		dec	YH
		brne	bimode_gchar1
		mov	XL,libmio_cur_x		;get X-position
		subi	XL,0xfa			;+6
		sbrc	ctrl,6
		subi	XL,0xfa			;+6
		mov	libmio_cur_x,XL	
bimode_gchar4:	pop	tempreg4
		pop	tempreg3
		api_popxyz

bimode_gchar5:	ldi	ZH,HIGH(libmio_ctable1*2)	;start char ROM
		andi	ZL,0x7f
		mov	XL,ZL
		ldi	ZL,LOW(libmio_ctable1*2)	;start char ROM
		add	ZL,XL
		adc	ZH,const_0
		lsl	XL
		add	ZL,XL
		adc	ZH,const_0

		movw	XL,libmio_cur_x		;get X-position
		ldi	YH,6			;number of lines
		
bimode_gchar6:	lpm	YL,Z			;get pixline
		rcall	bimode_plpl5		
		inc	XH
		mov	XL,libmio_cur_x		;get X-position
		sbrc	ctrl,6			;bigchars
		rcall	bimode_plpl5
		sbrc	ctrl,6			;bigchars
		inc	XH
		sbrc	YH,0			;skip if first nibble is used
		adiw	ZL,1
		mov	XL,libmio_cur_x		;get X-position
		dec	YH
		brne	bimode_gchar6		
		mov	XL,libmio_cur_x		;get X-position
		subi	XL,0xfc			;+4
		sbrc	ctrl,6
		subi	XL,0xfc			;+4
		mov	libmio_cur_x,XL	
		rjmp	bimode_gchar4

;-------------------------------------------------------------------------------
; plot pixline in graphics mode with font 0, YL=pixline
;-------------------------------------------------------------------------------
bimode_plpl:	lds	tempreg3,libmio_color
		push	tempreg3
		swap	tempreg3
		sbrc	YL,7			;pix 1
		swap	tempreg3
		sts	libmio_color,tempreg3
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,6			;pix 2
		swap	tempreg3
		sts	libmio_color,tempreg3
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,5			;pix 3
		swap	tempreg3
		sts	libmio_color,tempreg3
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,4			;pix 4
		swap	tempreg3
		sts	libmio_color,tempreg3
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,3			;pix 5
		swap	tempreg3
		sts	libmio_color,tempreg3
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		sbrc	YL,2			;pix 6
		swap	tempreg3
		sts	libmio_color,tempreg3
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

bimode_plpl1:	pop	tempreg3		;restore color
		sts	libmio_color,tempreg3
		ret

;-------------------------------------------------------------------------------
; plot pixline in graphics mode with font 1, YL=pixline
;-------------------------------------------------------------------------------
bimode_plpl5:	lds	tempreg3,libmio_color
		sbrc	YH,0
		swap	YL
		mov	tempreg4,tempreg3
		sbrs	YL,7			;pix 1
		swap	tempreg4		
		sts	libmio_color,tempreg4
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos
		
		mov	tempreg4,tempreg3
		sbrs	YL,6			;pix 2
		swap	tempreg4		
		sts	libmio_color,tempreg4
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		mov	tempreg4,tempreg3
		sbrs	YL,5			;pix 3
		swap	tempreg4		
		sts	libmio_color,tempreg4
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

		mov	tempreg4,tempreg3
		sbrs	YL,4			;pix 4
		swap	tempreg4		
		sts	libmio_color,tempreg4
		rcall	bimode_plot		;output pix
		inc	XL			;next pos
		sbrc	ctrl,6			;no bigchar
		rcall	bimode_plot		;output pix again
		sbrc	ctrl,6			;no bigchar
		inc	XL			;next pos

bimode_plpl6:	sts	libmio_color,tempreg3
		ret


;-------------------------------------------------------------------------------
; plot  XL=X XH=Y
;-------------------------------------------------------------------------------
bimode_plot:	api_pushregs
		ldi	YH,HIGH(libmio_vram)	;home position
		ldi	YL,LOW(libmio_vram)	;home position
		cpi	XL,128
		brcc	bimode_nplot		;yes
		cpi	XH,64
		brcc	bimode_nplot		;yes
		rjmp	bimode_plot1_0		;OK, we can plot
bimode_nplot:	api_popregs			;restore registers


bimode_plot1_0:	mov	tempreg3,XL		;X
		andi	tempreg3,0x07		;only bits
		inc	tempreg3		;+1
		ldi	tempreg1,0x00		;bitmask
		sec				;set carry
bimode_plot1_1:	rol	tempreg1		;shift in bit
		dec	tempreg3
		brne	bimode_plot1_1
;bit mask is in tempreg1
		lsr	XL			;X/8
		lsr	XL
		lsr	XL
		mov	ZL,XL
		ldi	tempreg3,16
		mul	XH,tempreg3
		add	YL,XL
		adc	YH,const_0
		add	YL,r0
		adc	YH,r1
;address is now in Y
		lds	XL,libmio_color		;active color
		lsr	XL
		andi	XL,0x01			;we check only bit 0
		brne	bimode_plot1_2		;set

bimode_plot1_8:	com	tempreg1
		ld	XL,Y
		and	XL,tempreg1
		st	Y,XL
		rjmp	bimode_nplot

bimode_plot1_2:	ld	XL,Y
		or	XL,tempreg1
		st	Y,XL
		rjmp	bimode_nplot

;------------------------------------------------------------------------------
; dual mode (BAS/LCD) out
;------------------------------------------------------------------------------
bimode_vid:	ldi	YL,LOW(libmio_vram)	;2 base for LCD
		ldi	YH,HIGH(libmio_vram)	;2 base for LCD
		lds	XL,lcd_page	;2 page number
		ldi	XH,128			;1 bytes per page
		mul	XH,XL			;2
		add	YL,r0			;1 add page offset
		adc	YH,r1			;1
		lds	XL,lcd_row	;2
		ldi	ZH,0x80			;1 factor for row 0
		sbrc	XL,2			;1 row bit 2
		swap	ZH			;1 shift factor 4 bits right
		sbrc	XL,1			;1 row bit 1
		lsr	ZH			;1 shift factor 1 bit right
		sbrc	XL,1			;1 row bit 1
		lsr	ZH			;1 shift factor 1 bit right
		sbrc	XL,0			;1 row bit 0
		lsr	ZH			;1 shift factor 1 bit right
		lsr	XL			;1 /8
		lsr	XL			;1
		lsr	XL			;1
		andi	XL,0x07			;1 mask bits
		add	YL,XL			;1 add row offset
		adc	YH,const_0		;1
		mov	XL,vline_l
		cpi	XL,51
		brcs	bimode_vid_1
		cpi	XL,179
		brne	bimode_vid_2
		rjmp	bimode_vid_k		;do key service
bimode_vid_1:	ret

bimode_vid_2:	push	tempreg7
		push	tempreg8
		lds	XL,libmio_rampos_l
		lds	XH,libmio_rampos_h
		ldi	tempreg1,0x20

		ld	tempreg2,X+		;1 get pixline
		ldi	tempreg3,16		;1 8 bytes to do
		mov	tempreg7,const_0	;1 clear lcdbyte1
		mov	tempreg8,const_0	;1 clear lcdbyte2

bimode_vid_3:	bst	tempreg2,0		;1 get px 7
		bld	tempreg1,vidp		;1 copy to outmask
		out	PORTC,tempreg1		;1 output pix

		nop				;1
		ld	ZL,Y			;2 get LCD byte 1
		bst	tempreg2,1		;1 get px 6
		bld	tempreg1,vidp		;1 copy to outmask
		out	PORTC,tempreg1		;1 output pix

		adiw	YL,8			;2 set pointer to other page
		nop				;1 filling
		bst	tempreg2,2		;1 get px 5
		bld	tempreg1,vidp		;1 copy to outmask
		out	PORTC,tempreg1		;1 output pix

		mul	ZL,ZH			;2 get shifted bit to R0.7
		lsl	r0			;1 shift out bit
		bst	tempreg2,3		;1 get px 4
		bld	tempreg1,vidp		;1 copy to outmask
		out	PORTC,tempreg1		;1 output pix

		sbrs	tempreg3,0		;1 skip if right side
		ror	tempreg7		;1 shift bit to lcdbyte 1
		nop				;1 filling
		bst	tempreg2,4		;1 get px 3
		bld	tempreg1,vidp		;1 copy to outmask
		out	PORTC,tempreg1		;1 output pix

		sbrc	tempreg3,0		;1 skip if left side
		ror	tempreg8		;1 shift bit to lcdbyte 2
		nop				;1 filling
		bst	tempreg2,5		;1 get px 2
		bld	tempreg1,vidp		;1 copy to outmask
		out	PORTC,tempreg1		;1 output pix

		nop				;1 filling
		nop				;1 filling
		nop				;1 filling
		bst	tempreg2,6		;1 get px 1
		bld	tempreg1,vidp		;1 copy to outmask
		out	PORTC,tempreg1		;1 output pix

		nop				;1 filling
		bst	tempreg2,7		;1 get px 0
		ld	tempreg2,X+		;2 get next pitempreg2ine
		bld	tempreg1,vidp		;1 copy to outmask
		out	PORTC,tempreg1		;1 output pix

		dec	tempreg3		;1
		brne	bimode_vid_3		;2

		lds	tempreg1,libmio_border	;1 output pix
		out	PORTC,tempreg1		;1
		sbiw	XL,1			;2 correct pointer
		lds	YL,libmio_cline
		inc	YL
		cpi	YL,2
		brcs	bimode_vid_4
		clr	YL			;1 set cline to 0
		sts	libmio_rampos_l,XL	;2 store video position
		sts	libmio_rampos_h,XH
bimode_vid_4:	sts	libmio_cline,YL

bimode_vid_20:	;rjmp	bimode_vid_e		;debug only!
		lds	XL,lcd_row	;2 get row
		cpi	XL,64			;1 check if <64
		brcs	bimode_vid_23		;1 no
		rjmp	bimode_vid_40		;1 no
bimode_vid_23:	ldi	tempreg3,0xe0		;1 cs1/data mode
		out	PORTA,tempreg3		;1 output
		sbi	PORTB,2			;2 latch signals
		cbi	PORTB,2			;2
		out	PORTA,tempreg7		;1 LCD data
		sbi	PORTB,1			;2 raise clock
		cbi	PORTB,1			;2 lower clock

		nop				;1 adr/data hold
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1
		nop				;1

		ldi	tempreg3,0xd0		;1 cs2/data mode
		out	PORTA,tempreg3		;1 output
		sbi	PORTB,2			;2 latch signals
		cbi	PORTB,2			;2
		out	PORTA,tempreg8		;1 LCD data
		sbi	PORTB,1			;2 raise clock
		cbi	PORTB,1			;2 lower clock
		inc	XL			;1 row+1
		sts	lcd_row,XL	;2 store
		rjmp	bimode_vid_e		;2 end

bimode_vid_40:	brne	bimode_vid_50		;not 64
		ldi	tempreg3,0x80		;1 cs1/cs2/instruction mode
		out	PORTA,tempreg3		;1 output
		sbi	PORTB,2			;2 latch signals
		cbi	PORTB,2			;2
		ldi	XH,0x40			;1 Y address=0
		out	PORTA,XH		;1 LCD data
		sbi	PORTB,1			;2 raise clock
		cbi	PORTB,1			;2 lower clock

		inc	XL			;1 row+1
		sts	lcd_row,XL	;2 store
		rjmp	bimode_vid_e		;2 end

bimode_vid_50:	ldi	tempreg3,0x80		;1 cs1/cs2/instruction mode
		out	PORTA,tempreg3		;1 output
		lds	XH,lcd_page	;2 get page
		andi	XH,0x07			;1
		ori	XH,0xb8			;1
		sbi	PORTB,2			;2 latch signals
		cbi	PORTB,2			;2
		out	PORTA,XH		;1 LCD data
		sbi	PORTB,1			;2 raise clock
		cbi	PORTB,1			;2 lower clock
		inc	XH			;1 page +1
		andi	XH,0x07			;1 mask bits
		sts	lcd_page,XH	;2 store back page
		sts	lcd_row,const_0	;2 set address to zero


bimode_vid_e:	pop	tempreg8
		pop	tempreg7
		ret				;end of vout routine -> VS/Frame handling

;key service

bimode_vid_k:	ldi	XH,0x7f			;k active
		out	PORTA,XH		;set ctrl
		sbi	PORTB,2			;2 latch signals
		cbi	PORTB,2			;2
		out	DDRA,const_0		;set as input
		nop
		nop
		nop
		nop
		in	XL,PINA
		sbi	PORTA,7			;disable key sig
		sbi	DDRA,7
		sbi	PORTB,2			;2 latch signals
		cbi	PORTB,2			;2
		ldi	XH,0xff
		out	DDRA,XH
		ldi	XH,0xf0			;disable key select signal
		out	PORTA,XH
		sbi	PORTB,2			;2 latch signals
		cbi	PORTB,2			;2
;hier Auswertung XL -> keyboard daten
		lds	XH,lcd_keymode
		com	XL			;1 invert because of low active
		andi	XL,0x7f
		sbrs	XH,0			;skip if keys are active
		breq	bimode_vid_k1		;no key
		sts	lcd_keymode,const_1	;set keys to active state
		ldi	tempreg1,0		;1 no key
		sbrc	XL,0			;left
		ldi	tempreg1,0xe2
		sbrc	XL,1			;right
		ldi	tempreg1,0xe3
		sbrc	XL,2			;up
		ldi	tempreg1,0xe4
		sbrc	XL,3			;down
		ldi	tempreg1,0xe5
		sbrc	XL,4			;enter
		ldi	tempreg1,0xea
		sbrc	XL,5			;esc
		ldi	tempreg1,0xed
		sbrc	XL,6			;F5
		ldi	tempreg1,0xf5
		sts	libmio_keycode,tempreg1	;simulated key
		ldi	tempreg1,0
		bst	XL,4			;enter
		bld	tempreg1,2		;left ctrl
		bst	XL,5			;esc
		bld	tempreg1,0		;left shift
		bst	XL,2			;up
		bld	tempreg1,3		;right ctrl
		bst	XL,3			;down
		bld	tempreg1,1		;right shift
		sts	libmio_kbdstate,tempreg1
		cpi	tempreg1,0x0f
		brne	bimode_vid_k0
		jmp	0x0000			;restart system
bimode_vid_k0:	sts	libmio_scancode,XL	;all keys in one byte
bimode_vid_k1:	ret				;end of vout routine -> VS/Frame handling

