;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# german keyboard layout 							#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.equ		libmio_ktables 	= 0x4400	;keyboard table

.CSEG
.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.org	0x6c00
;                   "......      N"  
start:		.db "SETKBD -DE- N",0xec,0xff,0xff
;icon def
		.db 0xf2,0xf1,0xf1,0xf3
		.db "ABCD"
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x6c10

;------------------------------------------------------------------------------
;start here
;------------------------------------------------------------------------------
set_kbd:	ldi	ZL,LOW(libmio_ktables*2+256)
		ldi	ZH,HIGH(libmio_ktables*2+256)
		lpm	tempreg1,Z
		cpi	tempreg1,'D'
		brne	set_kbd_1
		subi	ZL,0x80
		lpm	tempreg1,Z
		cpi	tempreg1,'E'
		brne	set_kbd_1
		ret				;is already set

set_kbd_1:

;copy part 1 of table to RAM
		ldi	XL,LOW(kbdtable-start)
		ldi	XH,HIGH(kbdtable-start)
		api_dataptr
		api_getarray
		subi	YH,0xfe			;we start with array cell 512
		ldi	XL,0			;bytes to do
set_kbd_2:	lpm	XH,Z+
		st	Y+,XH
		dec	XL
		brne	set_kbd_2

		ldi	ZL,LOW(libmio_ktables*2)
		ldi	ZH,HIGH(libmio_ktables*2)
		api_wpage

		ldi	XL,LOW(kbdtable-start+128)
		ldi	XH,HIGH(kbdtable-start+128)
		api_dataptr
		api_getarray
		subi	YH,0xfe			;+2
		ldi	XL,0
set_kbd_4:	lpm	XH,Z+
		st	Y+,XH
		dec	XL
		brne	set_kbd_4
		movw	tempreg5,ZL
		ldi	ZL,LOW(libmio_ktables*2+256)
		ldi	ZH,HIGH(libmio_ktables*2+256)
		api_wpage
		sei
		ret

kbdtable:
.include	"keytable_de.inc"
