;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# clone 		 							#
;# copyright (c) 2006-2009 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.CSEG
.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.org	0x6c00
;                   "......      N"  
start:		.db "CLONE- M644 N",0xec,0xff,0x00
;icon def
		.db 0x20,0x20,0x20,0x20
		.db 0xaf,0x7f,0xaf,0xaf
		.db 0x20,0x20,0x20,0x20

;dummy data
		.db 0x00,0x00,0x00,0x00

.org	0x6c10

;------------------------------------------------------------------------------
;main screen mask
;------------------------------------------------------------------------------
clone_main:	ldi	XL,1
		sts	libmio_channel,const_0	;output to screen
		sts	libmio_vidmode,const_0	;standard video mode
		ldi	XL,0x07			;color scheme (white on black)
		api_setcolor
		ldi	YL,0			;maximal sized box
		ldi	YH,0
		ldi	ZL,29
		ldi	ZH,22
		api_whbox
		ldi	XL,0x70			;color scheme (white on black)
		api_setcolor
clone_main_1:	api_thistext
		.db 1,5,"Clone configuration",0

;------------------------------------------------------------------------------
;the main loop
;------------------------------------------------------------------------------
		lds	r18,libmio_sysconf		;recent conf
		lds	r19,libmio_sysconf1	;recent conf

		ldi	XL,LOW(clone_mbar-start)
		ldi	XH,HIGH(clone_mbar-start)
		api_dataptr
		clt				;read menu from flash
		api_drawmenu
		clr	r16			;select first position


clone_loop:	rcall	clone_sconf		;view status
		api_nokey

clone_loop_1:	api_waitkey
		cpi	tempreg1,0xed		;ESC
		brne	clone_loop_2
clone_loop_1a:	api_askthis
		.db	0x4f,"Exit Program ?",0
		cpi	tempreg1,0		;no
		breq	clone_loop_1
		ret				;exit program

clone_loop_2:	cpi	tempreg1,0xf4		;CLONE
		brne	clone_loop_3
		rjmp	clone_cdo

clone_loop_3:	cpi	tempreg1,0xe4		;up
		brne	clone_loop_4
		cpi	r16,1
		brcs	clone_loop_1
		dec	r16
		rjmp	clone_loop

clone_loop_4:	cpi	tempreg1,0xe5		;down
		brne	clone_loop_5
		cpi	r16,6
		brcc	clone_loop_1
		inc	r16
		rjmp	clone_loop

clone_loop_5:	cpi	tempreg1,0xf1		;F1=change
		brne	clone_loop_1

;------------------------------------------------------------------------------
;change serial speed
;------------------------------------------------------------------------------
clone_main_55:	cpi	r16,0
		brne	clone_main_60
		mov	tempreg4,r18
		inc	tempreg4		;baud +1
		andi	tempreg4,0x01
		andi	r18,0xf8
		or	r18,tempreg4
		rjmp	clone_loop

;------------------------------------------------------------------------------
;change I2C speed
;------------------------------------------------------------------------------
clone_main_60:	cpi	r16,1
		brne	clone_main_65
		lds	tempreg1,libmio_sysconf	;recent conf
		ldi	tempreg4,0x10
		eor	r18,tempreg4
		rjmp	clone_loop

;------------------------------------------------------------------------------
;change SPI speed
;------------------------------------------------------------------------------
clone_main_65:	cpi	r16,2
		brne	clone_as_01
		ldi	tempreg4,0x08
		eor	r18,tempreg4
clone_main_67:	rjmp	clone_loop

;------------------------------------------------------------------------------
;change Autostart
;------------------------------------------------------------------------------
clone_as_01:	cpi	r16,7
		brne	clone_main_70
		mov	tempreg4,r19
		andi	r19,0x8f
		subi	tempreg4,0xf0
		andi	tempreg4,0x70
		or	r19,tempreg4
clone_as_02:	rjmp	clone_loop

;------------------------------------------------------------------------------
;change Data EEPROM address
;------------------------------------------------------------------------------
clone_main_70:	cpi	r16,3
		brne	clone_main_75
		mov	tempreg4,r19
		inc	tempreg4
		andi	tempreg4,0x07
		andi	r19,0xf8
		or	r19,tempreg4
		rjmp	clone_loop

;------------------------------------------------------------------------------
;Line end
;------------------------------------------------------------------------------
clone_main_75:	cpi	r16,4
		brne	clone_main_77
		subi	r18,0xc0		;+0x40
		brcs	clone_main_76
		ori	r18,0x40
clone_main_76:	rjmp	clone_loop

;------------------------------------------------------------------------------
;Serin mode
;------------------------------------------------------------------------------
clone_main_77:	cpi	r16,5
		brne	clone_main_82
		subi	r19,0x80		;+0x80
clone_main_80:	rjmp	clone_loop

;------------------------------------------------------------------------------
;Serin pin
;------------------------------------------------------------------------------
clone_main_82:	cpi	r16,6
		brne	clone_main_84
		ldi	tempreg4,0x20
		eor	r18,tempreg4		;+0x80
clone_main_84:	rjmp	clone_loop

clone_sconf:	;show config
;------------------------------------------------------------------------------
;show data
;------------------------------------------------------------------------------
clone_kbdtype: 	ldi	XL,0x06			;color scheme (yellow on black)
		api_setcolor
		api_thistext
		.db 3,1,"Serial speed:",0
		api_thistext
		.db 5,1,"I2C speed:",0,0
		api_thistext
		.db 7,1,"SPI speed:",0,0
		api_thistext
		.db 9,1,"EEPROM address:",0
		api_thistext
		.db 11,1,"Line end:",0
		api_thistext
		.db 13,1,"Serial In/Out:",0,0
		api_thistext
		.db 15,1,"Serial Input:",0
		api_thistext
		.db 17,1,"Autostart:",0,0
		clr	r17

;------------------------------------------------------------------------------
;show serial speed
;------------------------------------------------------------------------------
		rcall	clone_cset
		sbrc	r18,0
		rjmp	clone_sertype1
		api_thistext
		.db 3,18,"1200 Bps",0,0
		rjmp	clone_sertype2
clone_sertype1:	api_thistext
		.db 3,18,"2400 Bps",0,0
clone_sertype2:

;------------------------------------------------------------------------------
;show I2C speed
;------------------------------------------------------------------------------
		rcall	clone_cset
		sbrc	r18,4
		rjmp	clone_twitype1
		api_thistext
		.db 5,18,"100 kHz",0
		rjmp	clone_twitype2
clone_twitype1:	api_thistext
		.db 5,18,"400 kHz",0
clone_twitype2:

;------------------------------------------------------------------------------
;show SPI speed
;------------------------------------------------------------------------------
		rcall	clone_cset
		sbrc	r18,3
		rjmp	clone_spitype1
		api_thistext
		.db 7,18,"5 MHz  ",0
		rjmp	clone_spitype2
clone_spitype1:	api_thistext
		.db 7,18,"156 kHz",0
clone_spitype2:

;------------------------------------------------------------------------------
;show EEPROM address
;------------------------------------------------------------------------------
		rcall	clone_cset
clone_eeadr:	api_thistext
		.db 9,18,0,0
		mov	tempreg1,r19
		andi	tempreg1,0x07
		subi	tempreg1,0xd0
		api_outchar

;------------------------------------------------------------------------------
;show line end
;------------------------------------------------------------------------------
		rcall	clone_cset
		mov	tempreg4,r18
		andi	tempreg4,0xc0
clone_lintype1:	cpi	tempreg4,0x80
		brne	clone_lintype2
		api_thistext
		.db 11,18,"only LF",0
		rjmp	clone_lintype9
clone_lintype2:	cpi	tempreg4,0x40
		brne	clone_lintype3
		api_thistext
		.db 11,18,"only CR",0
		rjmp	clone_lintype9
clone_lintype3:	api_thistext
		.db 11,18,"CR+LF  ",0
clone_lintype9:

;------------------------------------------------------------------------------
;show serial interface
;------------------------------------------------------------------------------
		rcall	clone_cset
		sbrc	r19,7
		rjmp	clone_sintype1
		api_thistext
		.db 13,18,"simple  ",0,0
		rjmp	clone_sintype2
clone_sintype1:	api_thistext
		.db 13,18,"standard",0,0
clone_sintype2:

;------------------------------------------------------------------------------
;show serial input pin
;------------------------------------------------------------------------------
		rcall	clone_cset
		sbrc	r18,5
		rjmp	clone_sinput1
		api_thistext
		.db 15,18,"PD3",0
		rjmp	clone_sinput2
clone_sinput1:	api_thistext
		.db 15,18,"PD1",0
clone_sinput2:

;------------------------------------------------------------------------------
;show autostart
;------------------------------------------------------------------------------
		rcall	clone_cset
clone_autos:	api_thistext
		.db 17,18,"PRG ",0,0
		mov	tempreg1,r19
		swap	tempreg1
		andi	tempreg1,0x07
		breq	clone_autos1
		subi	tempreg1,0xd0
		api_outchar
clone_autose:	ldi	XL,0x07			;color scheme (white on black)
		api_setcolor
		ret

clone_autos1:	api_thistext
		.db 17,18,"off  ",0
		rjmp	clone_autose


clone_cset:	ldi	XL,0x05			;cyan on black
		cp	r16,r17
		brne	clone_cset1
		ldi	XL,0x50
clone_cset1:	api_setcolor
		inc	r17
		ret

;------------------------------------------------------------------------------
;the configpage menubar
;------------------------------------------------------------------------------
		;   "111111222222333333444444555555"
clone_mbar:	.db " Exit Change            CLONE "

;------------------------------------------------------------------------------
;clone flash
;------------------------------------------------------------------------------
clone_cdo:	api_askthis
		.db	0x6f,"Clone system? ",0
		cpi	tempreg1,0x01
		breq	clone_cdo_1
		rjmp	clone_loop

clone_cdo_1:	rcall	clone_init		;init
		rcall	clone_pen		;programm enable
		cpi	ereg,0x00
		breq	clone_cdo_2
		rcall	clone_exit
		api_alertthis
		.db	0x4f,"No controller found ",0
		rjmp	clone_loop

clone_cdo_2:	rcall	clone_rsb		;read signature bytes
		cpi	ereg,0x00
		breq	clone_cdo_3
		rcall	clone_exit
		api_alertthis
		.db	0x4f,"No Mega644 found",0
		rjmp	clone_loop

;erase chip
clone_cdo_3:	rcall	clone_wal		;draw alert box
		rcall	clone_era		;erase chip

;program flash
		clr	ZL			;clear pointer
		clr	ZH
		ldi	tempreg2,0x00		;page counter
clone_cdo_4:	ldi	tempreg3,0x00		;word counter
clone_cdo_5:	lpm	r0,Z+			;low byte
		rcall	clone_lobyte		;write
		lpm	r0,Z+			;high byte
		rcall	clone_hibyte		;write
		inc	tempreg3		;word counter3
		cpi	tempreg3,0x80		;end of page
		brne	clone_cdo_5		;word loop
		rcall	clone_wpage		;write page
		inc	tempreg2		;next page
		brne	clone_cdo_4		;page loop
;program eeprom sys0
		ldi	tempreg1,0xc2		;write EEPROM
		ldi	tempreg2,HIGH(2040)
		ldi	tempreg3,LOW(2040)
		mov	tempreg4,r18
		rcall	clone_cmd
;program eeprom sys1
		ldi	tempreg1,0xc2		;write EEPROM
		ldi	tempreg2,HIGH(2041)
		ldi	tempreg3,LOW(2041)
		mov	tempreg4,r19
		rcall	clone_cmd
;program low fuse
		ldi	tempreg1,0xac		;byte1
		ldi	tempreg2,0xa0
		ldi	tempreg3,0x00
		ldi	tempreg4,0xe6
		rcall	clone_cmd
;program high fuse
		ldi	tempreg1,0xac		;byte1
		ldi	tempreg2,0xa8		;byte2
		ldi	tempreg3,0x00
		ldi	tempreg4,0xd2
		rcall	clone_cmd
;program extended fuse
		ldi	tempreg1,0xac		;byte1
		ldi	tempreg2,0xa4		;byte2
		ldi	tempreg3,0x00
		ldi	tempreg4,0xfc
		rcall	clone_cmd

		rcall	clone_exit
		api_alertthis
		.db	0x80,"System cloned",0,0
		rjmp	clone_loop

;------------------------------------------------------------------------------
; init SPI and activate reset
;------------------------------------------------------------------------------
clone_init:	ldi	tempreg1,0x53		;config
		out	SPCR,tempreg1		;set spi
		out	SPSR,const_0		;x2=0
		sbi	DDRB,4			;output
		ldi	tempreg1,0xfd		;use bit 1
		api_spisel
		ldi	tempreg1,0xff
clone_init1:	dec	tempreg1
		brne	clone_init1
		sbi	PORTB,4			;stop (reset)
		ldi	tempreg1,0xff
clone_init2:	dec	tempreg1
		brne	clone_init2
		cbi	PORTB,4			;start (reset)
		ldi	tempreg1,0xff
clone_init3:	dec	tempreg1
		brne	clone_init3
		cbi	PORTB,4			;start (reset)
		ldi	tempreg1,0xff
clone_init4:	dec	tempreg1
		brne	clone_init4
		api_sync
		ret

;------------------------------------------------------------------------------
; deactivate reset and reconfigure SPI
;------------------------------------------------------------------------------
clone_exit:	api_spiunsel
		ldi	tempreg1,0x5c		;config
		out	SPCR,tempreg1		;set spi
		out	SPSR,const_1		;x2=1
		ret

;------------------------------------------------------------------------------
; send byte
;------------------------------------------------------------------------------
clone_czbyte:	rcall	clone_cbyte
clone_zbyte:	clr	tempreg1
clone_cbyte:	out	SPDR,tempreg1
clone_cbyte_1:	in	tempreg1,SPSR
		sbrs	tempreg1,SPIF
		rjmp	clone_cbyte_1
		in	tempreg1,SPDR
		ret

;------------------------------------------------------------------------------
; enable programming
;------------------------------------------------------------------------------
clone_pen:	clr	ereg			;no error
		ldi	tempreg1,0xac		;byte1
		rcall	clone_cbyte
		ldi	tempreg1,0x53		;byte2
		rcall	clone_czbyte		;byte 3
		cpi	tempreg1,0x53		;echo OK
		breq	clone_pen_1
		ldi	ereg,0x01		;no sync
clone_pen_1:	rcall	clone_zbyte		;byte 4 and end
		ret

;------------------------------------------------------------------------------
; read signature bytes
;------------------------------------------------------------------------------
clone_rsb:	clr	ereg			;no error
		ldi	tempreg1,0x30		;byte1
		rcall	clone_czbyte		;byte 2
		ldi	tempreg1,0x00		;adr 0
		rcall	clone_czbyte		;byte 3+4
		cpi	tempreg1,0x1e		;ID OK
		breq	clone_rsb_1
		ldi	ereg,0x02		;ID not OK
		ret

clone_rsb_1:	ldi	tempreg1,0x30		;byte1
		rcall	clone_czbyte		;byte 2
		ldi	tempreg1,0x01		;adr 1
		rcall	clone_czbyte		;byte 3+4
		cpi	tempreg1,0x96		;ID OK
		breq	clone_rsb_2
		ldi	ereg,0x02		;ID not OK
		ret

clone_rsb_2:	ldi	tempreg1,0x30		;byte1
		rcall	clone_czbyte		;byte 2
		ldi	tempreg1,0x02		;adr 1
		rcall	clone_czbyte		;byte 3+4
		cpi	tempreg1,0x09		;ID OK 644
		breq	clone_rsb_3
		cpi	tempreg1,0x0a		;ID OK 644P
		breq	clone_rsb_3
		ldi	ereg,0x02		;ID not OK
clone_rsb_3:	ret

;------------------------------------------------------------------------------
; erase chip
;------------------------------------------------------------------------------
clone_era:	ldi	tempreg1,0xac		;byte1
		ldi	tempreg2,0x80
		ldi	tempreg3,0x00
		ldi	tempreg4,0x00
		rjmp	clone_cmd

;------------------------------------------------------------------------------
; write page
;------------------------------------------------------------------------------
clone_wpage:	ldi	tempreg1,0x4c		;byte1
		rcall	clone_cbyte
		clr	tempreg4
		mov	tempreg1,tempreg2	;page number
		lsr	tempreg1		;/2
		ror	tempreg4
		rcall	clone_cbyte
		mov	tempreg1,tempreg4
		rcall	clone_czbyte		;byte 3+4
		rjmp	clone_cmd_1

;------------------------------------------------------------------------------
; write low byte
;------------------------------------------------------------------------------
clone_lobyte:	ldi	tempreg1,0x40		;byte1
		rjmp	clone_hibyte1

;------------------------------------------------------------------------------
; write high byte
;------------------------------------------------------------------------------
clone_hibyte:	ldi	tempreg1,0x48		;byte1
clone_hibyte1:	rcall	clone_czbyte		;byte 1+2
		mov	tempreg1,tempreg3	;word number
		rcall	clone_cbyte
		mov	tempreg1,r0
		rjmp	clone_cbyte		;byte 4 and end

;------------------------------------------------------------------------------
;write-alertbox
;------------------------------------------------------------------------------
clone_wal:	api_pushxyz
		lds	tempreg1,libmio_color	;old color
		mov	tempreg8,tempreg1	;save
		ldi	tempreg1,0x4c		;yellow on red
		sts	libmio_color,tempreg1	;set new color
		ldi	YL,5
		ldi	YH,10
		ldi	ZL,24
		ldi	ZH,12
		api_wbox			;draw window
		api_thistext
		.db 	11,6,"Cloning System...",0
		mov	tempreg1,tempreg8
		sts	libmio_color,tempreg1	;restore old color
		api_popxyz

;------------------------------------------------------------------------------
;exec a command
;------------------------------------------------------------------------------
clone_cmd:	rcall	clone_cbyte
		mov	tempreg1,tempreg2
		rcall	clone_cbyte
		mov	tempreg1,tempreg3
		rcall	clone_cbyte
		mov	tempreg1,tempreg4
		rcall	clone_cbyte

clone_cmd_1:	ldi	tempreg1,0xf0
		rcall	clone_cbyte
		ldi	tempreg1,0x00
		rcall	clone_cbyte
		ldi	tempreg1,0x00
		rcall	clone_cbyte
		ldi	tempreg1,0x00
		rcall	clone_cbyte
		sbrc	tempreg1,0
		rjmp	clone_cmd_1
		ret

