;clear registers and stack memory
ch8_entry:	rcall	chip8_cls
		ldi	YL,LOW(ch8_regs)
		ldi	YH,HIGH(ch8_regs)
		ldi	XL,24			;regs + special
ch8_entry_1:	st	Y+,const_0
		dec	XL
		brne	ch8_entry_1

;copy the font tables into XRAM
		ldi	ZL,LOW(chip8_ctables*2)	;ROM table
		ldi	ZH,HIGH(chip8_ctables*2)
		ldi	XL,32			;RAM address
		clr	XH
		ldi	YL,LOW(288)
		ldi	YH,HIGH(288)
ch8_entry_10:	lpm	r18,Z+
		rcall	drv_xmem_wbyte
		sbiw	YL,1
		brne	ch8_entry_10

		sts	ch8_kflags,const_0

;set necessary registers
		ldi	PC_L,0			;PC_L
		ldi	PC_H,2			;PC_H
		mov	ch8_ireg_lo,const_0	;set I to zero
		mov	ch8_ireg_hi,const_0
		mov	ch8_vmode,const_0
		mov	ch8_sp,const_0		;stack pointer
		clr	r14			;delay counter
		clr	r15			;sound counter
		lds	r13,ch8_frame		;recent frame no

;----------------------------------------------------------------
;get 2 bytes from RAM (PC)
;----------------------------------------------------------------
ch8_loop:	ldi	XL,15
		ldi	XH,0
		rcall	drv_xmem_rbyte
		mov	XL,r18

ch8_pdelay:	cpi	XL,0
		breq	ch8_pdelay_e
		mov	XH,r8			;vline_l
ch8_pdelay_1:	lds	tempreg1,ch8_kcode
		cpi	tempreg1,0xfa		;F10
		brne	ch8_pdelay_2
		rjmp	ch8_entry
ch8_pdelay_2:	cp	XH,r8
		breq	ch8_pdelay_1
		dec	XL
		rjmp	ch8_pdelay

ch8_pdelay_e:	api_screenshot

		andi	PC_H,0x0f		;limit PC
		movw	XL,PC_L			;copy PC to address
		rcall	drv_xmem_rword
		adiw	PC_L,2			;inc PC
		lds	ZL,ch8_kflags
		sbrc	ZL,0			;break flag ?
		rjmp	ch8_break

		lds	r16,ch8_frame		;recent frame no
		cp	r16,r13			;1 changed?
		breq	ch8_do			;1/2 branch if not changed

		ldi	r17,63			;envelope end
		mov	r13,r16			;set new frame counter
		cp	r14,const_0		;check if zero
		breq	ch8_nloop_1		;yes
		dec	r14			;-1
ch8_nloop_1:	cp	r15,const_0
		breq	ch8_nloop_2
		dec	r15
		clr	r17			;start of envelope
ch8_nloop_2:	sts	ch8_env,r17

;execute code in X
ch8_do:		ldi	ZL,LOW(ch8_jtab1)	;1
		ldi	ZH,HIGH(ch8_jtab1)	;1
		mov	r16,cmd_hi		;1
		swap	r16			;1
		andi	r16,0x0f		;1
		add	ZL,r16			;1
		adc	ZH,const_0		;1
		ijmp				;2

ch8_break0:	pop	tempreg1		;kill stack
		pop	tempreg1
		lds	ZL,ch8_kflags
ch8_break:	ldi	tempreg1,1		;1 break code
		andi	ZL,0xfe			;kill break flag
		sts	ch8_kflags,ZL
		ret

ch8_jtab1:	rjmp	ch8_0xxx		;2
		rjmp	ch8_1xxx		;2
		rjmp	ch8_2xxx		;2
		rjmp	ch8_3xxx		;2
		rjmp	ch8_4xxx		;2
		rjmp	ch8_5xxx		;2
		rjmp	ch8_6xxx		;2
		rjmp	ch8_7xxx		;2
		rjmp	ch8_8xxx		;2
		rjmp	ch8_9xxx		;2
		rjmp	ch8_axxx		;2
		rjmp	ch8_bxxx		;2
		rjmp	ch8_cxxx		;2
		rjmp	ch8_dxxx		;2
		rjmp	ch8_exxx		;2
		rjmp	ch8_fxxx		;2

ch8_unknown:	ldi	tempreg1,4		;illegal opcode error
		ret

ch8_0xxx:	cpi	cmd_hi,0x00		;1 00xx
		brne	ch8_unknown		;1/2 no
		mov	r16,cmd_lo		;copy LO byte
		subi	r16,0xc0		;1 sub code start
		brcs	ch8_unknown		;1/2 not a regular FCT
		ldi	ZL,LOW(ch8_jtab2)	;1
		ldi	ZH,HIGH(ch8_jtab2)	;1
		add	ZL,r16			;1
		adc	ZH,const_0		;1
		ijmp				;2

ch8_jtab2:	rjmp	ch8_scdown		;2 code c0
		rjmp	ch8_scdown		;2 code c1
		rjmp	ch8_scdown		;2 code c2
		rjmp	ch8_scdown		;2 code c3
		rjmp	ch8_scdown		;2 code c4
		rjmp	ch8_scdown		;2 code c5
		rjmp	ch8_scdown		;2 code c6
		rjmp	ch8_scdown		;2 code c7
		rjmp	ch8_scdown		;2 code c8
		rjmp	ch8_scdown		;2 code c9
		rjmp	ch8_scdown		;2 code ca
		rjmp	ch8_scdown		;2 code cb
		rjmp	ch8_scdown		;2 code cc
		rjmp	ch8_scdown		;2 code cd
		rjmp	ch8_scdown		;2 code ce
		rjmp	ch8_scdown		;2 code cf

		rjmp	ch8_unknown		;2 code d0
		rjmp	ch8_unknown		;2 code d1
		rjmp	ch8_unknown		;2 code d2
		rjmp	ch8_unknown		;2 code d3
		rjmp	ch8_unknown		;2 code d4
		rjmp	ch8_unknown		;2 code d5
		rjmp	ch8_unknown		;2 code d6
		rjmp	ch8_unknown		;2 code d7
		rjmp	ch8_unknown		;2 code d8
		rjmp	ch8_unknown		;2 code d9
		rjmp	ch8_unknown		;2 code da
		rjmp	ch8_unknown		;2 code db
		rjmp	ch8_unknown		;2 code dc
		rjmp	ch8_unknown		;2 code dd
		rjmp	ch8_unknown		;2 code de
		rjmp	ch8_unknown		;2 code df

		rjmp	ch8_erase		;2 code e0 erase screen
		rjmp	ch8_unknown		;2 code e1
		rjmp	ch8_unknown		;2 code e2
		rjmp	ch8_unknown		;2 code e3
		rjmp	ch8_unknown		;2 code e4
		rjmp	ch8_unknown		;2 code e5
		rjmp	ch8_unknown		;2 code e6
		rjmp	ch8_unknown		;2 code e7
		rjmp	ch8_unknown		;2 code e8
		rjmp	ch8_unknown		;2 code e9
		rjmp	ch8_unknown		;2 code ea
		rjmp	ch8_unknown		;2 code eb
		rjmp	ch8_unknown		;2 code ec
		rjmp	ch8_unknown		;2 code ed
		rjmp	ch8_return		;2 code ee return from sub
		rjmp	ch8_unknown		;2 code ef

		rjmp	ch8_unknown		;2 code f0
		rjmp	ch8_unknown		;2 code f1
		rjmp	ch8_unknown		;2 code f2
		rjmp	ch8_unknown		;2 code f3
		rjmp	ch8_unknown		;2 code f4
		rjmp	ch8_unknown		;2 code f5
		rjmp	ch8_unknown		;2 code f6
		rjmp	ch8_unknown		;2 code f7
		rjmp	ch8_unknown		;2 code f8
		rjmp	ch8_unknown		;2 code f9
		rjmp	ch8_unknown		;2 code fa
		rjmp	ch8_rscroll		;2 code fb
		rjmp	ch8_lscroll		;2 code fc
		rjmp	ch8_exit		;2 code fd
		rjmp	ch8_set_8mode		;2 code fe
		rjmp	ch8_set_smode		;2 code ff

ch8_erase:	rcall	chip8_cls
		rjmp	ch8_loop		;thats all

;scroll down
ch8_scdown:	andi	r16,0x0f		;only 0..15
		cpi	r16,0			;0xc0 scrolls 16 lines
		brne	ch8_scdown_01
		ldi	r16,16			;0->16
ch8_scdown_01:	ldi	XH,16			;bytes per line
		mul	r16,XH
		api_getvram			;get VRAM address to Y
		subi	YH,0xfc			;+1024
		movw	ZL,YL			;copy for src ptr
		sub	ZL,r0
		sbc	ZH,r1
		ldi	XH,4			;max 1024 bytes to transfer (scroll 0 ;-)
		ldi	XL,0
		sub	XL,r0
		sbc	XH,r1
ch8_scdown_02:	ld	r17,-Z
		st	-Y,r17
		sbiw	XL,1
		brne	ch8_scdown_02
		movw	XL,r0
ch8_scdown_03:	st	-Y,const_0
		sbiw	XL,1
		brne	ch8_scdown_03
		rjmp	ch8_loop


ch8_lscroll:	api_getvram
		ldi	XH,64			;lines to do
ch8_lscroll_1:	ldi	XL,15			;bytes per line to do
ch8_lscroll_2:	ld	r16,Y			;get left byte
		ldd	r17,Y+1			;get right byte
		andi	r16,0xf0		;use right part of left byte
		andi	r17,0x0f		;use left part of right byte
		swap	r16
		swap	r17
		or	r16,r17
		st	Y+,r16			;store new left byte
		dec	XL			;X loop
		brne	ch8_lscroll_2
		andi	r16,0xf0
		ld	r16,Y
		swap	r16
		st	Y+,r16
		dec	XH
		brne	ch8_lscroll_1
		rjmp	ch8_loop		;thats all


ch8_rscroll:	api_getvram			;set Y to VRAM base
		subi	YH,0xfc			;+1024
		ldi	XH,64			;lines to do
ch8_rscroll_1:	ldi	XL,15			;bytes per line to do
ch8_rscroll_2:	ld	r16,-Y			;get right byte
		ld	r17,-Y			;get left byte
		andi	r16,0x0f		;use left part of right byte
		andi	r17,0xf0		;use right part of left byte
		swap	r16			;swap right byte
		swap	r17			;swap left byte
		or	r16,r17			;merge
		std	Y+1,r16			;store new right byte
		adiw	YL,1			;set ptr
		dec	XL			;X loop
		brne	ch8_rscroll_2		;done?
		ld	r16,-Y			;only right byte
		andi	r16,0x0f		;only left part
		swap	r16
		st	Y,r16
		dec	XH
		brne	ch8_rscroll_1
		rjmp	ch8_loop		;thats all

;stack underflow
cb8_stackuf:	ldi	tempreg1,2		;stack underflow
		ret				;end

ch8_return:	cp	ch8_sp,const_0		;stackpointer
		breq	cb8_stackuf
		ldi	YL,LOW(ch8_stack)
		ldi	YH,HIGH(ch8_stack)
		add	YL,ch8_sp
		add	YH,const_0
		dec	ch8_sp
		dec	ch8_sp
		ld	PC_H,-Y			;PC_L
		ld	PC_L,-Y			;PC_H
		rjmp	ch8_loop		;thats all

ch8_exit:	ldi	tempreg1,0		;normal exit
		ret				;end

ch8_set_8mode:	mov	ch8_vmode,const_0	;set mode to chip8
		rjmp	ch8_loop		;thats all

ch8_set_smode:	mov	ch8_vmode,const_1	;set mode to schip
		rjmp	ch8_loop		;thats all

;jump
ch8_1xxx:	mov	PC_L,cmd_lo		;set new PC
		mov	PC_H,cmd_hi
		rjmp	ch8_loop		;thats all

;call
ch8_2xxx:	ldi	tempreg1,3		;stack overflow
		sbrc	ch8_sp,5		;skip if stackpointer is <32
		ret
		ldi	YL,LOW(ch8_stack)
		ldi	YH,HIGH(ch8_stack)
		add	YL,ch8_sp
		adc	YH,const_0
		st	Y+,PC_L
		st	Y+,PC_H
		inc	ch8_sp
		inc	ch8_sp
		rjmp	ch8_1xxx

;skip next if VX=XX
ch8_3xxx:	rcall	ch8_gvarptr		;set ptrs
		ld	r16,X			;get register
		cp	r16,cmd_lo		;compare
		brne	ch8_3xxx_1		;no skip if not equal
		adiw	PC_L,2			;skip next two bytes
ch8_3xxx_1:	rjmp	ch8_loop		;thats all

;skip next if VX<>XX
ch8_4xxx:	rcall	ch8_gvarptr		;set ptrs
		ld	r16,X			;get register
		cp	r16,cmd_lo		;compare
		breq	ch8_4xxx_1		;no skip if equal
		adiw	PC_L,2			;skip next two bytes
ch8_4xxx_1:	rjmp	ch8_loop		;thats all

;skip next if VX=VY
ch8_5xxx:	rcall	ch8_gvarptr		;set ptrs
		ld	r16,X			;get register X
		ld	r17,Y			;get register Y
		cp	r16,r17			;compare
		brne	ch8_5xxx_1		;no skip if not equal
		adiw	PC_L,2			;skip next two bytes
ch8_5xxx_1:	rjmp	ch8_loop		;thats all

;VX=XX
ch8_6xxx:	rcall	ch8_gvarptr		;set ptrs
		st	X,cmd_lo		;store value
		rjmp	ch8_loop		;thats all

;VX+=XX
ch8_7xxx:	rcall	ch8_gvarptr		;set ptrs
		ld	r16,X
		add	r16,cmd_lo
		st	X,r16			;store value
		rjmp	ch8_loop		;thats all


ch8_8xxx:	rcall	ch8_gvarptr
		;set jump address
		mov	r16,cmd_lo		;copy CMD
		andi	r16,0x0f		;function
		ldi	ZL,LOW(ch8_jtab3)	;1
		ldi	ZH,HIGH(ch8_jtab3)	;1
		add	ZL,r16			;1
		adc	ZH,const_0		;1
		ijmp

ch8_jtab3:	rjmp	ch8_8xx0		; code 8xy0
		rjmp	ch8_8xx1		; code 8xy1
		rjmp	ch8_8xx2		; code 8xy2
		rjmp	ch8_8xx3		; code 8xy3
		rjmp	ch8_8xx4		; code 8xy4
		rjmp	ch8_8xx5		; code 8xy5
		rjmp	ch8_8xx6		; code 8xy6
		rjmp	ch8_8xx7		; code 8xy7
		rjmp	ch8_unknown		; code 8xy8
		rjmp	ch8_unknown		; code 8xy9
		rjmp	ch8_unknown		; code 8xya
		rjmp	ch8_unknown		; code 8xyb
		rjmp	ch8_unknown		; code 8xyc
		rjmp	ch8_unknown		; code 8xyd
		rjmp	ch8_8xxe		; code 8xye
		rjmp	ch8_unknown		; code 8xyf

;VX=VY
ch8_8xx0:	ld	r16,Y			;get VY
		st	X,r16			;store VX
		rjmp	ch8_loop

;VX=VX OR VY
ch8_8xx1:	ld	r16,X			;get VX
		ld	r17,Y			;get VY
		or	r16,r17			;do function
		st	X,r16			;write back VX
		rjmp	ch8_loop

;VX=VX AND VY
ch8_8xx2:	ld	r16,X			;get VX
		ld	r17,Y			;get VY
		and	r16,r17			;do function
		st	X,r16			;write back VX
		rjmp	ch8_loop

;VX=VX XOR VY
ch8_8xx3:	ld	r16,X			;get VX
		ld	r17,Y			;get VY
		eor	r16,r17			;do function
		st	X,r16			;write back VX
		rjmp	ch8_loop

;VX=VX + VY
ch8_8xx4:	sts	ch8_regs+15,const_0	;clear VF
		ld	r16,X			;get VX
		ld	r17,Y			;get VY
		add	r16,r17			;do function
		st	X,r16			;write back VX
		brcc	ch8_8xx4_1		;branchif no carry
		sts	ch8_regs+15,const_1	;set VF
ch8_8xx4_1:	rjmp	ch8_loop

;VX=VX - VY
ch8_8xx5:	sts	ch8_regs+15,const_0	;clear VF
		ld	r16,X			;get VX
		ld	r17,Y			;get VY
		sub	r16,r17			;do function
		st	X,r16			;write back VX
		brcs	ch8_8xx5_1		;branch if borrow
		sts	ch8_regs+15,const_1	;set VF
ch8_8xx5_1:	rjmp	ch8_loop

;shift right VX
ch8_8xx6:	clr	r17			;flag
		ld	r16,X			;get VX
		lsr	r16
ch8_8xx6_1:	rol	r17
		st	X,r16
		sts	ch8_regs+15,r17		;store VF
		rjmp	ch8_loop

;VX=VY - VX
ch8_8xx7:	sts	ch8_regs+15,const_0	;clear VF
		ld	r16,X			;get VX
		ld	r17,Y			;get VY
		sub	r17,r16			;do function
		st	X,r17			;write back VX
		brcs	ch8_8xx7_1
		sts	ch8_regs+15,const_1	;set VF
ch8_8xx7_1:	rjmp	ch8_loop

;shift left VX
ch8_8xxe:	clr	r17			;flag
		ld	r16,X			;get VX
		lsl	r16
		rol	r17
		st	X,r16
		sts	ch8_regs+15,r17		;store VF
		rjmp	ch8_loop

;skip next if VX<>VY
ch8_9xxx:	rcall	ch8_gvarptr		;set ptrs
		ld	r16,X			;get register X
		ld	r17,Y			;get register Y
		cp	r16,r17			;compare
		breq	ch8_9xxx_1		;no skip if equal
		adiw	PC_L,2			;skip next two bytes
ch8_9xxx_1:	rjmp	ch8_loop		;thats all

;I=XXXX
ch8_axxx:	andi	cmd_hi,0x0f
		mov	ch8_ireg_lo,cmd_lo
		mov	ch8_ireg_hi,cmd_hi
		rjmp	ch8_loop		;thats all

;JMP V0+XXX
ch8_bxxx:	andi	cmd_hi,0x0f		;mask bits
		lds	r16,ch8_regs+0		;get V0
		add	cmd_lo,r16		;add
		adc	cmd_hi,const_0
		mov	PC_L,cmd_lo
		mov	PC_H,cmd_hi
		rjmp	ch8_loop		;thats all

;VX = RAND AND XX
ch8_cxxx:	rcall	ch8_gvarptr		;set ptrs
		lds	r16,ch8_rand		;get rand
		and	r16,cmd_lo
		st	X,r16			;get register X
ch8_cxxx_e:	rjmp	ch8_loop		;thats all


;draw sprite XYN
ch8_dxxx:	mov	tempreg4,cmd_lo		;for nibble
		andi	tempreg4,0x0f
		rcall	ch8_gvarptr		;set ptrs
		ld	r16,X			;get value of register X
		ld	r17,Y			;get value of register Y

		sts	ch8_regs+15,const_0	;no collision

		movw	XL,ch8_ireg_lo		;I register
		sbrc	ch8_vmode,0		;skip if chip8 mode
		rjmp	ch8_sprs		;Schip sprite

;chip 8 sprite
ch8_spr8:	andi	r16,63			;limit X
		andi	r17,31			;limit Y
		cpi	tempreg4,0		;height = 0 -> 16x16 sprite
		brne	ch8_spr8_1		;normal sprite
		ldi	tempreg4,16		;big sprite


ch8_spr8_1:	cpi	tempreg4,0		;height = 0
		breq	ch8_cxxx_e
		rcall	drv_xmem_rbyte		;get pixline to r18
		ldi	tempreg3,8		;pixel in X direction
ch8_spr8_2:	lsl	r18			;shift out pix
		brcc	ch8_spr8_4		;0 -> do nothing
		api_getvram			;set Y to start of video RAM
		ldi	tempreg1,32		;bytes per line
		mul	tempreg1,r17		;*Y
		add	YL,r0			;add Y offset
		adc	YH,r1
		mov	tempreg1,r16		;X
		lsr	tempreg1		;/4
		lsr	tempreg1
		add	YL,tempreg1		;add X offset
		adc	YH,const_0
		ldi	tempreg1,0x03		;mask
		sbrc	r16,0
		ldi	tempreg1,0x0c
		sbrc	r16,1
		swap	tempreg1
		ld	ZL,Y			;get orig byte
		and	ZL,tempreg1		;pixels set?
		breq	ch8_spr8_3		;not
		sts	ch8_regs+15,const_1	;set flag
ch8_spr8_3:	ld	ZL,Y			;get orig byte, row 1
		eor	ZL,tempreg1
		st	Y,ZL
		ldd	ZL,Y+16			;get orig byte, row 2
		eor	ZL,tempreg1
		std	Y+16,ZL
ch8_spr8_4:	inc	r16			;next X
		andi	r16,63
		dec	tempreg3
		brne	ch8_spr8_2
		inc	r17
		andi	r17,31
		subi	r16,8
		andi	r16,63
		dec	tempreg4
		rjmp	ch8_spr8_1

;Schip sprite
ch8_sprs:	andi	r16,127			;limit X
		andi	r17,63			;limit Y
		cpi	tempreg4,0		;height = 0 -> 16x16 sprite
		breq	ch8_sprs_10		;big sprite

ch8_sprs_1:	rcall	drv_xmem_rbyte		;get pixline
		ldi	tempreg3,8		;pixel in X direction
ch8_sprs_2:	lsl	r18			;shift out pix
		brcc	ch8_sprs_4		;0 -> do nothing
		api_getvram			;set Y to start of video RAM
		ldi	tempreg1,16		;bytes per line
		mul	tempreg1,r17		;*Y
		add	YL,r0			;add Y offset
		adc	YH,r1
		mov	tempreg1,r16		;copy X
		lsr	tempreg1		;/8
		lsr	tempreg1
		lsr	tempreg1
		add	YL,tempreg1		;add X offset
		adc	YH,const_0
		ldi	tempreg1,0x01		;mask
		sbrc	r16,1
		ldi	tempreg1,0x04
		sbrc	r16,0
		lsl	tempreg1
		sbrc	r16,2
		swap	tempreg1
		ld	ZL,Y			;get orig byte
		and	ZL,tempreg1		;pixels set?
		breq	ch8_sprs_3		;not
		sts	ch8_regs+15,const_1	;set flag
ch8_sprs_3:	ld	ZL,Y			;get orig byte, row 1
		eor	ZL,tempreg1
		st	Y,ZL
ch8_sprs_4:	inc	r16			;next X
		andi	r16,127
		dec	tempreg3
		brne	ch8_sprs_2
		inc	r17
		andi	r17,63
		subi	r16,8
		andi	r16,127
		dec	tempreg4
		brne	ch8_sprs_1


ch8_sprs_end:	rjmp	ch8_loop		;end here


ch8_sprs_10:	ldi	tempreg4,16		;lines to do
ch8_sprs_11:	cpi	tempreg4,0		;height = 0
		breq	ch8_sprs_end
		rcall	drv_xmem_rbyte		;get pixline
		ldi	tempreg3,8		;pixel in X direction
ch8_sprs_12:	lsl	r18			;shift out pix
		brcc	ch8_sprs_14		;0 -> do nothing
		api_getvram			;set Y to start of video RAM
		ldi	tempreg1,16		;bytes per line
		mul	tempreg1,r17		;*Y
		add	YL,r0			;add Y offset
		adc	YH,r1
		mov	tempreg1,r16		;X
		lsr	tempreg1		;/8
		lsr	tempreg1
		lsr	tempreg1
		add	YL,tempreg1		;add X offset
		adc	YH,const_0
		ldi	tempreg1,0x80		;mask
		sbrc	r16,1
		lsr	tempreg1,0x20
		sbrc	r16,0
		lsr	tempreg1
		sbrc	r16,2
		swap	tempreg1
		ld	ZL,Y			;get orig byte
		and	ZL,tempreg1		;pixels set?
		breq	ch8_sprs_13		;not
		sts	ch8_regs+15,const_1	;set flag
ch8_sprs_13:	ld	ZL,Y			;get orig byte, row 1
		eor	ZL,tempreg1
		st	Y,ZL
ch8_sprs_14:	inc	r16			;next X
		andi	r16,127
		dec	tempreg3
		brne	ch8_sprs_12

		rcall	drv_xmem_rbyte		;get pixline
		ldi	tempreg3,8		;pixel in X direction
ch8_sprs_22:	lsl	r18			;shift out pix
		brcc	ch8_sprs_24		;0 -> do nothing
		api_getvram			;set Y to start of video RAM
		ldi	tempreg1,16		;bytes per line
		mul	tempreg1,r17		;*Y
		add	YL,r0			;add Y offset
		adc	YH,r1
		mov	tempreg1,r16		;X
		lsr	tempreg1		;/8
		lsr	tempreg1
		lsr	tempreg1
		add	YL,tempreg1		;add X offset
		adc	YH,const_0
		ldi	tempreg1,0x80		;mask
		sbrc	r16,1
		lsr	tempreg1,0x20
		sbrc	r16,0
		lsr	tempreg1
		sbrc	r16,2
		swap	tempreg1
		ld	ZL,Y			;get orig byte
		and	ZL,tempreg1		;pixels set?
		breq	ch8_sprs_23		;not
		sts	ch8_regs+15,const_1	;set flag
ch8_sprs_23:	ld	ZL,Y			;get orig byte, row 1
		eor	ZL,tempreg1
		st	Y,ZL
ch8_sprs_24:	inc	r16			;next X
		andi	r16,127
		dec	tempreg3
		brne	ch8_sprs_22

		inc	r17
		andi	r17,63
		subi	r16,16
		andi	r16,127
		dec	tempreg4
		rjmp	ch8_sprs_11

ch8_exxx:	rcall	ch8_gvarptr		;get var ptrs
		cpi	cmd_lo,0x9e		;skip if key pressed
		breq	ch8_ex9e		;yes
		cpi	cmd_lo,0xa1		;skip if key not pressed
		breq	ch8_exa1		;yes
		rjmp	ch8_unknown		;no valid code

;skip if key is pressed
ch8_ex9e:	ld	r16,X			;get VX
		andi	r16,0x0f
		rcall	ch8_getkey
		cp	r16,tempreg1
		brne	ch8_ex9e_1		;branch if key not pressed
		adiw	PC_L,2			;skip next two bytes
ch8_ex9e_1:	rjmp	ch8_loop		;thats all

;skip if key VX is not pressed
ch8_exa1:	ld	r16,X			;get VX
		andi	r16,0x0f
		rcall	ch8_getkey
		cp	r16,tempreg1
		breq	ch8_exa1_1		;branch if key is pressed
		adiw	PC_L,2			;skip next two bytes
ch8_exa1_1:	rjmp	ch8_loop		;thats all

ch8_fxxx:	rcall	ch8_gvarptr		;get var ptrs

;VX = delay timer
ch8_fx07:	cpi	cmd_lo,0x07		;Fx07 VX=delay timer
		brne	ch8_fx0a		;not
		st	X,r14			;
		rjmp	ch8_loop		;thats all

;wait for key
ch8_fx0a:	cpi	cmd_lo,0x0a		;Fx0a wait for key, VX=key
		brne	ch8_fx15		;not
ch8_fx0a_1:	rcall	ch8_getkey		;get keycode to  tempreg1
		sbrc	tempreg1,7		;skip if any key is pressed
		rjmp	ch8_fx0a_1		;wait again
		st	X,tempreg1		;store to VX
		rjmp	ch8_loop		;thats all

;delay timer = VX
ch8_fx15:	cpi	cmd_lo,0x15		;delay timer = VX
		brne	ch8_fx18		;not
		ld	r14,X			;set delay timer
		rjmp	ch8_loop		;thats all

;sound timer = VX
ch8_fx18:	cpi	cmd_lo,0x18		;sound timer = VX
		brne	ch8_fx1e		;not
		ld	r15,X			;get sound timer
		rjmp	ch8_loop		;thats all

ch8_fx1e:	cpi	cmd_lo,0x1e		;I = I + VX
		brne	ch8_fx29		;not
		sts	ch8_regs+15,const_0	;clear VF
		ld	r16,X			;get register X
		add	ch8_ireg_lo,r16
		adc	ch8_ireg_hi,const_0
		sbrc	ch8_ireg_hi,4
		sts	ch8_regs+15,const_1	;set VF
		ldi	r16,0x0f
		and	ch8_ireg_hi,r16
		rjmp	ch8_loop		;thats all

ch8_fx29:	cpi	cmd_lo,0x29		;point I to num sprite VX
		brne	ch8_fx30		;not
		ld	r16,X			;get VX
		andi	r16,0x0f
		ldi	tempreg1,8		;bytes per char
		mul	r16,tempreg1
		movw	ch8_ireg_lo,r0
		ldi	r16,32
		add	ch8_ireg_lo,r16		;offset for small font
		adc	ch8_ireg_hi,const_0
		rjmp	ch8_loop		;thats all

ch8_fx30:	cpi	cmd_lo,0x30		;point I to num sprite VX
		brne	ch8_fx33		;not
		ld	r16,X			;get VX
		andi	r16,0x0f
		ldi	tempreg1,10		;bytes per char
		mul	r16,tempreg1
		movw	ch8_ireg_lo,r0
		ldi	r16,160			;table offset
		add	ch8_ireg_lo,r16		;offset for big font
		adc	ch8_ireg_hi,const_0
		rjmp	ch8_loop		;thats all

ch8_fx33:	cpi	cmd_lo,0x33		;store BCD
		brne	ch8_fx55		;not
		ld	tempreg1,X		;get VX register
		ldi	tempreg2,0xff		;Z
		ldi	tempreg3,0xff		;H
ch8_fx33_1:	inc	tempreg3		;H+1
		subi	tempreg1,100		;-100
		brcc	ch8_fx33_1
		subi	tempreg1,156		;+100
ch8_fx33_2:	inc	tempreg2		;Z+1
		subi	tempreg1,10		;-10
		brcc	ch8_fx33_2
		subi	tempreg1,246		;+10
		movw	XL,ch8_ireg_lo
		mov	r18,tempreg3		;H
		rcall	drv_xmem_wbyte
		mov	r18,tempreg2		;Z
		rcall	drv_xmem_wbyte
		mov	r18,tempreg1		;E
		rcall	drv_xmem_wbyte
		rjmp	ch8_loop		;thats all

;save V0..VX to (I)
ch8_fx55:	cpi	cmd_lo,0x55		;save registers 0 to VX to mem
		brne	ch8_fx65		;not
		mov	r16,cmd_hi
		andi	r16,0x0f
		inc	r16
		ldi	YL,LOW(ch8_regs)
		ldi	YH,HIGH(ch8_regs)
		movw	XL,ch8_ireg_lo		;get I
ch8_fx55_1:	ld	r18,Y+			;get register
		rcall	drv_xmem_wbyte
		dec	r16
		brne	ch8_fx55_1
		movw	ch8_ireg_lo,XL
		rjmp	ch8_loop		;thats all

;load V0..VX from (I)
ch8_fx65:	cpi	cmd_lo,0x65		;load registers from mem
		brne	ch8_fx75		;not
		mov	r16,cmd_hi
		andi	r16,0x0f
		inc	r16
		ldi	YL,LOW(ch8_regs)
		ldi	YH,HIGH(ch8_regs)
		movw	XL,ch8_ireg_lo		;get I
ch8_fx65_1:	rcall	drv_xmem_rbyte		;read
		st	Y+,r18
		dec	r16
		brne	ch8_fx65_1
		movw	ch8_ireg_lo,XL
		rjmp	ch8_loop		;thats all

;save V0..VX to special mem
ch8_fx75:	cpi	cmd_lo,0x75		;save registers to spec
		brne	ch8_fx85		;not
		mov	r16,cmd_hi
		andi	r16,0x07
		inc	r16
		ldi	YL,LOW(ch8_regs)
		ldi	YH,HIGH(ch8_regs)
ch8_fx75_1:	ld	r0,Y+			;get register
		std	Y+15,r0
		dec	r16
		brne	ch8_fx75_1
		rjmp	ch8_loop		;thats all

;load V0..Vx from special mem
ch8_fx85:	cpi	cmd_lo,0x85		;save registers to spec
		brne	ch8_fx86		;not
		mov	r16,cmd_hi
		andi	r16,0x07
		inc	r16
		ldi	YL,LOW(ch8_regs)
		ldi	YH,HIGH(ch8_regs)
ch8_fx85_1:	ldd	r0,Y+16			;get register
		st	Y+,r0
		dec	r16
		brne	ch8_fx85_1
		rjmp	ch8_loop		;thats all

ch8_fx86:	rjmp	ch8_unknown		;thats all

;get recent key to tempreg1
ch8_getkey:	lds	tempreg2,ch8_kflags
		sbrc	tempreg2,0		;break flag ?
		rjmp	ch8_break0

		lds	tempreg2,ch8_kcode

		push	XL
		push	XH
		push	r18
		ldi	XL,0x10			;start of keytable in XRAM
		ldi	XH,0x00

		ldi	tempreg1,0

ch8_getkey_1:	rcall	drv_xmem_rbyte
		cp	r18,tempreg2
		breq	ch8_getkey_2
		inc	tempreg1
		sbrs	tempreg1,4
		rjmp	ch8_getkey_1
		ldi	tempreg1,0xff
ch8_getkey_2:	pop	r18
		pop	XH
		pop	XL
		ret

;get variable pointers
ch8_gvarptr:	mov	XH,cmd_hi
		andi	XH,0x0f
		ldi	XL,LOW(ch8_regs)
		add	XL,XH
		ldi	XH,HIGH(ch8_regs)
		mov	YH,cmd_lo
		andi	YH,0xf0
		swap	YH
		ldi	YL,LOW(ch8_regs)
		add	YL,YH
		ldi	YH,HIGH(ch8_regs)
		ret

