;################################################################################
;#										#
;# avr-chipbasic2 - single chip basic computer with ATmega644			#
;# benchmark 		 							#
;# copyright (c) 2006-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;#										#
;# This program is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU General Public License			#
;# as published by the Free Software Foundation; either version 3		#
;# of the License, or (at your option) any later version.			#
;#										#
;# This program is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the GNU		#
;# General Public License for more details.					#
;#										#
;# You should have received a copy of the GNU General Public			#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.CSEG
.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.org	0x6c00
;                   "......      N"  
start:		.db "Bench- mark N",0xec,0xff,0xff
;icon def
		.db "????"
		.db "????"
		.db "????"

;dummy data
		.db 0x00,0x00,0x00,0x00

.org	0x6c10

		ldi	r18,0
		api_getarray			;get array address to Y

bench_01:	push	r18
		mov	XL,r18
		api_setvmode
		api_clrscr
		api_sync
		rcall	testloop
		pop	r18
		api_getarray
		mov	tempreg1,r18
		lsl	tempreg1
		add	YL,tempreg1
		adc	YH,const_0
		st	Y+,XH
		st	Y+,XL
		inc	r18
		cpi	r18,8
		brne	bench_01
		clr	XL
		api_setvmode
		api_fast			;turn off
		rcall	testloop
		api_getarray
		ldi	tempreg1,8
		lsl	tempreg1
		add	YL,tempreg1
		adc	YH,const_0
		st	Y+,XH
		st	Y+,XL
		api_slow
		api_clrscr
		api_thistext
		.db 0,4," Benchmark V1.0 ",0,0
		api_thistext
		.db 1,4,"----------------",0,0
		api_newline
		api_getarray			;get array address to Y
		ldi	r18,0
bench_02:	push	r18
		api_thistext
		.db 255,"Video-Mode",0
		mov	tempreg1,r18
		subi	tempreg1,0xd0
		api_outchar
		api_thistext
		.db 255," : ",0,0
		ld	XH,Y+
		ld	XL,Y+
		ldi	ctrl,0x2a
		api_outdez
		api_thistext
		.db 255," MHz",0
		api_newline
		pop	r18
		inc	r18
		cpi	r18,8
		brne	bench_02
		api_thistext
		.db 255,"Video OFF   : ",0
		ld	XH,Y+
		ld	XL,Y+
		ldi	ctrl,0x2a
		api_outdez
		api_thistext
		.db 255," MHz",0
		api_newline
		api_waitkey
		ret


testloop:	ldi	XL,0				;1 set counter to zero
		ldi	XH,0				;1
		lds	tempreg1,libmio_time_l		;2 get counter
testloop_1:	lds	tempreg2,libmio_time_l		;2
		cp	tempreg1,tempreg2		;1
		breq	testloop_1			;1/2 branch if not changed

testloop_2:	lds	tempreg1,libmio_time_l		;2 get data
		cp	tempreg1,tempreg2		;1 changed?
		brne	testloop_e			;1/2 branch if yes
		ldi	tempreg1,248			;1 248 cycles
testloop_3:	nop					;1 filling
		dec	tempreg1			;1
		brne	testloop_3			;2
		adiw	XL,1				;2
		nop
		nop
		rjmp	testloop_2			;2

testloop_e:	ret