;################################################################################
;#										#
;# RTC demo LIB for ChipBasic2							#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.CSEG
.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.org	0x6600
;--------------------++++++++++++N
		.db "Extens ion  N",0xf4,0xf7,0x1f	;green, library with BASIC extension
		.db 0x07,0x03,0x03,0x0b
		.db "XRTC"
		.db 0x0d,0x0c,0x0c,0x0e
;dummy Funktion
.ORG	0x6610
		rjmp	rtc_start			;BAS extension

rtc_start:
		ldi	ctrl,0
		movw	YL,ZL
		ldi	ZL,LOW(rtc_ctab*2)
		ldi	ZH,HIGH(rtc_ctab*2)
		ldi	tempreg3,9
		api_tparser
		movw	r14,YL
		cpi	tempreg1,0
		breq	rtc_nok
		cpi	tempreg1,1		;set sec
		brne	rtc_sel_2
		rjmp	rtc_ssec
rtc_sel_2:	cpi	tempreg1,2		;set min
		brne	rtc_sel_3
		rjmp	rtc_smin
rtc_sel_3:	cpi	tempreg1,3		;set hour
		brne	rtc_sel_4
		rjmp	rtc_shour
rtc_sel_4:	cpi	tempreg1,4		;set day
		brne	rtc_sel_5
		rjmp	rtc_sday
rtc_sel_5:	cpi	tempreg1,5		;set month
		brne	rtc_sel_6
		rjmp	rtc_smonth
rtc_sel_6:	cpi	tempreg1,6		;set year
		brne	rtc_sel_7
		rjmp	rtc_syear

rtc_sel_7:	cpi	tempreg1,7		;set sec
		brne	rtc_sel_8
		rjmp	rtc_gsec
rtc_sel_8:	cpi	tempreg1,8		;set min
		brne	rtc_sel_9
		rjmp	rtc_gmin
rtc_sel_9:	cpi	tempreg1,9		;set hour
		brne	rtc_sel_a
		rjmp	rtc_ghour
rtc_sel_a:	cpi	tempreg1,10		;set day
		brne	rtc_sel_b
		rjmp	rtc_gday
rtc_sel_b:	cpi	tempreg1,11		;set month
		brne	rtc_sel_c
		rjmp	rtc_gmonth
rtc_sel_c:	cpi	tempreg1,12		;set year
		brne	rtc_sel_d
		rjmp	rtc_gyear
rtc_sel_d:	ret

rtc_ok:		clr	ereg
		ret

rtc_nok:		ldi	ereg,8
		ret

rtc_gsec:	api_basgetvar
		ldi	XL,0x01
		ldi	XH,0x00
		st	Y+,XL
		st	Y+,XH
		rjmp	rtc_ok

rtc_gmin:	api_basgetvar
		ldi	XL,0x02
		ldi	XH,0x00
		st	Y+,XL
		st	Y+,XH
		rjmp	rtc_ok

rtc_ghour:	api_basgetvar
		ldi	XL,0x03
		ldi	XH,0x00
		st	Y+,XL
		st	Y+,XH
		rjmp	rtc_ok

rtc_gday:	api_basgetvar
		ldi	XL,0x04
		ldi	XH,0x00
		st	Y+,XL
		st	Y+,XH
		rjmp	rtc_ok

rtc_gmonth:	api_basgetvar
		ldi	XL,0x05
		ldi	XH,0x00
		st	Y+,XL
		st	Y+,XH
		rjmp	rtc_ok

rtc_gyear:	api_basgetvar
		ldi	XL,0x06
		ldi	XH,0x00
		st	Y+,XL
		st	Y+,XH
		rjmp	rtc_ok

rtc_over:	ldi	ereg,2			;overflow
		ret

rtc_ssec:	rcall	rtc_value
		cpi	XL,60
		brcc	rtc_over
		
		ret

rtc_smin:	rcall	rtc_value
		cpi	XL,60
		brcc	rtc_over
		
		ret

rtc_shour:	rcall	rtc_value
		cpi	XL,24
		brcc	rtc_over
		
		ret

rtc_sday:	rcall	rtc_value
		cpi	XL,0
		breq	rtc_over
		cpi	XL,32
		brcc	rtc_over
		
		ret


rtc_smonth:	rcall	rtc_value
		cpi	XL,0
		breq	rtc_over
		cpi	XL,13
		brcc	rtc_over
		
		ret


rtc_syear:	rcall	rtc_value
		cpi	XL,100
		brcc	rtc_over

		ret



rtc_value:	ldi	XL,1
		ldi	XH,0
		api_basgetpar
		cpi	ereg,0
		brne	rtc_value_e
		cpi	XL,1
		brcc	rtc_value_1
		pop	ereg			;kill stack
		pop	ereg
		ldi	ereg,19
		ret
rtc_value_1:	api_getpartab
		ld	XL,Y
rtc_value_e:	ret


.ORG	0x6b80
rtc_ctab:	.db	0x01,"SETSEC..."
		.db	0x02,"SETMIN..."
		.db	0x03,"SETHOUR.."
		.db	0x04,"SETDAY..."
		.db	0x05,"SETMONTH."
		.db	0x06,"SETYEAR.."
		.db	0x07,"GETSEC..."
		.db	0x08,"GETMIN..."
		.db	0x09,"GETHOUR.."
		.db	0x0a,"GETDAY..."
		.db	0x0b,"GETMONTH."
		.db	0x0c,"GETYEAR.."
		.db	0x00,"........."


