;################################################################################
;#										#
;# Measure library for ChipBasic2						#
;# copyright (c) 2010-2011 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.CSEG
.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.org	0x7200
;--------------------++++++++++++N
start:		.db " Meas-lib-04N",0xd4,0xff,0x12
;icon
		.db 0xf2,0xf1,0xf1,0xf3
		.db 0xf0,0xcc,0xcd,0xf0
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x7210
		rjmp	retzero			;dummy for autostart
		rjmp	rmeas1			;FKT 1 meas Un and Ux with PORTA.1 active
		rjmp	rmeas2			;FKT 2 meas Un and Ux with PORTA.2 active
		rjmp	rmeas3			;FKT 3 meas Un and Ux with PORTA.3 active

		rjmp	cmeas1			;FKT 4 C-measurement with PORTA.3  active (fast)
		rjmp	cmeas2			;FKT 5 C-measurement with PORTA.3  active (medium)
		rjmp	cmeas3			;FKT 6 C-measurement with PORTA.2  active (medium)
		rjmp	cmeas4			;FKT 7 C-measurement with PORTA.2  active (slow)

		rjmp	lmeas1			;FKT 8 L-measurement with PORTA.1  active (fast)
		rjmp	lmeas2			;FKT 9 L-measurement with PORTA.1  active (medium)
		rjmp	lmeas3			;FKT 10 L-measurement with PORTA.2  active (medium)
		rjmp	lmeas4			;FKT 11 L-measurement with PORTA.3  active (medium)


retzero:	clr	XL
		clr	XH
		rjmp	retvalue

mlib_dummy:	ldi	XL,0xff
		ldi	XH,0xff

retvalue:	api_getvalues
		st	Y,XL
		std	Y+1,XH
		ret				;dummy function

;-------------------------------------------------------------------------------
; C measure with PORTA.3 as source (method A)
;-------------------------------------------------------------------------------
cmeas1:		rcall	enacomp			;enable comparator
		ldi	YH,0x08
		rcall	setport
		api_sync
		api_sync

		clr	tempreg2		;reset value
		clr	tempreg3

		ldi	tempreg1,16		;no of measures

cmeas1_wait:	mov	XL,vline_l		;wait for line 250
		cpi	XL,250
		brne	cmeas1_wait

		cli				;1 disable INT
		sbi	PORTA,3			;2 33K ein
		clr	XL			;1
		ldi	XH,200			;1
		nop				;1
		nop				;1
		nop
cmeas1_loop:	in	r16,ACSR		;1 ACSR
		sbrc	r16,5			;1/2 skip if >1,1V
		inc	XL			;1
		dec	XH			;1
		brne	cmeas1_loop		;1
		cbi	PORTA,3			;2 aus
		sei

		add	tempreg2,XL		;add result
		adc	tempreg3,const_0

		dec	tempreg1		;loop counter
		brne	cmeas1_wait		;do loop

		rjmp	cmeas3_end

;-------------------------------------------------------------------------------
; C measure with PORTA.3 as source (method B)
;-------------------------------------------------------------------------------
cmeas2:	rcall	enacomp				;enable comparator
		ldi	YH,0x0a			;33K + discharge
		rcall	setport
		api_sync
		api_sync

		clr	tempreg2		;reset value
		clr	tempreg3
		clr	tempreg4

		ldi	tempreg1,16		;no of measures

cmeas2_iloop:	api_sync
		api_sync
cmeas2_wait:	mov	XL,vline_l		;wait for line 130
		cpi	XL,130
		brne	cmeas2_wait

		cli				;1 disable INT
		cbi	DDRA,1			;1 discharge off
		sbi	PORTA,3			;2 set 33K to vcc
		clr	XL			;1
		clr	XH			;1
		ldi	YL,LOW(12800)		;1
		ldi	YH,HIGH(12800)		;1
		out	PORTC,const_0		;1 border off
		nop				;1 filling
		nop
		nop
		nop
cmeas2_loop:	in	r16,0x30		;1 ACSR
		sbrc	r16,5			;1/2 skip if >1,1V
		adiw	XL,1			;2
		sbrs	r16,5			;1/2
		rjmp	cmeas2_loop2		;2
cmeas2_loop1:	sbiw	YL,1			;2
		brne	cmeas2_loop		;2
		rjmp	cmeas2_loop3
cmeas2_loop2:	sbiw	YL,1			;2
		nop
		nop
		nop
		nop
		nop
		nop
		brne	cmeas2_loop2

cmeas2_loop3:	cbi	PORTA,3			;2 aus
		sbi	DDRA,1			;1 discharge
		ldi	YL,100
		add	vline_l,YL		;correct line counter
		sei

		add	tempreg2,XL
		adc	tempreg3,XH
		adc	tempreg4,const_0

		dec	tempreg1		;loop counter
		brne	cmeas2_iloop		;do loop

		rjmp	cmeas3_calc

;-------------------------------------------------------------------------------
; C measure with PORTA.2 as source (method B)
;-------------------------------------------------------------------------------
cmeas3:	rcall	enacomp				;enable comparator
		ldi	YH,0x06			;1K + discharge
		rcall	setport
		api_sync
		api_sync

		clr	tempreg2		;reset value
		clr	tempreg3
		clr	tempreg4

		ldi	tempreg1,16		;no of measures
cmeas3_iloop:	api_sync
cmeas3_wait:	mov	XL,vline_l		;wait for line 130
		cpi	XL,130
		brne	cmeas3_wait

		cli				;1 disable INT
		cbi	DDRA,1			;1 discharge off
		sbi	PORTA,2			;2 1K to vcc
		clr	XL			;1
		clr	XH			;1
		ldi	YL,LOW(12800)		;1
		ldi	YH,HIGH(12800)		;1
		out	PORTC,const_0		;1 border off
		nop				;1 filling
		nop
		nop
		nop
cmeas3_loop:	in	r16,0x30		;1 ACSR
		sbrc	r16,5			;1/2 skip if >1,1V
		adiw	XL,1			;2
		sbrs	r16,5			;1/2
		rjmp	cmeas3_loop1		;2
cmeas3_loop1:	sbiw	YL,1			;2
		brne	cmeas3_loop		;2
		cbi	PORTA,2			;2 1K off
		sbi	DDRA,1			;1 discharge

		ldi	YL,100
		add	vline_l,YL		;correct line counter
		sei
		add	tempreg2,XL
		adc	tempreg3,XH
		adc	tempreg4,const_0
		dec	tempreg1		;loop counter
		brne	cmeas3_iloop		;do loop

cmeas3_calc:	ldi	tempreg1,3
cmeas3_calc1:	lsr	tempreg4		;shift right
		ror	tempreg3
		ror	tempreg2
		dec	tempreg1		;loop counter
		brne	cmeas3_calc1		;do loop

cmeas3_end:	lds	YL,ADCSRB
		andi	YL,0xbf			;no use ADMUX
		sts	ADCSRB,YL
		ldi	YL,0xc6			;re-enable ADC
		sts	ADCSRA,YL

		mov	XL,tempreg2
		mov	XH,tempreg3
		rjmp	retvalue

;-------------------------------------------------------------------------------
; C measure with PORTA.2 as source (method C)
;-------------------------------------------------------------------------------
cmeas4:		rcall	enacomp			;enable comparator
		ldi	YH,0x06
		rcall	setport
		api_sync
		api_sync

		clr	tempreg2		;reset value
		clr	tempreg3
	
		ldi	tempreg1,2

cmeas4_wait:	mov	XL,vline_l		;wait for line 130
		cpi	XL,130
		brne	cmeas4_wait

		cbi	DDRA,1			;discharge off
		ldi	YH,130
		sbi	PORTA,2			;2 1K
		ldi	ZL,1
		ldi	ZH,0
		ldi	XL,0x00			;
		ldi	XH,0x10			;4096 max

cmeas4_loop:	mov	YL,vline_l		;wait for next line
		cp	YL,YH
		breq	cmeas4_loop
		mov	YH,YL

cmeas4_loop1:	in	r16,0x30		;1 ACSR
		sbrc	r16,5			;1/2 skip if >1,1V
		adiw	ZL,1			;2
cmeas4_loop2:	sbiw	XL,1			;2
		brne	cmeas4_loop		;2
		cbi	PORTA,2			;2 1K off
		sbi	DDRA,1			;discharge

		add	tempreg2,ZL
		adc	tempreg3,ZH
		api_sync
		api_sync
		dec	tempreg1		;loop counter
		brne	cmeas4_wait		;do loop

		rjmp	cmeas3_end

;-------------------------------------------------------------------------------
; L measure with PORTA.1 as source (method A)
;-------------------------------------------------------------------------------
lmeas1:		rcall	enacomp
		ldi	YH,0x02
		rcall	setport
		api_sync
		api_sync

		clr	tempreg2		;reset value
		clr	tempreg3

		ldi	tempreg1,16		;no of measures

lmeas1_wait:	mov	XL,vline_l		;wait for line 130
		cpi	XL,250
		brne	lmeas1_wait

		cli				;1 disable INT
		sbi	PORTA,1			;2 0K ein
		clr	XL			;1
		ldi	XH,200			;1
		nop				;1
		nop				;1
		out	PORTC,const_0		;1 border off
lmeas1_loop:	in	r16,0x30		;1 ACSR
		sbrs	r16,5			;1/2 skip if <1,1V
		inc	XL			;1
		dec	XH			;1
		brne	lmeas1_loop		;1
		cbi	PORTA,1			;2 aus
		sei

		add	tempreg2,XL		;add result
		adc	tempreg3,const_0

		dec	tempreg1		;loop counter
		brne	lmeas1_wait		;do loop

		rjmp	cmeas3_end

;-------------------------------------------------------------------------------
; L measure with PORTA.1 as source (method B)
;-------------------------------------------------------------------------------
lmeas2:	rcall	enacomp
		ldi	YH,0x02
		rcall	setport
		api_sync
		api_sync

		clr	tempreg2		;reset value
		clr	tempreg3
		clr	tempreg4

		ldi	tempreg1,16		;no of measures

lmeas2_wait:	mov	XL,vline_l		;wait for line 130
		cpi	XL,130
		brne	lmeas2_wait

		cli				;1 disable INT
		sbi	PORTA,1			;2 0K ein
		clr	XL			;1
		clr	XH			;1
		ldi	YL,LOW(12800)		;1
		ldi	YH,HIGH(12800)		;1
		out	PORTC,const_0		;1 border off
		nop				;1 filling
		nop
		nop
		nop
lmeas2_loop:	in	r16,0x30		;1 ACSR
		sbrs	r16,5			;1/2 skip if <1,1V
		adiw	XL,1			;2
		sbrc	r16,5			;1/2
		rjmp	lmeas2_loop1		;2
lmeas2_loop1:	sbiw	YL,1			;2
		brne	lmeas2_loop		;2
		cbi	PORTA,1			;2 aus
		ldi	YL,100
		add	vline_l,YL		;correct line counter
		sei

		add	tempreg2,XL
		adc	tempreg3,XH
		adc	tempreg4,const_0
		dec	tempreg1		;loop counter
		brne	lmeas2_wait		;do loop

		rjmp	cmeas3_calc

;-------------------------------------------------------------------------------
; L measure with PORTA.2 as source (method B)
;-------------------------------------------------------------------------------
lmeas3:	rcall	enacomp
		ldi	YH,0x04
		rcall	setport
		api_sync
		api_sync

		clr	tempreg2		;reset value
		clr	tempreg3
		clr	tempreg4

		ldi	tempreg1,16		;no of measures

lmeas3_wait:	mov	XL,vline_l		;wait for line 130
		cpi	XL,130
		brne	lmeas3_wait

		cli				;1 disable INT
		sbi	PORTA,2			;2 1K ein
		clr	XL			;1
		clr	XH			;1
		ldi	YL,LOW(12800)		;1
		ldi	YH,HIGH(12800)		;1
		out	PORTC,const_0		;1 border off
		nop				;1 filling
		nop
		nop
		nop
lmeas3_loop:	in	r16,0x30		;1 ACSR
		sbrs	r16,5			;1/2 skip if <1,1V
		adiw	XL,1			;2
		sbrc	r16,5			;1/2
		rjmp	lmeas3_loop1		;2
lmeas3_loop1:	sbiw	YL,1			;2
		brne	lmeas3_loop		;2
		cbi	PORTA,2			;2 1K aus

		ldi	YL,100
		add	vline_l,YL		;correct line counter
		sei
		add	tempreg2,XL
		adc	tempreg3,XH
		adc	tempreg4,const_0
		dec	tempreg1		;loop counter
		brne	lmeas3_wait		;do loop

		rjmp	cmeas3_calc


;-------------------------------------------------------------------------------
; L measure with PORTA.3 as source (method B)
;-------------------------------------------------------------------------------
lmeas4:		rcall	enacomp
		ldi	YH,0x08
		rcall	setport
		api_sync
		api_sync

		clr	tempreg2		;reset value
		clr	tempreg3
		clr	tempreg4

		ldi	tempreg1,16		;no of measures

lmeas4_wait:	mov	XL,vline_l		;wait for line 130
		cpi	XL,130
		brne	lmeas4_wait

		cli				;1 disable INT
		sbi	PORTA,3			;2 33K ein
		clr	XL			;1
		clr	XH			;1
		ldi	YL,LOW(12800)		;1
		ldi	YH,HIGH(12800)		;1
		out	PORTC,const_0		;1 border off
		nop				;1 filling
		nop
		nop
		nop
lmeas4_loop:	in	r16,0x30		;1 ACSR
		sbrs	r16,5			;1/2 skip if <1,1V
		adiw	XL,1			;2
		sbrs	r16,5			;1/2
		rjmp	lmeas4_loop1		;2
lmeas4_loop1:	sbiw	YL,1			;2
		brne	lmeas4_loop		;2
		cbi	PORTA,3			;2 33K aus

		ldi	YL,100
		add	vline_l,YL		;correct line counter
		sei
		add	tempreg2,XL
		adc	tempreg3,XH
		adc	tempreg4,const_0
		dec	tempreg1		;loop counter
		brne	lmeas4_wait		;do loop

		rjmp	cmeas3_calc


;-------------------------------------------------------------------------------
; R measure with PORTA.3 as source
;-------------------------------------------------------------------------------
rmeas3:		ldi	YH,0x08
		rcall	setport
		sbi	PORTA,3
		api_sync
		ldi	tempreg2,3
		rcall	vmeas32			;meas U(PA3)
		api_getarray
		st	Y,XL
		std	Y+1,XH

		ldi	tempreg2,0
		rcall	vmeas32			;meas U(PA0)
		cbi	PORTA,3
		rjmp	retvalue

;-------------------------------------------------------------------------------
; R measure with PORTA.2 as source
;-------------------------------------------------------------------------------
rmeas2:		ldi	YH,0x04
		rcall	setport
		sbi	PORTA,2
		api_sync
		ldi	tempreg2,2
		rcall	vmeas32			;meas U(PA2)
		api_getarray
		st	Y,XL
		std	Y+1,XH

		ldi	tempreg2,0
		rcall	vmeas32			;meas U(PA0)
		cbi	PORTA,2
		rjmp	retvalue

;-------------------------------------------------------------------------------
; R measure with PORTA.1 as source
;-------------------------------------------------------------------------------
rmeas1:		ldi	YH,0x02
		rcall	setport
		sbi	PORTA,1
		api_sync
		ldi	tempreg2,1
		rcall	vmeas32			;meas U(PA1)
		api_getarray
		st	Y,XL
		std	Y+1,XH

		ldi	tempreg2,0
		rcall	vmeas32			;meas U(PA0)
		cbi	PORTA,1
		rjmp	retvalue


;-------------------------------------------------------------------------------
; disable ADC and enable AC on channel 0 with bandgap as reference
;-------------------------------------------------------------------------------
enacomp:	ldi	XL,0x00			;ADC off
		sts	ADCSRA,XL
		ldi	XL,0x40			;Bandgap as ref
		out	ACSR,XL
		lds	XL,ADCSRB
		ori	XL,0x40			;use ADMUX
		sts	ADCSRB,XL
		ldi	XL,0x00			;set ADMUX
		sts	ADMUX,XL
		ret

;-------------------------------------------------------------------------------
; configure PORTA 0-3
;-------------------------------------------------------------------------------
setport:	in	YL,PORTA
		andi	YL,0xf0
		out	PORTA,YL
		in	YL,DDRA
		andi	YL,0xf0
		or	YL,YH
		out	DDRA,YL
		ret

;-------------------------------------------------------------------------------
; meas voltage at given channel (tempreg2=channel) 32x into X
;-------------------------------------------------------------------------------
vmeas32:	clr	XL			;set result to zero
		clr	XH
		ldi	YL,0x86			;enable ADC
		sts	ADCSRA,YL
		ldi	YL,0x40			;channel 0
		add	YL,tempreg2		;add channel no
		sts	ADMUX,YL
		lds	YL,ADCSRA
		ori	YL,0x40			;set ADSC for dummy measure
		sts	ADCSRA,YL
vmeas32_1:	lds	YL,ADCSRA
		sbrc	YL,6
		rjmp	vmeas32_1
		lds	YL,ADCL
		lds	YL,ADCH
		ldi	tempreg1,32		;no of cumulated measures
vmeas32_2:	sleep				;wait for next int
		lds	YL,ADCSRA
		ori	YL,0x40			;set ADSC for measure
		sts	ADCSRA,YL
vmeas32_3:	lds	YL,ADCSRA
		sbrc	YL,6
		rjmp	vmeas32_3
		lds	YL,ADCL
		add	XL,YL
		lds	YL,ADCH
		adc	XH,YL
		dec	tempreg1
		brne	vmeas32_2
		ret
