;################################################################################
;#										#
;# FIXLIB - fixpoint math routines for ChipBasic2				#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; copy value
;-------------------------------------------------------------------------------
mlib_copy:	rcall	getvar2
mlib_copy_i:	lds	r16,sys_varsize
mlib_copy_1:	rjmp	mlib_abs_2

;-------------------------------------------------------------------------------
; absolute value
;-------------------------------------------------------------------------------
mlib_abs:	rcall	getvar2			;get var adr to Y,Z
mlib_abs_i:	ld	tempreg2,Y+
		st	Z+,const_0
mlib_abs_1:	lds	r16,sys_varsize
		dec	r16
mlib_abs_2:	ld	tempreg2,Y+
		st	Z+,tempreg2
		dec	r16
		brne	mlib_abs_2
		rjmp	retzero

;-------------------------------------------------------------------------------
; invert value
;-------------------------------------------------------------------------------
mlib_inv:	rcall	getvar2			;get var adr to Y,Z
mlib_inv_i:	ld	tempreg2,Y+
		eor	tempreg2,const_1
		st	Z+,tempreg2
		rjmp	mlib_abs_1

;-------------------------------------------------------------------------------
; integer value
;-------------------------------------------------------------------------------
mlib_int:	rcall	getvar2			;get var adr to Y,Z
mlib_int_i:	lds	r16,sys_vk
		inc	r16
mlib_int_1:	ld	tempreg2,Y+		;copy pre comma byte
		st	Z+,tempreg2
		dec	r16
		brne	mlib_int_1
		lds	r16,sys_nk
mlib_int_2:	cpi	r16,0
		breq	mlib_int_3
		st	Z+,const_0		;clear post comma byte
		dec	r16
		rjmp	mlib_int_2

mlib_int_3:	rjmp	retzero

;-------------------------------------------------------------------------------
; fractional value
;-------------------------------------------------------------------------------
mlib_frac:	rcall	getvar2			;get var adr to Y,Z
mlib_frac_i:	ld	tempreg2,Y+		;copy sign byte
		st	Z+,tempreg2
		lds	r16,sys_vk
		add	YL,r16
		adc	YH,const_0
mlib_frac_1:	st	Z+,const_0		;clear pre comma byte
		dec	r16
		brne	mlib_frac_1
		lds	r16,sys_nk
mlib_frac_2:	cpi	r16,0
		breq	mlib_int_3
		ld	tempreg2,Y+		;copy post comma byte
		st	Z+,tempreg2
		dec	r16
		rjmp	mlib_frac_2

;-------------------------------------------------------------------------------
; div value by 2
;-------------------------------------------------------------------------------
mlib_div2:	rcall	getvar2
mlib_div2_i:	lds	r16,sys_varsize
		dec	r16
		clr	r17
		ld	tempreg1,Y+		;copy sign
		st	Z+,tempreg1

mlib_div2_1:	ld	tempreg1,Y+
		sbrc	r17,0
		subi	tempreg1,0x9c
		lsr	tempreg1
		rol	r17
		st	Z+,tempreg1
		dec	r16
		brne	mlib_div2_1
		rjmp	retzero

;-------------------------------------------------------------------------------
; mult value by 2
;-------------------------------------------------------------------------------
mlib_mul2:	rcall	getvar2
mlib_mul2_i:	lds	r16,sys_varsize
		add	YL,r16
		adc	YH,const_0
		add	ZL,r16
		adc	ZH,const_0
		dec	r16
		clr	r17

mlib_mul2_1:	ld	tempreg1,-Y
		subi	tempreg1,0xb2		;+78
		lsr	r17			;shift out carry
		adc	tempreg1,tempreg1	;*2 + carry
		rol	r17
		sbrs	r17,0			;skip if carry
		subi	tempreg1,0x9c		;-156
		st	-Z,tempreg1
		dec	r16
		brne	mlib_mul2_1

		ld	tempreg1,-Y		;copy sign
		st	-Z,tempreg1
		rjmp	retzero
