;################################################################################
;#										#
;# FIXLIB - fixpoint math routines for ChipBasic2				#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; scripting engine
;-------------------------------------------------------------------------------
mlib_script:	api_getvalues
		ldd	tempreg3,Y+2		;array offset
		andi	tempreg3,0xfe		;clear bit 0
		ldi	XL,LOW(sys_sptr)
		ldi	XH,HIGH(sys_sptr)
		st	X+,const_0		;skip flag
		st	X+,tempreg3		;pointer
		ldd	tempreg1,Y+4		;par2
		st	X+,tempreg1		;C1
		ldd	tempreg1,Y+6		;par2
		st	X+,tempreg1		;C2
		ldd	tempreg1,Y+8		;par3
		st	X+,tempreg1		;C3
		st	X+,const_0		;C4


;now start the loop
mlib_script_02:	api_kflags			;run
		sbrc	tempreg1,0		;skip if no break flag
		rjmp	retzero
		sbrc	tempreg1,2		;skip if no monitor flag
		rjmp	retzero

		ldi	YL,LOW(bas_array)	;scripts will only work in array cells 0...255
		ldi	YH,HIGH(bas_array)
		lds	tempreg3,sys_sptr	;get script pointer
		lds	tempreg4,sys_skipflag
		sbrs	tempreg4,0
		rjmp	mlib_script_03		;no skip
		sts	sys_skipflag,const_0	;clear skip flag
		subi	tempreg3,0xfe		;ptr+2
mlib_script_03:	add	YL,tempreg3		;now calc array position
		adc	YH,const_0
		ld	tempreg1,Y+		;get first byte
		ld	tempreg2,Y+		;get second byte
		mov	r16,tempreg2		;copy this
		subi	tempreg3,0xfe		;ptr+2
		sts	sys_sptr,tempreg3	;store back script pointer

;exit with variable
		cpi	tempreg1,0x00		;return variable?
		brne	mlib_script_04
		andi	r16,0x0f
		rcall	getvar1_i		;set ptr
		rjmp	outint_i

;exit with counter
mlib_script_04:	cpi	tempreg1,0x01		;return counter?
		brne	mlib_script_06
		rcall	getcptr
		ld	XL,Y
		clr	XH
		rjmp	retvalue
;branch
mlib_script_06:	cpi	tempreg1,0x02		;branch?
		brne	mlib_script_08
		lsl	tempreg2
		add	tempreg3,tempreg2
		sts	sys_sptr,tempreg3
		rjmp	mlib_script_02		;goto main loop
;set from constant
mlib_script_08:	cpi	tempreg1,0x03		;set from const?
		brne	mlib_script_10
		mov	XL,r16
		swap	XL
		andi	r16,0x0f
		rcall	getvar1_i		;set ptr
		rcall	mlib_const_i
		rjmp	mlib_script_02		;goto main loop
;set from par1
mlib_script_10:	cpi	tempreg1,0x04		;set from par1?
		brne	mlib_script_12
		api_getvalues
mlib_script_11:	ldd	XL,Y+4
		ldd	XH,Y+5
		rcall	getvar1_i
		rcall	setint_i
		rjmp	mlib_script_02		;goto main loop
;set from par2
mlib_script_12:	cpi	tempreg1,0x05		;set from par2?
		brne	mlib_script_20
		api_getvalues
		adiw	YL,2
		rjmp	mlib_script_11

;set from par3
mlib_script_14:	cpi	tempreg1,0x06		;set from par3?
		brne	mlib_script_20
		api_getvalues
		adiw	YL,4
		rjmp	mlib_script_11


mlib_script_20:	cpi	tempreg1,0x20		;1x for 2 var op
		brcc	mlib_script_30
		swap	r16
		andi	r16,0x0f
		mov	r17,tempreg2
		andi	r17,0x0f
		rcall	getvar2_i
		rcall	mlib_doop2
		rjmp	mlib_script_02		;goto main loop

mlib_script_30:	cpi	tempreg1,0x80		;4x-7x for 2 var op
		brcc	mlib_script_50
		mov	r16,tempreg1
		andi	r16,0x0f
		mov	r17,tempreg2
		swap	r17
		andi	r17,0x0f
		mov	r18,tempreg2
		andi	r18,0x0f
		rcall	getvar3_i
		rcall	mlib_doop3
		rjmp	mlib_script_02		;goto main loop

mlib_script_50:	mov	r16,tempreg1
		rcall	getcptr
		ld	tempreg3,Y
		andi	tempreg1,0xf0

mlib_script_52:	cpi	tempreg1,0x80
		brne	mlib_script_54
		st	Y,tempreg2		;set counter
		rjmp	mlib_script_02		;goto main loop

mlib_script_54:	cpi	tempreg1,0x90
		brne	mlib_script_56
		add	tempreg3,tempreg2
		st	Y,tempreg3		;set counter
mlib_script_55:	rjmp	mlib_script_02		;goto main loop
;SEQ
mlib_script_56:	cpi	tempreg1,0xa0
		brne	mlib_script_58
		cp	tempreg3,tempreg2
		brne	mlib_script_55
mlib_script_57:	sts	sys_skipflag,const_1	;skip next OP
		rjmp	mlib_script_02		;goto main loop
;SNE
mlib_script_58:	cpi	tempreg1,0xb0
		brne	mlib_script_60
		cp	tempreg3,tempreg2
		breq	mlib_script_55
		rjmp	mlib_script_57

mlib_script_60:	cpi	tempreg1,0xc0
		brne	mlib_script_64
		movw	ZL,YL			;pointer
		api_getvalues
		andi	tempreg2,0x03
		lsl	tempreg2
		add	YL,tempreg2
		adc	YH,const_0
		ldd	tempreg3,Y+4
		st	Z,tempreg3
		rjmp	mlib_script_02		;goto main loop

mlib_script_64:

;command not found
mlib_script_no:	rjmp	mlib_script_02		;goto mail loop

;-------------------------------------------------------------------------------
; get counter ptr
;-------------------------------------------------------------------------------
getcptr:	andi	r16,0x03
		ldi	YL,LOW(sys_ct1)
		ldi	YH,HIGH(sys_ct1)
		add	YL,r16
		adc	YH,const_0
		ret

;-------------------------------------------------------------------------------
; OP with 2 operands
;-------------------------------------------------------------------------------
mlib_doop2:	cpi	tempreg1,0x10
		brne	mlib_doop2_11
		rjmp	mlib_copy_i
mlib_doop2_11:	cpi	tempreg1,0x11
		brne	mlib_doop2_12
		rjmp	mlib_abs_i
mlib_doop2_12:	cpi	tempreg1,0x12
		brne	mlib_doop2_13
		rjmp	mlib_inv_i
mlib_doop2_13:	cpi	tempreg1,0x13
		brne	mlib_doop2_14
		rjmp	mlib_int_i
mlib_doop2_14:	cpi	tempreg1,0x14
		brne	mlib_doop2_15
		rjmp	mlib_frac_i
mlib_doop2_15:	cpi	tempreg1,0x15
		brne	mlib_doop2_16
		rjmp	mlib_mul2_i
mlib_doop2_16:	cpi	tempreg1,0x16
		brne	mlib_doop2_17
		rjmp	mlib_div2_i
mlib_doop2_17:	rcall	mlib_cmp_i
		cpi	tempreg1,0x18			;SEQ
		brne	mlib_doop2_19
		cpi	XL,0
		breq	mlib_doop2_s
		rjmp	mlib_doop2_e
mlib_doop2_19:	cpi	tempreg1,0x19			;SNE
		brne	mlib_doop2_1a
		cpi	XL,0
		brne	mlib_doop2_s
		rjmp	mlib_doop2_e
mlib_doop2_1a:	cpi	tempreg1,0x1a			;SGT
		brne	mlib_doop2_1b
		cpi	XL,1
		breq	mlib_doop2_s
		rjmp	mlib_doop2_e
mlib_doop2_1b:	cpi	tempreg1,0x1b			;SLT
		brne	mlib_doop2_e
		cpi	XL,2
		breq	mlib_doop2_s
		rjmp	mlib_doop2_e

mlib_doop2_s:	sts	sys_skipflag,const_1		;skip next OP
mlib_doop2_e:	ret

;-------------------------------------------------------------------------------
; OP with 3 operands
;-------------------------------------------------------------------------------
mlib_doop3:	cpi	tempreg1,0x50
		brcc	mlib_doop3_1
		rjmp	mlib_add_i
mlib_doop3_1:	cpi	tempreg1,0x60
		brne	mlib_doop3_2
		rjmp	mlib_sub_i
mlib_doop3_2:	cpi	tempreg1,0x70
		brne	mlib_doop3_3
		rjmp	mlib_mult_i
mlib_doop3_3:	rjmp	mlib_div_i

