;################################################################################
;#										#
;# FIXLIB - fixpoint math routines for ChipBasic2				#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; mult v1 * v2 -> v3
;-------------------------------------------------------------------------------
mlib_mult:	rcall	getvar3
;calc result's sign
mlib_mult_i:	ld	r19,X+			;V1 sign
		ld	r18,Y+			;V2 sign
		eor	r19,r18			;this is the result sign
		st	Z+,r19			;store new sign
		lds	r18,sys_varsize
		dec	r18
		lds	ZL,sys_buf1
		lds	ZH,sys_buf1+1
		movw	tempreg7,ZL		;save ptr

;clear result buffer (buffer 1)
		mov	r19,r18			;vk+nk
		subi	r19,0xfe		;+2 additional bytes
mlib_mult_08:	st	Z+,const_0
		dec	r19
		brne	mlib_mult_08

;now start multiply
		clr	tempreg5		;loop counter for X loop
mlib_mult_10:	ld	tempreg1,X+		;get V1 value
		clr	tempreg6		;loop counter for Y loop
mlib_mult_12:	ld	tempreg2,Y+
		mov	r16,tempreg5		;X position
		add	r16,tempreg6		;Y position
		lds	tempreg4,sys_vk
		sub	r16,tempreg4
		inc	r16			;now we have the offset
		lds	r17,sys_varsize
		inc	r17			;varsize-1 = vk+nk
		cp	r16,r17
		sbrs	r16,7
		brcc	mlib_mult_29		;ignore this

		mul	tempreg1,tempreg2	;V1 * V2
		movw	tempreg3,r0		;save result
		lsl	r0
		rol	r1
		lsl	r0
		rol	r1
		ldi	tempreg2,0xa3
		mul	r1,tempreg2
		ldi	tempreg2,0x9c
		mul	r1,tempreg2
		add	tempreg3,r0
		adc	tempreg4,r1
		cpi	tempreg3,0x64
		brcs	mlib_mult_22
		subi	tempreg3,0x64
		inc	tempreg4
mlib_mult_22:	cpi	tempreg3,0x64
		brcs	mlib_mult_24
		subi	tempreg3,0x64
		inc	tempreg4
;now put tr3/tr4 into result
mlib_mult_24:	sbrs	r16,7			;negative offset?
		rjmp	mlib_mult_30		;not
		cpi	tempreg3,0
		breq	mlib_mult_29
		cpi	tempreg4,0
		breq	mlib_mult_29
mlib_mult_28:	ldi	ereg,2			;overflow
mlib_mult_29:	rjmp	mlib_mult_50		;CONTINUE LOOP

mlib_mult_30:	movw	ZL,tempreg7		;set buf2a base
		add	ZL,r16			;add offset
		adc	ZH,const_0

		cpi	r16,0x00		;offset=0?
		brne	mlib_mult_40		;not
		ld	r19,Z			;get data
		add	r19,tempreg3		;add low
		cpi	r19,100
		brcs	mlib_mult_32
		subi	r19,100
		st	Z,r19
		rjmp	mlib_mult_28

mlib_mult_32:	st	Z,r19
		cpi	tempreg4,0
		brne	mlib_mult_28
		rjmp	mlib_mult_50

mlib_mult_40:	ld	r19,Z			;get LOW byte
		add	r19,tempreg3		;add LOW
		clr	tempreg2		;clear carry
		cpi	r19,100
		brcs	mlib_mult_42
		subi	r19,100
		ldi	tempreg2,1
mlib_mult_42:	st	Z,r19

		ld	r19,-Z			;get HIGH byte
		lsr	tempreg2
		adc	r19,tempreg4
		cpi	r19,100
		brcs	mlib_mult_43
		subi	r19,100
		ldi	tempreg2,1
mlib_mult_43:	st	Z,r19
		subi	r16,2

mlib_mult_44:	sbrc	r16,7
		rjmp	mlib_mult_48		;all done
		sbrs	tempreg2,0
		rjmp	mlib_mult_50		;all done
		ld	r19,-Z			;get byte
		add	r19,tempreg2
		clr	tempreg2
		cpi	r19,100
		brcs	mlib_mult_46
		subi	r19,100
		ldi	tempreg2,1
		dec	r16
mlib_mult_46:	st	Z,r19
		rjmp	mlib_mult_44

mlib_mult_48:	sbrc	tempreg2,0
		ldi	ereg,2			;overflow

;Y loop
mlib_mult_50:	inc	tempreg6
		lds	tempreg3,sys_varsize
		dec	tempreg3
		cp	tempreg3,tempreg6
		breq	mlib_mult_52
		rjmp	mlib_mult_12

mlib_mult_52:	sub	YL,tempreg3
		sbc	YH,const_0
;X loop
mlib_mult_60:	inc	tempreg5
		cp	tempreg3,tempreg5
		breq	mlib_mult_62
		rjmp	mlib_mult_10

mlib_mult_62:

;now convert result into target register
		rcall	getvar3x		;set ptr to target var
		adiw	XL,1			;sign is already stored
		movw	YL,tempreg7
		lds	r16,sys_varsize
		dec	r16
		
mlib_mult_70:	ld	ZL,Y+
		st	X+,ZL
		dec	r16
		brne	mlib_mult_70
		
		rjmp	retzero

