;################################################################################
;#										#
;# FIXLIB - fixpoint math routines for ChipBasic2				#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; initialize variables
;-------------------------------------------------------------------------------
init:		ldi	YL,LOW(varbase)		;array address
		ldi	YH,HIGH(varbase)	;array address
		ldi	XL,0
init_00:	st	Y+,const_0		;clear array space
		dec	XL
		brne	init_00
		api_getvalues			;get parameters
		ldd	r16,Y+2			;vk
		ldd	r17,Y+4			;nk
		andi	r17,0x07		;limit nk bytes
		andi	r16,0x07		;limit vk bytes
		subi	r16,0xfe		;VK Bytes+2
init_01:	mov	r18,r16
		add	r18,r17			;bytes/var
		dec	r16			;-sign byte
		sts	sys_vk,r16		;VK
		sts	sys_nk,r17		;NK
		sts	sys_varsize,r18		;bytes/VAR
		ldi	XL,0			;0 variables at start of calculation
		ldi	r17,18			;system cells
init_02:	add	r17,r18			;add VAR
		brcs	init_03			;not enough memory
		inc	XL			;variables+1
		rjmp	init_02			;loop
init_03:	subi	XL,3			;used for internal buffers
		sts	sys_maxvar,XL		;maxvar
		mul	r18,XL
		ldi	YL,LOW(varbase)
		ldi	YH,HIGH(varbase)
		add	YL,r0
		adc	YH,r1
		sts	sys_buf1,YL		;buffer 1 address
		sts	sys_buf1+1,YH
		add	YL,r18
		adc	YH,const_0
		sts	sys_buf2,YL		;buffer 2 address
		sts	sys_buf2+1,YH
		add	YL,r18
		adc	YH,const_0
		sts	sys_buf3,YL		;buffer 2 address
		sts	sys_buf3+1,YH
		rjmp	retvalue		;end here

;-------------------------------------------------------------------------------
; get ptr of V1 to Y and additional Values to X,Z
;-------------------------------------------------------------------------------
getvar1:	api_getvalues
		ldd	r16,Y+2			;var (Y)
		ldd	XL,Y+4			;value 1 (if used)
		ldd	XH,Y+5
		ldd	ZL,Y+6			;value 2 (if used)
		ldd	ZH,Y+7
		ldd	r18,Y+12		;number of arguments

getvar1_i:	lds	r19,sys_maxvar
		cp	r16,r19			;limit
		brcc	getvar3_e		;yes->error
		ldi	YL,LOW(varbase)
		ldi	YH,HIGH(varbase)
		lds	r19,sys_varsize
;get ptr to v1
		mul	r16,r19
		add	YL,r0
		adc	YH,r1
		ret

;-------------------------------------------------------------------------------
; get ptr of V1,V2,V3 to X,Y,Z
;-------------------------------------------------------------------------------
getvar3:	api_getvalues
		ldd	r16,Y+2			;var1
		ldd	r17,Y+4			;var2
		ldd	r18,Y+6			;var3

getvar3_i:	lds	r19,sys_maxvar
		cp	r16,r19			;out of array?
		brcc	getvar3_e		;yes->error
		cp	r17,r19			;out of array?
		brcc	getvar3_e		;yes->error
		cp	r18,r19			;out of array?
		brcc	getvar3_e		;yes->error

		ldi	YL,LOW(varbase)
		ldi	YH,HIGH(varbase)
		lds	r19,sys_varsize
		movw	ZL,YL			;copy ptr
		movw	XL,YL
;get ptr to v1
		mul	r16,r19
		add	XL,r0
		adc	XH,r1
;get ptr to v2
		mul	r17,r19
		add	YL,r0
		adc	YH,r1
;get ptr to v3
		mul	r18,r19
		add	ZL,r0
		adc	ZH,r1
		ret

getvar3_e:	pop	r16			;remove TOS
		pop	r16
		ldi	ereg,18			;out of array
		ret				;exit complete

;-------------------------------------------------------------------------------
; get ptr of V1,V2 to Y,Z
;-------------------------------------------------------------------------------
getvar2:	api_getvalues
		ldd	r16,Y+2			;var1
		ldd	r17,Y+4			;var2

getvar2_i:	lds	r19,sys_maxvar
		cp	r16,r19			;out of array?
		brcc	getvar3_e		;yes->error
		cp	r17,r19			;out of array?
		brcc	getvar3_e		;yes->error

		ldi	YL,LOW(varbase)
		ldi	YH,HIGH(varbase)
		lds	r19,sys_varsize
		movw	ZL,YL			;copy ptr
;get ptr to v1
		mul	r16,r19
		add	YL,r0
		adc	YH,r1
;get ptr to v2
		mul	r17,r19
		add	ZL,r0
		adc	ZH,r1
		ret

getvar3x:	api_getvalues
		lds	r19,sys_varsize
		ldd	r18,Y+6			;var3
		ldi	XL,LOW(varbase)
		ldi	XH,HIGH(varbase)
		mul	r18,r19
		add	XL,r0
		adc	XH,r1
		ret
