;################################################################################
;#										#
;# FIXLIB - fixpoint math routines for ChipBasic2				#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; int input
;-------------------------------------------------------------------------------
setint:		rcall	getvar1			;get var adr to Y and value to X
setint_i:	movw	ZL,YL
		lds	r16,sys_varsize
;clear target variable
clearvar_01:	st	Z+,const_0
		dec	r16
		brne	clearvar_01
;store sign
		cpi	XH,0x80			;negative
		brcs	setint_01		;branch if not
		st	Y,const_1		;negative
		api_abs				;we use absolute value

setint_01:	adiw	YL,1			;points to first digit byte
		lsl	XL			;shift out bit 15 which was sign
		rol	XH
		ldi	tempreg1,0		;set result bytes to zero
		ldi	tempreg2,0
		ldi	tempreg3,0
		ldi	r19,15			;bits to do

setint_02:	clr	tempreg4
		lsl	XL			;shift out one Bit
		rol	XH
		rol	tempreg4		;shift into carry byte

		subi	tempreg1,0xb2		;+78
		lsr	tempreg4		;shift out carry
		adc	tempreg1,tempreg1	;*2 + carry
		rol	tempreg4
		sbrs	tempreg4,0		;skip if carry
		subi	tempreg1,0x9c		;-156

		subi	tempreg2,0xb2		;+78
		lsr	tempreg4		;shift out carry
		adc	tempreg2,tempreg2	;*2 + carry
		rol	tempreg4
		sbrs	tempreg4,0		;skip if carry
		subi	tempreg2,0x9c		;-156

		subi	tempreg3,0xb2		;+78
		lsr	tempreg4		;shift out carry
		adc	tempreg3,tempreg3	;*2 + carry
		rol	tempreg4
		sbrs	tempreg4,0		;skip if carry
		subi	tempreg3,0x9c		;-156

		dec	r19			;bit counter
		brne	setint_02		;bit loop

		lds	r16,sys_vk		;precomma bytes
setint_06:	cpi	r16,0x04
		brcs	setint_08
		adiw	YL,1			;leave this as zero
		dec	r16
		rjmp	setint_06
;r16<4
setint_08:	cpi	r16,3			;we have 3 bytes
		breq	setint_10
		cpi	r16,2			;we have 3 bytes
		breq	setint_11
		rjmp	setint_12
setint_10:	st	Y+,tempreg3		;digits 6+5
setint_11:	st	Y+,tempreg2		;digits 4+3
setint_12:	st	Y+,tempreg1		;digits 2+1
setint_20:	rjmp	retzero

shift3l:	ret

;-------------------------------------------------------------------------------
; output register
;-------------------------------------------------------------------------------
outint:		rcall	getvar1			;get var adr to Y and (dummy) value to X
outint_i:	lds	ZL,sys_buf1		;Z points to buffer 1
		lds	ZH,sys_buf1+1
		movw	tempreg7,ZL		;save pointer
;copy var to buffer 1
		lds	tempreg3,sys_varsize
outint_01:	ld	tempreg1,Y+
		st	Z+,tempreg1
		dec	tempreg3
		brne	outint_01
;round buffer value
		ldi	r19,0x00		;round to integer
		rcall	round			;now round buffer 1 value
		movw	YL,tempreg7

		ld	r18,Y+			;get sign
		ldi	tempreg1,0		;set input bytes to zero
		ldi	tempreg2,0
		ldi	tempreg3,0
		clr	XL			;set result to zero
		clr	XH
		
		lds	r16,sys_vk		;precomma bytes
outint_02:	cpi	r16,0x04
		brcs	outint_04
		adiw	YL,1			;ignore this
		dec	r16
		rjmp	outint_02

outint_04:	cpi	r16,3			;we have 3 bytes
		breq	outint_10
		cpi	r16,2			;we have 3 bytes
		breq	outint_11
		rjmp	outint_12
outint_10:	ld	tempreg3,Y+		;digits 6+5
outint_11:	ld	tempreg2,Y+		;digits 4+3
outint_12:	ld	tempreg1,Y+		;digits 2+1

		ldi	r19,15			;bits to do
		ldi	r17,0x33

outint_20:	clr	tempreg4

		lsr	tempreg4
		brcc	outint_20a
		subi	tempreg3,0x9c		;+100
outint_20a:	lsr	tempreg3
		rol	tempreg4

		lsr	tempreg4
		brcc	outint_20b
		subi	tempreg2,0x9c		;+100
outint_20b:	lsr	tempreg2
		rol	tempreg4

		lsr	tempreg4
		brcc	outint_20c
		subi	tempreg1,0x9c		;+100
outint_20c:	lsr	tempreg1
		rol	tempreg4

		lsr	tempreg4
		ror	XH
		ror	XL
		dec	r19
		brne	outint_20
		lsr	XH
		ror	XL
		sbrs	r18,0
		rjmp	outint_22
		com	XL
		com	XH
		adiw	XL,1
outint_22:	rjmp	retvalue

;-------------------------------------------------------------------------------
; round result from Z
; r19=post comma bytes
;-------------------------------------------------------------------------------
round:		lds	r16,sys_varsize
		add	ZL,r16
		adc	ZH,const_0
		dec	r16			;dont use sign byte

		lds	r17,sys_nk		;post comma bytes
		mov	r18,r17			;store
		mov	tempreg1,r19		;post comma round bytes

		cp	r17,tempreg1		;check for minimum
		brcc	round_01		;r18 is minimum
		mov	tempreg1,r17		;set new minimum
	
round_01:	ldi	r17,0x66		;preset constant
		ldi	tempreg2,0		;clear overflow flag
		sub	r18,tempreg1		;r18=bytes to round out

round_02:	ld	tempreg1,-Z		;get byte
		subi	r18,1
		brpl	round_30
		cpi	tempreg2,0		;carry?
		breq	round_20		;no->end

		add	tempreg1,r17		;+0x33
		lsr	tempreg2		;shift out carry
		adc	tempreg1,const_0	;+ carry
		in	tempreg4,SREG
		rol	tempreg2		;shift in carry
		sbrs	tempreg4,5
		subi	tempreg1,0x06
		sbrs	tempreg2,0
		subi	tempreg1,0x60
		st	Z,tempreg1		;store back

round_10:	dec	r16			;loop counter
		brne	round_02
round_20:	ret

round_30:	clr	tempreg2		;carry=0
		cpi	tempreg1,0x50
		brcs	round_32
		inc	tempreg2
round_32:	st	Z,const_0		;set Byte to zero
		dec	r16
		rjmp	round_02

;-------------------------------------------------------------------------------
; print var
; PAR2(XL)= format (optional, required if channel is set)
; bit 7-4 = minimum pre-comma
; bit 3-0 = maximum post-comma
; PAR3(ZL)= channel (optional)
;-------------------------------------------------------------------------------
print:		rcall	getvar1			;get var adr to Y and format values to X
		mov	tempreg4,XL		;copy format
		cpi	r18,3			;3 parameters
		brne	print_01		;no channel setting
		mov	XL,ZL			;set channel
		api_setchannel
print_01:	mov	XL,tempreg4		;restore format
		cpi	r18,2			;2 parameters?
		brcc	print_02		;>=
		ldi	XL,0x0f			;default format, no min pre, max post
print_02:
;convert var to buffer 1
		movw	tempreg5,YL		;copy varptr
		set				;USE SIGN
		ldi	r16,0			;buf 1
		rcall	d100_bcd		;convert to buf1 in BCD format

		mov	tempreg5,XL		;set format

;round buffer value
		lds	ZL,sys_buf1		;Z points to buffer 1
		lds	ZH,sys_buf1+1
		movw	tempreg7,ZL		;save pointer

		mov	r19,tempreg5		;get format
		andi	r19,0x0f		;mask nk bytes
		rcall	round			;now round buffer 1 value
;get sign
		movw	ZL,tempreg7		;restore pointer to buf 1
		ldi	tempreg2,' '		;space as pos sign
		ld	r18,Z+			;get sign byte
		sbrc	r18,0			;skip if positive
		ldi	tempreg2,'-'		;negative

		mov	r19,tempreg5		;get format byte
		swap	r19
		andi	r19,0x0f		;mask vk bytes
		inc	r19			;+1
		lds	r16,sys_vk		;get pre format bytes

;output pre comma before data
print_10:	cp	r16,r19			;need more pre-comma than we have?
		brcc	print_12		;no
		ldi	tempreg1,0x20		;space
		api_outchar			;output
		ldi	tempreg1,0x20		;space
		api_outchar			;output
		dec	r19			;pre-bytes -1
		rjmp	print_10		;loop

print_12:	mov	r18,r16			;copy vk bytes
		sub	r18,r19			;bytes which can ignored if space

print_14:	ldi	r17,0			;no nonzero
		lsl	r16			;digits=bytes*2
		lsl	r18

;the digit output loop
print_20:	subi	r18,1			;dec ignore digits
		sub	r16,const_1		;dec pre comma digits
		brcs	print_30		;all vk done, continue with comma
		brne	printdigit		;branch if not last digit
		mov	tempreg1,tempreg3
		andi	tempreg1,0x0f
		subi	tempreg1,0xd0		;add ascii base
		rjmp	printdigit_4

;get char
printdigit:	sbrc	r16,0
		ld	tempreg3,Z+
		mov	tempreg1,tempreg3
		sbrc	r16,0
		swap	tempreg1
		andi	tempreg1,0x0f
		subi	tempreg1,0xd0		;add ascii base

;tempreg1 is now char to print
		cpi	tempreg1,0x30		;zero
		brne	printdigit_4		;no
		sbrc	r17,0			;skip if nonzero active
		rjmp	printdigit_4		;print digit
		ldi	tempreg1,0x20		;set to space
		sbrc	r18,7			;surpress if we can
		api_outchar
		rjmp	print_20		;loop pre-comma

printdigit_4:	cpi	r17,0			;last was zero
		brne	printdigit_6
		push	tempreg1
		mov	tempreg1,tempreg2	;get sign
		api_outchar
		pop	tempreg1
		ldi	r17,1			;set nonzero flag
printdigit_6:	api_outchar			;print digit
		rjmp	print_20		;loop pre-comma

print_30:	lds	r16,sys_nk
		cpi	r16,0			;no post comma
		breq	print_50		;all done, no post comma digits available
		mov	r19,tempreg5
		andi	r19,0x0f
		breq	print_50		;all done, no post comma digits required

;find last nonzero byte in post comma
print_32:	movw	tempreg7,ZL
		add	ZL,r16
		adc	ZH,const_0
		lsl	r16			;digits=bytes*2
print_34:	ld	tempreg1,-Z		;get byte
		mov	tempreg2,tempreg1	;copy byte
		andi	tempreg1,0x0f
		brne	print_38		;not zero
		dec	r16
		andi	tempreg2,0xf0
		brne	print_38
		dec	r16
		brne	print_34		;next byte

print_38:	cpi	r16,0
		breq	print_50		;post comma digits are all zero

		ldi	tempreg1,'.'		;output comma
		api_outchar
		movw	ZL,tempreg7		;restore pointer

print_40:	cpi	r16,0
		breq	print_50
		ld	tempreg1,Z
		swap	tempreg1
		andi	tempreg1,0x0f
		subi	tempreg1,0xd0		;add ascii base
		api_outchar
		dec	r16
		cpi	r16,0
		breq	print_50
		ld	tempreg1,Z+
		andi	tempreg1,0x0f
		subi	tempreg1,0xd0		;add ascii base
		api_outchar
		dec	r16
		rjmp	print_40
		
print_50:	ldi	XL,0
		api_setchannel
		rjmp	retzero
;-------------------------------------------------------------------------------
; input register
;-------------------------------------------------------------------------------
mlib_input:	rcall	getvar1			;get var adr to Y and array pointer to X
		movw	tempreg5,YL		;save var ptr
		lds	tempreg7,sys_buf1
		lds	tempreg8,sys_buf1+1
		ldi	YL,LOW(bas_array)
		ldi	YH,HIGH(bas_array)
		add	YL,XL			;array pointer
		adc	YH,const_0
		ldi	r17,0x80		;we start with pre comma
;clear buffer
		lds	r16,sys_varsize
		movw	ZL,tempreg7		;get var ptr
mlib_input_01:	st	Z+,const_0
		dec	r16
		brne	mlib_input_01

		lds	r18,sys_vk
		lds	r19,sys_nk
		lsl	r19			;NK digits

;check first char for sign
mlib_input_04:	movw	ZL,tempreg7		;get var ptr
		ld	tempreg1,Y		;get char 
		cpi	tempreg1,'+'
		breq	mlib_input_06		;ignore pos sign
		cpi	tempreg1,'-'
		brne	mlib_input_07
		st	Z,const_1		;set negative sign
mlib_input_06:	adiw	YL,1			;set ptr after sign
mlib_input_07:	adiw	ZL,1			;target ptr+1
		movw	tempreg7,ZL		;set new ptr

mlib_input_08:	ld	tempreg1,Y+		;get char
		sbrs	r17,7
		rjmp	mlib_input_12		;is post comma
		cpi	tempreg1,'.'
		brne	mlib_input_10
		ldi	r17,0x00		;continue with post-comma
		rjmp	mlib_input_08
mlib_input_10:	cpi	tempreg1,','
		brne	mlib_input_12
		ldi	r17,0x00		;continue with post-comma
		rjmp	mlib_input_08
mlib_input_12:	subi	tempreg1,0x30		;sub ascii base
		brcs	mlib_input_e		;no digit
		cpi	tempreg1,0x0a
		brcc	mlib_input_e		;no digit
		sbrc	r17,7			;skip if post
		rcall	pre_ins
		sbrs	r17,7			;skip if pre
		rcall	post_ins
		rjmp	mlib_input_08		;next char

mlib_input_e:	ldi	r16,0			;we use buf 1
		set				;use sign
		rcall	bcd_d100		;convert to d100 format
		rjmp	retzero


pre_ins:	movw	ZL,tempreg7		;get ptr
		lds	tempreg4,sys_vk		;+VK
		add	ZL,tempreg4
		adc	ZH,const_0
pre_ins_01:	ld	tempreg2,-Z
		swap	tempreg2
		mov	tempreg3,tempreg2
		andi	tempreg2,0xf0
		or	tempreg2,tempreg1
		st	Z,tempreg2
		mov	tempreg1,tempreg3
		andi	tempreg1,0x0f
		dec	tempreg4
		brne	pre_ins_01
		ret

post_ins:	cpi	r19,0
		brne	post_ins_01
		ret
post_ins_01:	movw	ZL,tempreg7		;var ptr
		lds	tempreg4,sys_vk		;+VK
		add	ZL,tempreg4
		adc	ZH,const_0
		mov	tempreg3,r17
		lsr	tempreg3
		add	ZL,tempreg3
		adc	ZH,const_0
		sbrs	r17,0
		swap	tempreg1
		ld	tempreg2,Z
		or	tempreg2,tempreg1
		st	Z,tempreg2
		inc	r17
		dec	r19
		ret

;-------------------------------------------------------------------------------
; convert 	tempreg5/6->buf1/2 (r16.0)
;-------------------------------------------------------------------------------
d100_bcd:	api_pushxyz
		lds	YL,sys_buf1		;dest
		lds	YH,sys_buf1+1
		lds	r17,sys_varsize
		mul	r17,r16
		add	YL,r0
		adc	YL,r1
		movw	XL,tempreg5		;source
		ld	r16,X+			;sign
		brtc	d100_bcd_0
d100_bcd_0:	st	Y+,r16
		dec	r17
d100_bcd_1:	ld	ZL,X+			;get b100 byte
		clr	r16			;10s
d100_bcd_2:	cpi	ZL,0x0a
		brcs	d100_bcd_6
		subi	r16,0xf0		;+16
		subi	ZL,0x0a
		rjmp	d100_bcd_2
		
d100_bcd_6:	add	ZL,r16
		st	Y+,ZL
		dec	r17
		brne	d100_bcd_1
		api_popxyz

;-------------------------------------------------------------------------------
; convert 	tempreg5/6<-buf1/2 (r16.0)
;-------------------------------------------------------------------------------
bcd_d100:	api_pushxyz
		lds	YL,sys_buf1		;src
		lds	YH,sys_buf1+1
		lds	r17,sys_varsize
		mul	r17,r16
		add	YL,r0
		adc	YL,r1
		movw	XL,tempreg5		;dest
		ld	r16,Y+			;sign
		brtc	bcd_d100_0
		st	X+,r16
bcd_d100_0:	dec	r17
		ldi	ZH,10
bcd_d100_1:	ld	ZL,Y+
		mov	r16,ZL
		swap	r16
		andi	r16,0x0f
		andi	ZL,0x0f
		mul	r16,ZH
		add	ZL,r0
		st	X+,ZL
		dec	r17
		brne	bcd_d100_1
		api_popxyz

