;################################################################################
;#										#
;# FIXLIB for ChipBasic2							#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

.equ		bas_array	= 0xd3c			;array
.equ		varbase		= 0xe3c			;array+256
.equ		sys_vk		= varbase+255	;
.equ		sys_nk		= varbase+254	;
.equ		sys_varsize	= varbase+253	;
.equ		sys_maxvar	= varbase+252	;
.equ		sys_buf1	= varbase+250	;
.equ		sys_buf2	= varbase+248	;
.equ		sys_buf3	= varbase+246	;
.equ		sys_ct4		= varbase+245	;script counter
.equ		sys_ct3		= varbase+244	;
.equ		sys_ct2		= varbase+243	;
.equ		sys_ct1		= varbase+242	;
.equ		sys_sptr	= varbase+241	; script pointer
.equ		sys_skipflag	= varbase+240	; skip flag for scripting
.equ		sys_target	= varbase+238	;target pointer value


.CSEG
.include	"/usr/local/include/avr/m644Pdef.inc"
.include	"../../../system/includes/api_macros.inc"
.include	"../../../system/includes/libdef.asm"
.include	"../../../system/includes/definitions.asm"

.org	0x7200
;--------------------++++++++++++N
start:		.db "FIXLIBV0.22cN",0xd4,0xff,0x10
;icon
		.db 0xf2,0xf1,0xf1,0xf3
		.db "+-*/"
		.db 0xf4,0xf1,0xf1,0xf5

.org	0x7210
		rjmp	retzero			;dummy for autostart
		rjmp	init			;FKT  1 : INIT 
		rjmp	setint			;FKT  2 : set from INT
		rjmp	mlib_input		;FKT  3 : set from text
		rjmp	outint			;FKT  4 : output INT (return value)
		rjmp	print			;FKT  5 : output text
		rjmp	mlib_abs		;FKT  6 : set V2=ABS(V1)
		rjmp	mlib_inv		;FKT  7 : set V2=-V1

		rjmp	mlib_add		;FKT  8 : V3 = V1 + V2
		rjmp	mlib_sub		;FKT  9 : V3 = V1 - V2
		rjmp	mlib_mult		;FKT 10 : V3 = V1 * V2
		rjmp	mlib_div		;FKT 11 : V3 = V1 / V2
		rjmp	mlib_const		;FKT 12 : set V=predefined constant
		rjmp	mlib_int		;FKT 13 : set V2=INT(V1)
		rjmp	mlib_frac		;FKT 14 : set V2=FRAC(V1)
		rjmp	mlib_cmp		;FKT 15 : compare V1 <=> V2 and return (1,0,2)
		rjmp	mlib_copy		;FKT 16 : copy V1 to V2
		rjmp	mlib_mul2		;FKT 17 : V2 = V1 * 2
		rjmp	mlib_div2		;FKT 18 : V2 = V1 / 2
		rjmp	mlib_script		;FKT 19 : start script

retzero:	clr	XL
		clr	XH
		rjmp	retvalue
mlib_dummy:	ldi	XL,0xff
		ldi	XH,0xff
retvalue:	api_getvalues
		st	Y,XL
		std	Y+1,XH
		ret				;dummy function

;-------------------------------------------------------------------------------
; include functions
;-------------------------------------------------------------------------------
.include	"init.asm"
.include	"import_export.asm"
.include	"add_sub_cmp.asm"
.include	"single_op.asm"
.include	"mult.asm"
.include	"div.asm"
.include	"const.asm"
.include	"script.asm"
.include	"util.asm"

