;################################################################################
;#										#
;# FIXLIB - fixpoint math routines for ChipBasic2				#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; divide v1 / v2 -> v3
;-------------------------------------------------------------------------------
mlib_div:	rcall	getvar3
;calc result's sign
mlib_div_i:	rcall	mlib_mdsign		;sign for mult and div

		movw	r0,ZL

;clear result var
		mov	tempreg3,r18	;varsize-1
mlib_div_00:	st	Z+,const_0
		dec	tempreg3
		brne	mlib_div_00
		sts	sys_target,ZL
		sts	sys_target+1,ZH
		sub	ZL,r18
		sbc	ZH,const_0

		mov	tempreg3,r18	;varsize-1
		clr	r16			;v1 zero
		clr	r17			;v2 zero
mlib_div_01:	ld	tempreg1,X+		;var 1 byte
		cpi	tempreg1,0
		breq	mlib_div_02
		ldi	r16,1			;v1 is not zero
mlib_div_02:	ld	tempreg1,Y+		;var 2 byte
		cpi	tempreg1,0
		breq	mlib_div_03
		ldi	r17,1			;v2 is not zero
mlib_div_03:	dec	tempreg3
		brne	mlib_div_01
;n/0
		cpi	r17,0			;divider is zero
		brne	mlib_div_04
		ldi	ereg,3			;divide by 0
		rjmp	retzero
;0/m
mlib_div_04:	cpi	r16,0			;dividend is zero
		brne	mlib_div_06
		st	-Z,const_0		;clear sign
		rjmp	retzero			;result is always cleared

;correct pointers
mlib_div_06:	sub	XL,r18
		sbc	XH,const_0
		sub	YL,r18
		sbc	YH,const_0
		lds	r16,sys_vk		;right shift register
		dec	r16			;how many bytes the result must be shifted right
		clr	tempreg5		;dividend len=varsize-1
		clr	tempreg6		;divider len=varsize-1

;copy var1 to buffer 1 (dividend)
		lds	ZL,sys_buf1
		lds	ZH,sys_buf1+1
		st	Z+,const_0		;pre-zero
		clt
		mov	r19,r18		;varsize -1
		clr	r17			;no trailling zeroes
mlib_div_10:	ld	tempreg1,X+		;get byte
		brts	mlib_div_12
		cpi	tempreg1,0
		brne	mlib_div_12
		inc	r17			;one additional zero byte required
		inc	r16			;shift+1
		rjmp	mlib_div_14
mlib_div_12:	set				;set nonzero flag
		st	Z+,tempreg1
		inc	tempreg5
mlib_div_14:	dec	r19
		brne	mlib_div_10
mlib_div_16:	cpi	r17,0
		breq	mlib_div_18
		st	Z+,const_0
		dec	r17
		rjmp	mlib_div_16
mlib_div_18:	st	Z+,const_0

;copy var2 to buffer 2 (divider)
mlib_div_19:	lds	ZL,sys_buf2
		lds	ZH,sys_buf2+1
		clt
		mov	r19,r18			;varsize -1
		clr	r17			;no trailing zeroes
mlib_div_20:	ld	tempreg1,Y+		;get byte
		brts	mlib_div_22		;branch if nonzero flag is set
		cpi	tempreg1,0
		brne	mlib_div_22
		inc	r17			;one additional zero byte required
		dec	r16			;shift-1
		rjmp	mlib_div_24
mlib_div_22:	set
		st	Z+,tempreg1
		inc	tempreg6
mlib_div_24:	dec	r19
		brne	mlib_div_20
mlib_div_26:	cpi	r17,0
		breq	mlib_div_28
		st	Z+,const_0
		dec	r17
		rjmp	mlib_div_26
mlib_div_28:	st	Z+,const_0

;r16: shift counter
;r18: byte counter
;tempreg6: divider/dividend len
;r18-r16 quotient bytes

mlib_div_30:	sbrs	r16,7
		rjmp	mlib_div_40
mlib_div_32:	ldi	ereg,2			;overflow
mlib_div_34:	rjmp	retzero

mlib_div_40:	sub	r18,r16			;r18 are now quotient bytes
		breq	mlib_div_34		;=0
		brcs	mlib_div_34		;<0
		add	ZL,r16			;target ptr + rshift
		adc	ZH,const_0
;set buf 3
		lds	YL,sys_buf3
		lds	YH,sys_buf3+1
		lds	r19,sys_varsize
		dec	r19
		ldi	tempreg1,100
		st	Y+,tempreg1
mlib_div_42:	st	Y+,const_0
		dec	r19
		brne	mlib_div_42
;prepare vars
		clr	tempreg4		;round byte
;divide loop
mlib_div_50:	
;check if dividend >= divider
		lds	XL,sys_buf1		;dividend
		lds	XH,sys_buf1+1
		lds	YL,sys_buf2		;divider
		lds	YH,sys_buf2+1
		mov	r19,tempreg6		;divider len
mlib_div_52:	ld	tempreg1,X+		;dividend byte
		ld	tempreg2,Y+		;divider byte
		cp	tempreg1,tempreg2	;compare
		brcs	mlib_div_80		;divider is greater
		cp	tempreg2,tempreg1	;compare
		brcs	mlib_div_54		;dividend is greater
		dec	r19			;loop counter
		brne	mlib_div_52		;loop

mlib_div_54:
;dividend-=divider
mlib_subdd:	lds	XL,sys_buf1		;dividend
		lds	XH,sys_buf1+1
		lds	YL,sys_buf2		;divider
		lds	YH,sys_buf2+1
		add	XL,tempreg6		;add divider len
		adc	XH,const_0
		add	YL,tempreg6		;add divider len
		adc	YH,const_0
		mov	r19,tempreg6		;divider len
		clr	tempreg3		;carry
mlib_subdd_1:	ld	tempreg1,-X		;dividend byte
		ld	tempreg2,-Y		;divider byte
		lsr	tempreg3		;shift out carry
		sbc	tempreg1,tempreg2
		rol	tempreg3		;shift in carry
		sbrc	tempreg3,0
		subi	tempreg1,0x9c
		st	X,tempreg1
		dec	r19
		brne	mlib_subdd_1

;add buf 3 to quotient
mlib_addb3:	lds	YL,sys_buf3
		lds	YH,sys_buf3+1
		add	YL,r18
		adc	YH,const_0
		lds	ZL,sys_target
		lds	ZH,sys_target+1
		adiw	YL,1
		clr	tempreg3
		ld	tempreg2,-Y		;get buf3 byte
		subi	tempreg4,0x64		;+156
		lsr	tempreg3		;shift out carry
		adc	tempreg4,tempreg2	;add with carry
		rol	tempreg3		;shift in carry
		sbrs	tempreg3,0
		subi	tempreg4,0x9c

		mov	r19,r18

mlib_addb3_2:	ld	tempreg1,-Z		;get target byte
		ld	tempreg2,-Y		;get buf3 byte
		subi	tempreg1,0x64		;+156
		lsr	tempreg3		;shift out carry
		adc	tempreg1,tempreg2	;add with carry
		rol	tempreg3		;shift in carry
		sbrs	tempreg3,0
		subi	tempreg1,0x9c
		st	Z,tempreg1
		dec	r19
		brne	mlib_addb3_2

;dividend*2
mlib_div_80:	lds	XL,sys_buf1		;dividend
		lds	XH,sys_buf1+1
		mov	r19,tempreg5		;dividend len
		add	XL,r19			;add len
		adc	XH,const_0
		clr	tempreg3		;carry
		dec	r19
mlib_div_82:	ld	tempreg1,-X
		subi	tempreg1,0xb2		;+78
		lsr	tempreg3		;shift out carry
		adc	tempreg1,tempreg1	;*2 + carry
		rol	tempreg3
		sbrs	tempreg3,0		;skip if carry
		subi	tempreg1,0x9c		;-156
		st	X,tempreg1
		dec	r19
		brne	mlib_div_82
		ld	tempreg1,-X
		lsr	tempreg3		;shift out carry
		adc	tempreg1,tempreg1	;*2 + carry
		st	X,tempreg1

;buf3/2
mlib_div_84:	lds	XL,sys_buf3		;buf3
		lds	XH,sys_buf3+1
		mov	r19,r18			;quotient bytes
		inc	r19
		clr	tempreg2		;clear carry
		clr	r17			;nonzero flag

mlib_div_86:	ld	tempreg1,X
		sbrc	tempreg2,0
		subi	tempreg1,0x9c		;+100
		lsr	tempreg1
		rol	tempreg2
		st	X+,tempreg1
		or	r17,tempreg1
		dec	r19
		brne	mlib_div_86

		cpi	r17,0			;all zero
		breq	mlib_div_99
		rjmp	mlib_div_50

mlib_div_99:	rjmp	retzero
