;################################################################################
;#										#
;# FIXLIB - fixpoint math routines for ChipBasic2				#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; v1=const
;-------------------------------------------------------------------------------
mlib_const:	rcall	getvar1			;varptr
mlib_const_i:	mov	r17,XL
		andi	r17,0x07		;8 constants

		ldi	XL,LOW(mlib_tconst-start)
		ldi	XH,HIGH(mlib_tconst-start)
		api_dataptr			;set Z to ctable
		ldi	r18,8			;Bytes per constant
		mul	r18,r17
		add	ZL,r0
		adc	ZH,r1
		lds	r16,sys_varsize
mlib_const_1:	st	Y+,const_0
		dec	r16
		brne	mlib_const_1

		lds	r16,sys_nk
		sub	YL,r16
		sbc	YH,const_0
		sbiw	YL,1

		lpm	tempreg1,Z+		;pre comma byte
		st	Y+,tempreg1
mlib_const_4:	mov	r17,r16

mlib_const_6:	cpi	r16,0
		breq	mlib_const_8
		lpm	tempreg1,Z+		;post comma byte
		st	Y+,tempreg1
		dec	r16
		rjmp	mlib_const_6

mlib_const_8:	cpi	r17,7			;no rounding necessary
		breq	mlib_const_20
		
		lpm	tempreg1,Z+		;get next byte
		cpi	tempreg1,0x50
		brcs	mlib_const_20
		mov	r16,r17
		
		inc	r16			;
		ldi	tempreg2,1
		
mlib_const_10:	ld	tempreg1,-Y
		add	tempreg1,const_1
		st	Y,tempreg1
		cpi	tempreg1,100
		brcs	mlib_const_20
		subi	tempreg1,100
		st	Y,tempreg1
		dec	r16
		brne	mlib_const_10

mlib_const_20:	rjmp	retzero

;-------------------------------------------------------------------------------
; constant table
;-------------------------------------------------------------------------------
mlib_tconst:	.db	0,0,0,0,0,0,0,0			;0
		.db	1,0,0,0,0,0,0,0			;1
		.db	03,14,15,92,65,35,89,79		;PI
		.db	02,71,82,81,82,84,59,05		;E

		.db	00,69,31,47,18,05,59,95		;ln(2)
		.db	02,30,25,85,9,29,94,05		;ln(10)
		.db	01,41,42,13,56,23,73,10		;SQR(2)
		.db	01,73,20,50,80,75,68,88		;SQR(3)
