;################################################################################
;#										#
;# FIXLIB - fixpoint math routines for ChipBasic2				#
;# copyright (c) 2009-2010 Joerg Wolfram (joerg@jcwolfram.de)			#
;#										#
;# This library is free software; you can redistribute it and/or		#
;# modify it under the terms of the GNU Lesser General Public			#
;# License as published by the Free Software Foundation; either			#
;# version 3 of the License, or (at your option) any later version.		#
;#										#
;# This library is distributed in the hope that it will be useful,		#
;# but WITHOUT ANY WARRANTY; without even the implied warranty of		#
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU		#
;# Lesser General Public License for more details.				#
;#										#
;# You should have received a copy of the GNU Lesser General Public		#
;# License along with this library; if not, write to the			#
;# Free Software Foundation, Inc., 59 Temple Place - Suite 330,			#
;# Boston, MA 02111-1307, USA.							#
;#										#
;################################################################################

;-------------------------------------------------------------------------------
; add v1 + v2 -> v3
;-------------------------------------------------------------------------------
mlib_add:	rcall	getvar3
mlib_add_i:	ld	r19,X			;V1 sign
		ld	r18,Y			;V2 sign
		cp	r18,r19
		brne	mlib_add_2
		rcall	mlib_badd
mlib_add_1:	ld	r19,X
		st	Z,r19
		rjmp	retzero

mlib_add_2:	rcall	acheck			;check absolute values
		cpi	tempreg3,1		;|X|>|Y|
		brne	mlib_add_4
		rcall	mlib_bsub1		;X-Y
		rjmp	mlib_add_1
mlib_add_4:	cpi	tempreg3,2		;|Y|>|X|
		brne	mlib_add_6
		rcall	mlib_bsub2		;Y-X
		ld	r19,Y
		st	Z,r19
		rjmp	retzero

mlib_add_6:	lds	tempreg4,sys_varsize
mlib_add_8:	st	Z+,const_0
		dec	tempreg4
		brne	mlib_add_8
		rjmp	retzero

;-------------------------------------------------------------------------------
; sub v1 - v2 -> v3
;-------------------------------------------------------------------------------
mlib_sub:	rcall	getvar3
mlib_sub_i:	ld	r19,X			;V1 sign
		ld	r18,Y			;V2 sign
		cp	r18,r19
		breq	mlib_sub_2
		rcall	mlib_badd
		rjmp	mlib_add_1

mlib_sub_2:	rcall	acheck			;check absolute values
		cpi	tempreg3,1		;|X|>|Y|
		brne	mlib_sub_4
		rcall	mlib_bsub1		;X-Y
		ld	r19,X
		st	Z,r19
		rjmp	retzero

mlib_sub_4:	cpi	tempreg3,2		;|Y|>|X|
		brne	mlib_add_6
		rcall	mlib_bsub2		;Y-X
		ld	r19,Y
		eor	r19,const_1
		st	Z,r19
		rjmp	retzero

;-------------------------------------------------------------------------------
; set X,Y,Z to the end of V1,V2,V3
;-------------------------------------------------------------------------------
mlib_setend3:	lds	r16,sys_varsize
		add	XL,r16
		adc	XH,const_0
		add	YL,r16
		adc	YH,const_0
		add	ZL,r16
		adc	ZH,const_0
		dec	r16
		ldi	tempreg4,0		;carry
		ret

;-------------------------------------------------------------------------------
; add |X| + |Y| -> |Z|
;-------------------------------------------------------------------------------
mlib_badd:	rcall	mlib_setend3

mlib_badd_1:	ld	tempreg1,-X
		ld	tempreg2,-Y
		subi	tempreg1,0x64		;+156
		lsr	tempreg4		;shift out carry
		adc	tempreg1,tempreg2	;+ carry
		rol	tempreg4		;shift in carry
		sbrs	tempreg4,0
		subi	tempreg1,0x9c		;-156
		st	-Z,tempreg1
		dec	r16
		brne	mlib_badd_1

mlib_badd_2:	cpi	tempreg4,0
		breq	mlib_badd_4
		ldi	ereg,2			;overflow

mlib_badd_4:	sbiw	XL,1
		sbiw	YL,1
		sbiw	ZL,1
		ret

;-------------------------------------------------------------------------------
; sub |X| - |Y| -> |Z|
;-------------------------------------------------------------------------------
mlib_bsub1:	rcall	mlib_setend3

mlib_bsub1_1:	ld	tempreg1,-X
		ld	tempreg2,-Y
		lsr	tempreg4		;shift out carry
		sbc	tempreg1,tempreg2	;*2 + carry
		rol	tempreg4		;shift in carry
		sbrc	tempreg4,0
		subi	tempreg1,0x9c		;-156
		st	-Z,tempreg1
		dec	r16
		brne	mlib_bsub1_1
		rjmp	mlib_badd_4		;we cannot generate overflow

;-------------------------------------------------------------------------------
; sub |Y| - |X| -> |Z|
;-------------------------------------------------------------------------------
mlib_bsub2:	rcall	mlib_setend3

mlib_bsub2_1:	ld	tempreg1,-Y
		ld	tempreg2,-X
		lsr	tempreg4		;shift out carry
		sbc	tempreg1,tempreg2	;*2 + carry
		rol	tempreg4		;shift in carry
		sbrc	tempreg4,0
		subi	tempreg1,0x9c		;-156
		st	-Z,tempreg1
		dec	r16
		brne	mlib_bsub2_1
		rjmp	mlib_badd_4		;we cannot generate overflow

;-------------------------------------------------------------------------------
; ckeck |X| <=> |Y| -> tempreg3
; X=Y ->0
; X>Y ->1
; X<Y ->2
;-------------------------------------------------------------------------------
acheck:		movw	tempreg5,XL
		movw	tempreg7,YL
		adiw	XL,1			;skip sign
		adiw	YL,1
		lds	tempreg4,sys_varsize
		dec	tempreg4
		clr	tempreg3		;clear flag
acheck_1:	ld	r18,X+			;v1 byte
		ld	r19,Y+			;v2 byte
		cp	r18,r19			;check
		breq	acheck_3
		brcc	acheck_2		;branch if v1>v2
		ldi	tempreg3,0x02		;result: v1<v2
		rjmp	acheck_4

acheck_2:	ldi	tempreg3,0x01		;result: v1>v2
		rjmp	acheck_4

acheck_3:	dec	tempreg4
		brne	acheck_1
acheck_4:	movw	XL,tempreg5
		movw	YL,tempreg7
		ret

;-------------------------------------------------------------------------------
; ckeck b1 <=> b2
;-------------------------------------------------------------------------------
mlib_cmp:	rcall	getvar2			;get ptr to Y,Z 
mlib_cmp_i:	movw	XL,YL			;V1
		movw	YL,ZL			;V2
		ld	r16,X			;v1 sign
		ld	r17,Z			;v2 sign
		andi	r16,0x01
		andi	r17,0x01
		cp	r16,r17			;compare sign
		brcs	mlib_cmp_grt		;V1>V2
		brne	mlib_cmp_lss		;less
		rcall	acheck
		mov	XL,tempreg3
		clr	XH
		rjmp	retvalue		;return zero (v1=v2)
mlib_cmp_lss:	ldi	XL,2
		clr	XH
		rjmp	retvalue
mlib_cmp_grt:	ldi	XL,1
		clr	XH
		rjmp	retvalue

